/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import java.util.List;
import java.util.Objects;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="Class")
public final class ProfiledClass {
    public final PersistentKlassId id;
    public final KlassLoaderId loaderId;
    public final String name;
    public final PersistentKlassId superId;
    public final List<PersistentKlassId> interfaceIds;
    public final long fingerprint;
    public final KlassKind kind;
    public final Long vm_kid;
    public final String source;

    @ProfileVersion(value=23)
    public ProfiledClass(int id, int loaderId, String name, int superId, List<PersistentKlassId> interfaceIds, long fingerprint, KlassKind kind, long vmKid, String source) {
        this.id = PersistentKlassId.of(id);
        this.loaderId = KlassLoaderId.of(loaderId);
        this.name = name;
        this.superId = PersistentKlassId.of(superId);
        this.interfaceIds = interfaceIds;
        this.fingerprint = fingerprint;
        this.kind = kind;
        this.vm_kid = vmKid;
        this.source = source;
    }

    @ProfileVersion(value=14)
    public ProfiledClass(int id, int loaderId, String name, long fingerprint, KlassKind kind, long vmKid, String source) {
        this.id = PersistentKlassId.of(id);
        this.loaderId = KlassLoaderId.of(loaderId);
        this.name = name;
        this.superId = null;
        this.interfaceIds = null;
        this.fingerprint = fingerprint;
        this.kind = kind;
        this.vm_kid = null;
        this.source = source;
    }

    @ProfileVersion(value=9)
    public ProfiledClass(int id, int loaderId, String name, long fingerprint, KlassKind kind, String source) {
        this.id = PersistentKlassId.of(id);
        this.loaderId = KlassLoaderId.of(loaderId);
        this.name = name;
        this.superId = null;
        this.interfaceIds = null;
        this.fingerprint = fingerprint;
        this.kind = kind;
        this.vm_kid = null;
        this.source = source;
    }

    public final PersistentKlassId id() {
        return this.id;
    }

    public final KlassLoaderId loaderId() {
        return this.loaderId;
    }

    public final String name() {
        return this.name;
    }

    public final long fingerprint() {
        return this.fingerprint;
    }

    public final String source() {
        return this.source;
    }

    public final Key key() {
        return new Key(this.name, this.fingerprint);
    }

    public final int hashCode() {
        return (int)this.fingerprint;
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ProfiledClass)) {
            return false;
        }
        ProfiledClass thatClass = (ProfiledClass)that;
        return this.fingerprint == thatClass.fingerprint && Objects.equals(this.loaderId, thatClass.loaderId) && this.name.equals(thatClass.name);
    }

    public final String toString() {
        String line = "Class: " + this.id + " " + this.name + " " + this.fingerprint;
        if (this.source != null) {
            line = line + " " + this.source;
        }
        return line;
    }

    public static final class Key {
        public final String name;
        public final long fingerprint;

        private Key(String name, long fingerprint) {
            this.name = name;
            this.fingerprint = fingerprint;
        }

        public int hashCode() {
            return (int)this.fingerprint;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.fingerprint == that.fingerprint && this.name.equals(that.name);
        }

        public final String toString() {
            return this.name + " " + this.fingerprint;
        }
    }
}

