/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import java.util.Iterator;

public class CompileOptions {
    public static final int ENTRY_BCI = -2;
    public final Integer osrBci;
    public final CompilationTrigger trigger;
    public final StashFlavor stashLookup;
    public final OptLevel optHint;
    public final Boolean trySkipSignatureClassLoading;
    public final Boolean skipConstantLoading;
    public final Boolean priorityCompile;
    public final Boolean evictableCompilation;
    public final Long rnCompileId;

    public CompileOptions() {
        this((Integer)null);
    }

    public CompileOptions(Integer osrBci) {
        this.osrBci = osrBci;
        this.trigger = null;
        this.stashLookup = null;
        this.optHint = null;
        this.trySkipSignatureClassLoading = null;
        this.skipConstantLoading = null;
        this.priorityCompile = null;
        this.evictableCompilation = null;
        this.rnCompileId = null;
    }

    public CompileOptions(Iterable<Long> options) {
        OptionParser parser = new OptionParser(options.iterator());
        this.osrBci = parser.nextBci();
        this.trigger = this.decodeCompilationTrigger(parser.nextInt());
        this.stashLookup = this.decodeStashFlavor(parser.nextInt());
        this.optHint = this.decodeOptLevel(parser.nextInt());
        this.trySkipSignatureClassLoading = parser.nextBoolean();
        this.skipConstantLoading = parser.nextBoolean();
        this.priorityCompile = parser.nextBoolean();
        this.evictableCompilation = parser.nextBoolean();
        this.rnCompileId = parser.nextLong();
    }

    private OptLevel decodeOptLevel(int value) {
        switch (value) {
            case 0: {
                return OptLevel.O0;
            }
            case 1: {
                return OptLevel.O1;
            }
            case 2: {
                return OptLevel.O2;
            }
            case 3: {
                return OptLevel.O3;
            }
            case -1: {
                return OptLevel.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown value of falcon optimization level in compile options: " + value);
    }

    private CompilationTrigger decodeCompilationTrigger(int value) {
        switch (value) {
            case 0: {
                return CompilationTrigger.UNKNOWN;
            }
            case 1: {
                return CompilationTrigger.SOFT;
            }
            case 2: {
                return CompilationTrigger.HARD;
            }
        }
        throw new IllegalArgumentException("Unknown value of trigger in compile options: " + value);
    }

    private StashFlavor decodeStashFlavor(int value) {
        switch (value) {
            case 0: {
                return StashFlavor.DEFAULT;
            }
            case 1: {
                return StashFlavor.ONLY_LOOKUP;
            }
            case 2: {
                return StashFlavor.SKIP_LOOKUP;
            }
        }
        throw new IllegalArgumentException("Unknown value of stash lookup in compile options: " + value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.osrBci != null) {
            sb.append("osrBci: ").append(this.osrBci).append(' ');
        }
        if (this.trigger != null) {
            sb.append("trigger: ").append((Object)this.trigger).append(' ');
        }
        if (this.stashLookup != null) {
            sb.append("stashLookup: ").append((Object)this.stashLookup).append(' ');
        }
        if (this.optHint != null) {
            sb.append("optHint: ").append((Object)this.optHint).append(' ');
        }
        if (this.trySkipSignatureClassLoading != null) {
            sb.append("trySkipSignatureClassLoading: ").append(this.trySkipSignatureClassLoading).append(' ');
        }
        if (this.skipConstantLoading != null) {
            sb.append("skipConstantLoading: ").append(this.skipConstantLoading).append(' ');
        }
        if (this.priorityCompile != null) {
            sb.append("priorityCompile: ").append(this.priorityCompile).append(' ');
        }
        if (this.evictableCompilation != null) {
            sb.append("evictableCompilation: ").append(this.evictableCompilation).append(' ');
        }
        if (this.rnCompileId != null) {
            sb.append("rnCompileId: ").append(this.rnCompileId);
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.append('}').toString();
    }

    public boolean isOsr() {
        return this.osrBci != null;
    }

    private static final class OptionParser {
        private final Iterator<Long> rawOptions;

        OptionParser(Iterator<Long> rawOptions) {
            this.rawOptions = rawOptions;
        }

        Integer nextBci() {
            int value = this.rawOptions.next().intValue();
            return value == -2 ? null : Integer.valueOf(value);
        }

        int nextInt() {
            return this.rawOptions.next().intValue();
        }

        long nextLong() {
            return this.rawOptions.next();
        }

        boolean nextBoolean() {
            return this.nextLong() == 1L;
        }
    }
}

