/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.jvm.MemoryAddress;
import com.azul.jvm.ThreadId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompileEnqueued;
import com.azul.jvm.compile.CompileEventBuilder;
import com.azul.jvm.compile.CompileEvicted;
import com.azul.jvm.compile.CompileFailed;
import com.azul.jvm.compile.CompileInstalled;
import com.azul.jvm.compile.CompileMadeNotEntrant;
import com.azul.jvm.compile.CompilePromoted;
import com.azul.jvm.compile.CompileReplaced;
import com.azul.jvm.compile.CompileReplacing;
import com.azul.jvm.compile.CompileStarted;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import com.azul.jvm.compile.ZingInliningContext;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.logcompilation.WritingThread;
import com.azul.jvm.method.PersistentMethodId;
import java.time.Duration;

public class ZingCompileEventBuilder
extends CompileEventBuilder.Base<ZingCompileEventBuilder> {
    private ThreadId threadId;
    private Duration waitTime;
    private MemoryAddress blobAddress;
    private Integer blobSize;
    private Boolean hitStash;
    private Duration wallclockCompileTime;
    private Duration cpuCompileTime;
    private Long methodId;
    private PersistentMethodId persistentMethodId;
    private Integer klassId;
    private PersistentKlassId persistentKlassId;
    private CompilationTrigger waveTrigger = CompilationTrigger.UNKNOWN;
    private StashFlavor stashFlavor = StashFlavor.DEFAULT;
    private OptLevel optLevel;
    private String reason = "unknown";
    private Long scoreUpdated;
    private Integer generation;
    private Integer promoted;

    public ZingCompileEventBuilder scoreUpdated(Long s) {
        this.scoreUpdated = s;
        return this;
    }

    public ZingCompileEventBuilder methodId(Long methodId) {
        this.methodId = methodId;
        return this;
    }

    public ZingCompileEventBuilder persistentMethodId(long id) {
        this.persistentMethodId = PersistentMethodId.of(id);
        return this;
    }

    public ZingCompileEventBuilder klassId(Integer klassId) {
        this.klassId = klassId;
        return this;
    }

    public ZingCompileEventBuilder persistentKlassId(int id) {
        this.persistentKlassId = PersistentKlassId.of(id);
        return this;
    }

    public ZingCompileEventBuilder reason(String reason) {
        this.reason = reason;
        return this;
    }

    public ZingCompileEventBuilder waveTrigger(char waveTrigger) {
        this.waveTrigger = CompilationTrigger.fromChar(waveTrigger);
        return this;
    }

    public ZingCompileEventBuilder stashFlavor(char stashFlavor) {
        this.stashFlavor = StashFlavor.fromChar(stashFlavor);
        return this;
    }

    public ZingCompileEventBuilder threadId(int threadId) {
        this.threadId = ThreadId.of(threadId);
        return this;
    }

    public ZingCompileEventBuilder blobAddress(long address) {
        this.blobAddress = MemoryAddress.of(address);
        return this;
    }

    public ZingCompileEventBuilder blobSize(int size) {
        this.blobSize = size;
        return this;
    }

    public ZingCompileEventBuilder hitStash(boolean hit) {
        this.hitStash = hit;
        return this;
    }

    public ZingCompileEventBuilder waitMs(int waitMs) {
        this.waitTime = Duration.ofMillis(waitMs);
        return this;
    }

    public ZingCompileEventBuilder wallclockCompileTimeMs(int timeMs) {
        this.wallclockCompileTime = Duration.ofMillis(timeMs);
        return this;
    }

    public ZingCompileEventBuilder cpuCompileTimeMs(int timeMs) {
        this.cpuCompileTime = Duration.ofMillis(timeMs);
        return this;
    }

    public ZingCompileEventBuilder zingCompilerId(int compilerNum) {
        switch (compilerNum) {
            case 1: {
                this.tier(CompilationTier.TIER_1);
                this.compilerId(1);
                this.compiler("c1");
                break;
            }
            case 2: {
                this.tier(CompilationTier.TIER_2);
                this.compilerId(2);
                this.compiler("c2");
                break;
            }
            case 3: {
                this.tier(CompilationTier.TIER_2);
                this.compilerId(3);
                this.compiler("falcon");
                break;
            }
            default: {
                throw new IllegalStateException("bad compiler ID");
            }
        }
        return this;
    }

    public ZingCompileEventBuilder optLevel(OptLevel optLevel) {
        this.optLevel = optLevel;
        return this;
    }

    public ZingCompileEventBuilder generation(int generation) {
        this.generation = generation;
        return this;
    }

    public ZingCompileEventBuilder promoted(int promoted) {
        this.promoted = promoted;
        return this;
    }

    public final CompileData makeCompileData() {
        boolean native_ = false;
        boolean replacement = false;
        return new CompileData(this.id, native_, this.osr != null && this.osr != false, this.synchronized_, this.handlesExceptions, replacement, this.compilerId, this.tier, this.methodName, this.sig, this.entryBci, this.generation, this.score, this.bytes, this.waveTrigger, this.stashFlavor, this.optLevel, this.methodId, this.persistentMethodId, this.klassId, this.persistentKlassId, this.scoreUpdated, this.promoted);
    }

    public final CompileStarted makeStarted() {
        CompileStarted compile = new CompileStarted(this.makeCompileData(), this.waitTime);
        if (this.threadId != null) {
            compile.thread = new WritingThread(this.threadId.longValue());
        }
        return compile;
    }

    public final CompileInstalled makeInstall() {
        CompileInstalled installed = new CompileInstalled(this.makeCompileData(), this.blobAddress, this.blobSize, this.hitStash, this.waitTime, this.cpuCompileTime, this.wallclockCompileTime);
        if (this.threadId != null) {
            installed.thread = new WritingThread(this.threadId.longValue());
        }
        return installed;
    }

    public final CompileMadeNotEntrant makeNotEntrant() {
        return new CompileMadeNotEntrant(this.makeCompileData(), this.reason);
    }

    public final CompileFailed makeFailed() {
        CompileFailed failed = new CompileFailed(this.makeCompileData(), this.reason, this.waitTime, this.cpuCompileTime, this.wallclockCompileTime);
        if (this.threadId != null) {
            failed.thread = new WritingThread(this.threadId.longValue());
        }
        return failed;
    }

    public final CompileReplaced makeReplaced() {
        return new CompileReplaced(this.makeCompileData());
    }

    public final CompileReplacing makeReplacing() {
        return new CompileReplacing(this.makeCompileData());
    }

    public final ZingInliningContext makeInliningContext() {
        return new ZingInliningContext(this.makeCompileData());
    }

    public final CompileEnqueued makeEnqueued() {
        return new CompileEnqueued(this.makeCompileData());
    }

    public CompilePromoted makePromoted() {
        return new CompilePromoted(this.makeCompileData());
    }

    public CompileEvicted makeEvicted() {
        return new CompileEvicted(this.makeCompileData());
    }
}

