/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.text.Line;

public class ZephyrCompileLineParser {
    private static final char META_START_CHAR = '(';
    private static final char META_END_CHAR = ')';
    private static final char PREAMBLE_END_CHAR = '.';
    private static final char PAIR_END_CHAR = ';';
    private final char[] chars;
    private int pos = 0;
    private boolean inPreamble = false;
    private boolean inMeta = false;
    private int internalMark = -1;
    private boolean internalPreamble;
    private boolean internalMeta;

    public static int parseInt(String value) {
        return Integer.parseInt(value, 10);
    }

    public static int parseInt(String value, String unitSuffix) {
        if (!value.endsWith(unitSuffix)) {
            throw new IllegalArgumentException("missing or improper unit suffix: " + value);
        }
        String numPart = value.substring(0, value.length() - unitSuffix.length());
        return ZephyrCompileLineParser.parseInt(numPart);
    }

    public static int parseHexInt(String value) {
        String strippedValue = ZephyrCompileLineParser.removeHexPrefix(value);
        return Integer.parseInt(strippedValue, 16);
    }

    public static long parseLong(String value) {
        return Long.parseLong(value, 10);
    }

    public static long parseLong(String value, String unitSuffix) {
        if (!value.endsWith(unitSuffix)) {
            throw new IllegalArgumentException("missing or improper unit suffix: " + value);
        }
        String numPart = value.substring(0, value.length() - unitSuffix.length());
        return ZephyrCompileLineParser.parseLong(numPart);
    }

    public static long parseHexLong(String value) {
        String strippedValue = ZephyrCompileLineParser.removeHexPrefix(value);
        return Long.parseLong(strippedValue, 16);
    }

    private static String removeHexPrefix(String value) {
        if (!value.startsWith("0x")) {
            throw new IllegalArgumentException("missing hex prefix: '" + value + "'");
        }
        return value.substring(2);
    }

    public ZephyrCompileLineParser(Line line) {
        this.chars = line.toCharArray();
    }

    public void reset() {
        this.pos = 0;
        this.inPreamble = false;
        this.inMeta = false;
    }

    public boolean contains(String subs) {
        return String.valueOf(this.chars).contains(subs);
    }

    private void internalMark() {
        this.internalMark = this.pos;
        this.internalPreamble = this.inPreamble;
        this.internalMeta = this.inMeta;
    }

    private void internalClearMark() {
        this.internalMark = -1;
    }

    private void internalReset() {
        this.pos = this.internalMark;
        this.inPreamble = this.internalPreamble;
        this.inMeta = this.internalMeta;
        this.internalMark = -1;
    }

    private boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    private boolean isTokenTerminator(char ch) {
        if (Character.isWhitespace(ch)) {
            return true;
        }
        if (ch == ')' && this.inMeta) {
            return true;
        }
        if (ch == '.' && this.inPreamble) {
            return true;
        }
        return ch == ';' && this.inMeta;
    }

    private void chomp() {
        while (this.pos < this.chars.length && this.isWhitespace(this.chars[this.pos])) {
            ++this.pos;
        }
    }

    private void consume(char expectedCh) {
        char actualCh = this.chars[this.pos];
        if (actualCh != expectedCh) {
            throw new IllegalArgumentException("unexpected char: '" + actualCh + "' @ pos: " + this.pos + " expected: '" + expectedCh + "'");
        }
        ++this.pos;
    }

    public char peekChar() {
        if (this.pos >= this.chars.length) {
            return '\u0000';
        }
        this.internalMark();
        this.chomp();
        char ch = this.chars[this.pos];
        this.internalReset();
        return ch;
    }

    public char readChar() {
        this.chomp();
        return this.chars[++this.pos];
    }

    private void checkMeta(boolean expectedMeta) {
        if (this.inMeta != expectedMeta) {
            throw new IllegalStateException("Misuse of parsing API!");
        }
    }

    public final String readStringToken() {
        this.chomp();
        int startPos = this.pos;
        while (this.pos <= this.chars.length && !this.isTokenTerminator(this.chars[this.pos])) {
            ++this.pos;
            if (this.pos != this.chars.length) continue;
        }
        return new String(this.chars, startPos, this.pos - startPos);
    }

    private String[] readTokenPair() {
        String pair = this.readStringToken();
        int slashPos = pair.indexOf(47);
        if (slashPos == -1) {
            throw new IllegalStateException("expected pair: " + pair);
        }
        return new String[]{pair.substring(0, slashPos), pair.substring(slashPos + 1)};
    }

    private int readIntToken() {
        String token = this.readStringToken();
        return ZephyrCompileLineParser.parseInt(token);
    }

    private int readHexIntToken() {
        String token = this.readStringToken();
        return ZephyrCompileLineParser.parseHexInt(token);
    }

    private long readHexLongToken() {
        String token = this.readStringToken();
        return ZephyrCompileLineParser.parseHexLong(token);
    }

    private int readIntToken(String unitSuffix) {
        String token = this.readStringToken();
        return ZephyrCompileLineParser.parseInt(token, unitSuffix);
    }

    private long readLongToken() {
        String token = this.readStringToken();
        return ZephyrCompileLineParser.parseLong(token);
    }

    public boolean isEol() {
        this.internalMark();
        this.chomp();
        boolean isEol = this.pos >= this.chars.length;
        this.internalReset();
        return isEol;
    }

    public int readCompileId() {
        this.checkMeta(false);
        String token = this.readStringToken();
        int compileId = ZephyrCompileLineParser.parseInt(token);
        this.consume(' ');
        return compileId;
    }

    public char readFlag() {
        this.checkMeta(false);
        char flagCh = this.chars[this.pos];
        ++this.pos;
        return flagCh;
    }

    public boolean readFlag(char flagChar) {
        this.checkMeta(false);
        char readFlag = this.readFlag();
        if (readFlag == ' ') {
            return false;
        }
        if (readFlag == flagChar) {
            return true;
        }
        throw new IllegalArgumentException("unexpected flag char: " + readFlag + " - expected: " + flagChar);
    }

    public int readZingCompilerId() {
        this.checkMeta(false);
        return this.readIntToken();
    }

    public boolean matchesEventType(String eventType) {
        this.checkMeta(false);
        this.internalMark();
        this.inPreamble = true;
        boolean matches = this.matchesImpl(eventType);
        if (matches) {
            this.internalClearMark();
        } else {
            this.internalReset();
        }
        return matches;
    }

    public String readMethod() {
        this.checkMeta(false);
        this.chomp();
        this.inPreamble = false;
        return this.readStringToken();
    }

    public String readSignature() {
        this.checkMeta(false);
        return this.readStringToken();
    }

    public Long readAddress() {
        this.checkMeta(false);
        String tokenStr = this.readStringToken();
        if (tokenStr.equals("(nil)")) {
            return null;
        }
        return ZephyrCompileLineParser.parseHexLong(tokenStr);
    }

    public int readCodeSize() {
        this.checkMeta(false);
        return this.readHexIntToken();
    }

    public int readBci() {
        this.checkMeta(false);
        return this.readIntToken();
    }

    public ZephyrCompileLineParser expect(char expectedCh) {
        this.chomp();
        this.consume(expectedCh);
        return this;
    }

    public ZephyrCompileLineParser expect(String expectedStr) {
        if (!this.matches(expectedStr)) {
            throw new IllegalArgumentException(String.format("unexpected content: '%s' - expected: '%s'", this.readString(expectedStr.length()), expectedStr));
        }
        return this;
    }

    private String readString(int length) {
        String result = new String(this.chars, this.pos, length);
        this.pos += length;
        return result;
    }

    public boolean matches(String desiredStr) {
        this.internalMark();
        boolean matches = this.matchesImpl(desiredStr);
        if (matches) {
            this.internalClearMark();
        } else {
            this.internalReset();
        }
        return matches;
    }

    private boolean matchesImpl(String desiredStr) {
        boolean matches;
        this.chomp();
        int desiredLength = desiredStr.length();
        boolean bl = matches = desiredLength <= this.chars.length - this.pos && new String(this.chars, this.pos, desiredLength).equals(desiredStr);
        if (matches) {
            this.pos += desiredLength;
        }
        return matches;
    }

    public boolean isMetaInfoStart() {
        this.chomp();
        return this.peekChar() == '(';
    }

    public String readMetaInfoStart() {
        this.expect('(');
        this.inMeta = true;
        return this.readStringToken();
    }

    public int readMetaIntValue() {
        this.checkMeta(true);
        return this.readIntToken();
    }

    public int readMetaIntValue(String unitSuffix) {
        this.checkMeta(true);
        return this.readIntToken(unitSuffix);
    }

    public long readMetaLongValue() {
        this.checkMeta(true);
        return this.readLongToken();
    }

    public String readMetaStringValue() {
        this.checkMeta(true);
        return this.readStringToken();
    }

    public String readMetaField() {
        this.checkMeta(true);
        return this.readStringToken();
    }

    public void expectMetaField(String field) {
        this.checkMeta(true);
        String metaField = this.readMetaField();
        if (!metaField.equals(field)) {
            throw new IllegalArgumentException("unexpected 1st field: " + metaField);
        }
    }

    public void consumeMetaInfo() {
        this.checkMeta(true);
        while (this.chars[this.pos] != ')') {
            ++this.pos;
        }
        this.inMeta = false;
    }

    public String[] readMetaFieldPair() {
        this.checkMeta(true);
        return this.readTokenPair();
    }

    public void expectMetaFieldPair(String firstKey, String secondKey) {
        this.checkMeta(true);
        String[] fieldPair = this.readMetaFieldPair();
        if (!fieldPair[0].equals(firstKey)) {
            throw new IllegalArgumentException("unexpected 1st field: " + fieldPair[0]);
        }
        if (!fieldPair[1].equals(secondKey)) {
            throw new IllegalArgumentException("unexpected 2nd field" + fieldPair[1]);
        }
    }

    public String[] readMetaValuePair() {
        this.checkMeta(true);
        return this.readTokenPair();
    }

    public boolean isMetaInfoEnd() {
        return this.peekChar() == ')';
    }

    public void expectMetaInfoEnd() {
        this.expect(')');
        this.inMeta = false;
    }

    public String readStringPhrase() {
        this.chomp();
        StringBuilder sb = new StringBuilder();
        while (this.chars[this.pos] != '.') {
            sb.append(this.chars[this.pos]);
            ++this.pos;
        }
        ++this.pos;
        return sb.toString();
    }

    public void consumePreamble() {
        while (this.chars[this.pos] != '.') {
            ++this.pos;
        }
        ++this.pos;
    }
}

