/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.Emitter;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.jvm.compile.OptLevel;
import com.azul.zing.console.matchers.ZephyrCompileLineParser;
import com.azul.zing.console.matchers.ZingCompileEventBuilder;

public abstract class ZephyrCompileLineMatcher<T>
implements LineMatcher<T> {
    private final String eventType;
    private final String eventNeedle;

    public ZephyrCompileLineMatcher(String eventTag) {
        this.eventType = eventTag;
        this.eventNeedle = " " + eventTag;
    }

    @Override
    public final void process(Line line, Emitter<T> emitter) throws Exception {
        boolean osr;
        if (!line.contains(this.eventNeedle)) {
            return;
        }
        ZingCompileEventBuilder builder = new ZingCompileEventBuilder();
        ZephyrCompileLineParser parser = new ZephyrCompileLineParser(line);
        try {
            builder.id(parser.readCompileId());
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            builder.synchronized_(parser.readFlag('s'));
            builder.handlesExceptions(parser.readFlag('!'));
            builder.blocking(parser.readFlag('b'));
            osr = parser.readFlag('%');
            builder.waveTrigger(parser.readFlag());
            builder.stashFlavor(parser.readFlag());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        builder.osr(osr);
        try {
            builder.zingCompilerId(parser.readZingCompilerId());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (!parser.matchesEventType(this.eventType)) {
            return;
        }
        this.processPreamble(parser, builder);
        builder.methodName(parser.readMethod());
        builder.signature(parser.readSignature());
        if (osr) {
            parser.expect('@');
            builder.osr(parser.readBci());
        }
        while (parser.isMetaInfoStart()) {
            String metaStart;
            switch (metaStart = parser.readMetaInfoStart()) {
                case "tid": {
                    ZephyrCompileLineMatcher.processThreadMetaInfo(parser, builder);
                    break;
                }
                case "kid": {
                    ZephyrCompileLineMatcher.processKidMetaInfo(parser, builder);
                    break;
                }
                case "mid": {
                    ZephyrCompileLineMatcher.processMidMetaInfo(parser, builder);
                    break;
                }
                case "bytes": {
                    ZephyrCompileLineMatcher.processBytes(parser, builder);
                    break;
                }
                case "generation": {
                    ZephyrCompileLineMatcher.processGeneration(parser, builder);
                    break;
                }
                case "score": {
                    ZephyrCompileLineMatcher.processScore(parser, builder);
                    break;
                }
                case "wait": {
                    ZephyrCompileLineMatcher.processWait(parser, builder);
                    break;
                }
                case "compile": {
                    ZephyrCompileLineMatcher.processCompileTimes(parser, builder);
                    break;
                }
                case "score_updated": {
                    ZephyrCompileLineMatcher.processScoreUpdated(parser, builder);
                    break;
                }
                case "lvl": {
                    ZephyrCompileLineMatcher.processOptLevel(parser, builder);
                    break;
                }
                default: {
                    ZephyrCompileLineMatcher.processUnhandled(parser);
                }
            }
            parser.expectMetaInfoEnd();
        }
        emitter.fire(this.fromMatch(builder));
    }

    protected void processPreamble(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
    }

    protected abstract T fromMatch(ZingCompileEventBuilder var1);

    static void processThreadMetaInfo(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.threadId(parser.readMetaIntValue());
    }

    static void processKidMetaInfo(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        int kid = parser.readMetaIntValue();
        parser.expectMetaFieldPair("pkid", "prev");
        String[] valuePair = parser.readMetaValuePair();
        int pkid = ZephyrCompileLineParser.parseInt(valuePair[0]);
        Integer prevKid = valuePair[1].equals("NA") ? null : Integer.valueOf(ZephyrCompileLineParser.parseInt(valuePair[1]));
        builder.klassId(kid).persistentKlassId(pkid);
    }

    static void processMidMetaInfo(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        long mid = parser.readMetaLongValue();
        parser.expectMetaField("pmid");
        long pmid = parser.readMetaLongValue();
        builder.methodId(mid).persistentMethodId(pmid);
    }

    static void processBytes(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.bytes(parser.readMetaIntValue());
    }

    static void processGeneration(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        int generation = parser.readMetaIntValue();
        builder.generation(generation);
    }

    static void processScore(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.score(parser.readMetaIntValue());
    }

    static void processScoreUpdated(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.scoreUpdated(Long.valueOf(parser.readMetaIntValue("ms")));
        parser.expect(';');
        parser.expectMetaField("orig");
        parser.readMetaIntValue();
        parser.expect(';');
        parser.expectMetaField("promoted");
        builder.promoted(parser.readMetaIntValue());
        parser.consumeMetaInfo();
    }

    static void processWait(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.waitMs(parser.readMetaIntValue("ms"));
    }

    static void processCompileTimes(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        String[] valuePair = parser.readMetaValuePair();
        builder.cpuCompileTimeMs(ZephyrCompileLineParser.parseInt(valuePair[0], "ms"));
        builder.wallclockCompileTimeMs(ZephyrCompileLineParser.parseInt(valuePair[1], "ms"));
        if (parser.peekChar() == ';') {
            parser.readChar();
            parser.readStringToken();
            parser.readStringToken();
        }
    }

    static void processOptLevel(ZephyrCompileLineParser parser, ZingCompileEventBuilder builder) {
        builder.optLevel(OptLevel.fromString(parser.readMetaField()));
        parser.consumeMetaInfo();
    }

    static void processUnhandled(ZephyrCompileLineParser parser) {
        parser.consumeMetaInfo();
    }
}

