/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.HandledMarker;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.gulp.text.RegexMatcher;
import com.azul.java.MethodId;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.ThreadId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopts.UncommonTrap;
import com.azul.zing.console.matchers.FrameRepackLineMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class HighlanderUncommonTrapLineMatcher
implements LineMatcher<UncommonTrap> {
    private static final Pattern TRAP_REGEX = Pattern.compile("^\\s*Uncommon trap \\#(\\d+) occurred in\\s+([\\w\\d\\.\\:\\$\\<\\>]*)\\s+\\(\\@[0x]+([\\dabcdef]+)\\) thread = (\\d+), deopt_index = (\\w+), compile_id = (\\d+).*$");
    private static final Pattern IMMEDIATE_RECOMP_REGEX = Pattern.compile("^\\s*Immediately start recompiling while keeping method entrant .* thread = (\\d+), deopt_index = (.*), osr=(.*) start_bci=([-]*\\d+) compile_id = (\\d+) m_type=(\\d+).*");
    @Gulp.Inject
    private HandledMarker<Line> lineMarker;
    private TrapInfo trapInfo;
    private boolean sawRepack;

    @Override
    public void process(Line line, Emitter<UncommonTrap> emitter) throws Exception {
        UncommonTrap.Repack repack;
        RegexMatcher matcher;
        if (this.trapInfo == null) {
            RegexMatcher matcher2 = line.match(TRAP_REGEX);
            if (matcher2.matches()) {
                this.lineMarker.mark(line);
                this.processTrap(matcher2);
                this.sawRepack = false;
            }
            return;
        }
        if (!this.sawRepack && (matcher = line.match(IMMEDIATE_RECOMP_REGEX)).matches()) {
            this.lineMarker.mark(line);
            this.trapInfo.action = DeoptAction.REPLACEMENT_COMPILE;
        }
        if ((repack = FrameRepackLineMatcher.match(line)) != null) {
            this.trapInfo.repacks.add(repack);
            this.lineMarker.mark(line);
            this.sawRepack = true;
            if (FrameRepackLineMatcher.isLastLine(line)) {
                this.fire(emitter);
            }
        }
    }

    private void processTrap(RegexMatcher matcher) {
        this.trapInfo = new TrapInfo();
        this.trapInfo.num = matcher.nextInt();
        this.trapInfo.method = matcher.nextString();
        this.trapInfo.address = MemoryAddress.of(matcher.nextInt(16).intValue());
        this.trapInfo.thread = ThreadId.of(matcher.nextInt().intValue());
        this.trapInfo.reason = matcher.nextString();
        this.trapInfo.compileId = CompilationId.of(matcher.nextInt());
        this.trapInfo.action = null;
    }

    private void fire(Emitter<UncommonTrap> emitter) {
        emitter.fire(new UncommonTrap(this.trapInfo.num, MethodId.byNameOnly(this.trapInfo.method), this.trapInfo.address, this.trapInfo.thread, this.trapInfo.reason, this.trapInfo.compileId, this.trapInfo.action, this.trapInfo.repacks));
        this.trapInfo = null;
    }

    private static final class TrapInfo {
        int num;
        String method;
        MemoryAddress address;
        ThreadId thread;
        String reason;
        CompilationId compileId;
        DeoptAction action;
        List<UncommonTrap.Repack> repacks = new ArrayList<UncommonTrap.Repack>(10);

        private TrapInfo() {
        }
    }
}

