/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing;

import com.azul.gulp.foundations.GulpLogBase;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusEmitter;
import com.azul.gulp.sources.PipelineConfiguration;
import com.azul.zing.zvrobot.TickProfileFile;
import com.azul.zing.zvrobot.ZVRobotDir;
import com.azul.zing.zvrobot.tickprofile.ProcessInfo;
import com.azul.zing.zvrobot.tickprofile.ProfileEntry;
import com.azul.zing.zvrobot.tickprofile.TickProfileProcessor;
import java.util.Arrays;
import java.util.List;

public final class ZingTickLog
extends GulpLogBase<ZingTickLog> {
    private final TickProfileFilesProvider filesProvider;

    public ZingTickLog(ZVRobotDir zvRobotDir) {
        this(() -> zvRobotDir.listTickProfiles());
    }

    private ZingTickLog(TickProfileFilesProvider filesProvider) {
        this.filesProvider = filesProvider;
    }

    private ZingTickLog(ZingTickLog parent, PipelineConfiguration pipelineConfig) {
        super(pipelineConfig);
        this.filesProvider = parent.filesProvider;
    }

    @Override
    protected final List<Class<?>> coreTypes() {
        return Arrays.asList(ProcessInfo.class, ProfileEntry.class);
    }

    @Override
    protected final void run(Nexus nexus) throws Exception {
        final NexusEmitter<ProcessInfo> processEmitter = nexus.getEmitter(ProcessInfo.class);
        final NexusEmitter<ProfileEntry> entryEmitter = nexus.getEmitter(ProfileEntry.class);
        for (TickProfileFile tickFile : this.filesProvider.files()) {
            tickFile.process(new TickProfileProcessor(){

                @Override
                public void onProcessInfo(ProcessInfo processInfo) {
                    processEmitter.fire(processInfo);
                }

                @Override
                public void onEntry(ProfileEntry entry) {
                    entryEmitter.fire(entry);
                }
            });
        }
    }

    @Override
    protected ZingTickLog createOffspring(PipelineConfiguration pipelineConfig) {
        return new ZingTickLog(this, pipelineConfig);
    }

    public static interface TickProfileFilesProvider {
        public Iterable<TickProfileFile> files();
    }
}

