/*
 * Decompiled with CFR 0.152.
 */
package com.azul.xml.sax;

import com.azul.xml.sax.AttributeConverter;
import org.xml.sax.helpers.AttributesImpl;

public final class Attributes
implements org.xml.sax.Attributes {
    private final org.xml.sax.Attributes rawAttributes;

    public Attributes(org.xml.sax.Attributes attributes) {
        this.rawAttributes = new AttributesImpl(attributes);
    }

    @Override
    public final int getLength() {
        return this.rawAttributes.getLength();
    }

    @Override
    public final String getURI(int index) {
        return this.rawAttributes.getURI(index);
    }

    @Override
    public final String getLocalName(int index) {
        return this.rawAttributes.getLocalName(index);
    }

    @Override
    public final String getQName(int index) {
        return this.rawAttributes.getQName(index);
    }

    @Override
    public final String getType(int index) {
        return this.rawAttributes.getType(index);
    }

    @Override
    public final String getValue(int index) {
        return this.rawAttributes.getValue(index);
    }

    @Override
    public final int getIndex(String uri, String localName) {
        return this.rawAttributes.getIndex(uri, localName);
    }

    @Override
    public final int getIndex(String qName) {
        return this.rawAttributes.getIndex(qName);
    }

    @Override
    public final String getType(String uri, String localName) {
        return this.rawAttributes.getType(uri, localName);
    }

    @Override
    public final String getType(String qName) {
        return this.rawAttributes.getType(qName);
    }

    public final boolean has(String uri, String localName) {
        return this.getString(uri, localName) != null;
    }

    public final boolean has(String qName) {
        return this.getString(qName) != null;
    }

    public final String getString(String uri, String localName) {
        return this.rawAttributes.getValue(uri, localName);
    }

    public final String getString(String qName) {
        return this.rawAttributes.getValue(qName);
    }

    @Override
    public final String getValue(String uri, String localName) {
        return this.rawAttributes.getValue(uri, localName);
    }

    @Override
    public final String getValue(String qName) {
        return this.rawAttributes.getValue(qName);
    }

    public final Integer getInteger(String uri, String localName) {
        String val = this.getValue(uri, localName);
        return val == null ? null : Integer.valueOf(Integer.parseInt(val, 10));
    }

    public final Integer getInteger(String qName) {
        String val = this.getValue(qName);
        return val == null ? null : Integer.valueOf(Integer.parseInt(val, 10));
    }

    public final int getIntegerOrDefault(String uri, String localName, int defaultVal) {
        String val = this.getValue(uri, localName);
        return val == null ? defaultVal : Integer.parseInt(val, 10);
    }

    public final int getIntegerOrDefault(String qName, int defaultVal) {
        String val = this.getValue(qName);
        return val == null ? defaultVal : Integer.parseInt(val, 10);
    }

    public final Long getLong(String uri, String localName) {
        String val = this.getValue(uri, localName);
        return val == null ? null : Long.valueOf(Long.parseLong(val, 10));
    }

    public final Long getLong(String qName) {
        String val = this.getValue(qName);
        return val == null ? null : Long.valueOf(Long.parseLong(val, 10));
    }

    public final long getLongOrDefault(String uri, String localName, long defaultValue) {
        String val = this.getValue(uri, localName);
        return val == null ? defaultValue : Long.parseLong(val);
    }

    public final long getLongOrDefault(String qName, long defaultValue) {
        String val = this.getValue(qName);
        return val == null ? defaultValue : Long.parseLong(val);
    }

    public final Double getDouble(String uri, String localName) {
        String val = this.getValue(uri, localName);
        return val == null ? null : Double.valueOf(Double.parseDouble(val));
    }

    public final Double getDouble(String qName) {
        String val = this.getValue(qName);
        return val == null ? null : Double.valueOf(Double.parseDouble(val));
    }

    public final double getDoubleOrDefault(String uri, String localName, double defaultValue) {
        String val = this.getValue(uri, localName);
        return val == null ? defaultValue : Double.parseDouble(val);
    }

    public final double getDoubleOrDefault(String qName, double defaultValue) {
        String val = this.getValue(qName);
        return val == null ? defaultValue : Double.parseDouble(val);
    }

    public final <T> T get(String uri, String localName, AttributeConverter<T> converter) {
        String val = this.getValue(uri, localName);
        return val == null ? null : (T)converter.convert(val);
    }

    public final <T> T get(String qName, AttributeConverter<T> converter) {
        String val = this.getValue(qName);
        return val == null ? null : (T)converter.convert(val);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.rawAttributes.getLength(); ++i) {
            builder.append(this.rawAttributes.getQName(i));
            builder.append('=');
            builder.append(this.rawAttributes.getValue(i));
            builder.append(' ');
        }
        return builder.toString();
    }
}

