/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.UncommonTrapBuilder;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.zing.profilelog.ProfiledUncommonTrapEnd;
import java.util.Map;
import java.util.Objects;

public class UncommonTrapTransformer {
    private static final String TAG = "RN_UNCOMMON_TRAP";
    private static final String REPACK_TAG = "RN_REPACK";
    private final LogWriter writer;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final Map<CompilationId, CompilationBuilder> compilationById;
    private final Map<PersistentMethodId, MethodBuilder> methodById;
    private final Map<UncommonTrapId, UncommonTrapBuilder> trapById;

    public UncommonTrapTransformer(LogWriter writer, Map<PersistentKlassId, KlassBuilder> klassById, Map<CompilationId, CompilationBuilder> compilationById, Map<PersistentMethodId, MethodBuilder> methodById, Map<UncommonTrapId, UncommonTrapBuilder> trapById) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        this.compilationById = Objects.requireNonNull(compilationById, "compilationById");
        this.methodById = Objects.requireNonNull(methodById, "methodById");
        this.trapById = Objects.requireNonNull(trapById, "trapById");
        writer.writeHeader(TAG, "trapId", "compilationId", "tier", "thread", "loaderId", "classId", "klass", "method", "signature", "reason", "action", "persistentStackOverflow");
        writer.writeHeader(REPACK_TAG, "trapId", "loaderId", "classId", "klass", "method", "signature", "bci", "opcode");
    }

    public void process(ProfiledUncommonTrapEnd uncommonTrapEnd) {
        UncommonTrapBuilder trap = this.trapById.get(uncommonTrapEnd.id);
        if (trap == null) {
            System.err.println("NO UNCOMMON_TRAP RECORD FOR: " + uncommonTrapEnd);
            return;
        }
        CompilationBuilder compilation = this.compilationById.get(trap.compilationId());
        if (compilation == null) {
            System.err.println("NO COMPILATION RECORD FOR: " + uncommonTrapEnd);
            return;
        }
        MethodBuilder method = this.methodById.get(compilation.methodId());
        if (method == null) {
            System.err.println("NO METHOD RECORD FOR: " + uncommonTrapEnd);
            return;
        }
        KlassBuilder klass = this.klassById.get(method.klassId());
        if (klass == null) {
            System.err.println("NO CLASS RECORD FOR: " + uncommonTrapEnd);
            return;
        }
        this.writer.writeLine(uncommonTrapEnd.epochTime, TAG, new Object[]{trap.id(), trap.compilationId(), compilation.tier(), trap.thread(), klass.getDefiningLoaderId(), klass.id(), klass.getName(), method.name(), method.signature(), trap.reasonStr(), trap.action(), uncommonTrapEnd.stackTruncated});
        trap.frameRepacks().forEachOrdered(stackFrame -> {
            String methodName = "INVALID_METHOD_NAME";
            String methodSignature = "INVALID_METHOD_SIGNATURE";
            String definingLoaderId = "INVALID_LOADER_ID";
            String klassId = "INVALID_KID";
            String klassName = "INVALID_KLASS_NAME";
            MethodBuilder frameMethod = this.methodById.get(stackFrame.methodId());
            if (frameMethod != null) {
                methodName = frameMethod.name();
                methodSignature = frameMethod.signature().toString();
                KlassBuilder frameKlass = this.klassById.get(frameMethod.klassId());
                if (frameKlass != null) {
                    definingLoaderId = frameKlass.getDefiningLoaderId().toString();
                    klassId = frameKlass.id().toString();
                    klassName = frameKlass.getName();
                } else {
                    System.err.println("NO CLASS RECORD FOR: " + frameMethod.klassId());
                }
            } else {
                System.err.println("NO METHOD RECORD FOR: " + stackFrame.methodId());
            }
            this.writer.writeLine(uncommonTrapEnd.epochTime, REPACK_TAG, new Object[]{trap.id(), definingLoaderId, klassId, klassName, methodName, methodSignature, stackFrame.bci(), stackFrame.opcode()});
        });
    }
}

