/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.gulp.GenericProcessor;
import com.azul.gulp.Gulp;
import com.azul.gulp.GulpLog;
import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.UncommonTrapBuilder;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoader;
import com.azul.jvm.klassloader.KlassLoaderBuilder;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.tools.profile2xlog.impl.ClassInitTransformer;
import com.azul.tools.profile2xlog.impl.ClassLoadTransformer;
import com.azul.tools.profile2xlog.impl.ClassLoaderMatchTransformer;
import com.azul.tools.profile2xlog.impl.ClassPartialLinkTransformer;
import com.azul.tools.profile2xlog.impl.ClassUnloadTransformer;
import com.azul.tools.profile2xlog.impl.CompilationTransformer;
import com.azul.tools.profile2xlog.impl.FirstCallTransformer;
import com.azul.tools.profile2xlog.impl.InstallTransformer;
import com.azul.tools.profile2xlog.impl.LogDecorator;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.tools.profile2xlog.impl.UncommonTrapTransformer;
import com.azul.tools.profile2xlog.impl.VmStartTransformer;
import com.azul.zing.profilelog.ProfileVmStart;
import com.azul.zing.profilelog.ProfiledClassInit;
import com.azul.zing.profilelog.ProfiledClassLoad;
import com.azul.zing.profilelog.ProfiledClassLoaderMatch;
import com.azul.zing.profilelog.ProfiledClassPartialLink;
import com.azul.zing.profilelog.ProfiledClassUnload;
import com.azul.zing.profilelog.ProfiledFirstCall;
import com.azul.zing.profilelog.ProfiledTier1Compilation;
import com.azul.zing.profilelog.ProfiledTier1Install;
import com.azul.zing.profilelog.ProfiledTier2Compilation;
import com.azul.zing.profilelog.ProfiledTier2Install;
import com.azul.zing.profilelog.ProfiledUncommonTrapEnd;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;

public final class LogTransformer {
    private final Map<KlassLoaderId, ? extends KlassLoader> loaderById;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final Map<CompilationId, CompilationBuilder> compilationById;
    private final Map<PersistentMethodId, MethodBuilder> methodById;
    private final Map<UncommonTrapId, UncommonTrapBuilder> trapById;

    public LogTransformer(Map<KlassLoaderId, KlassLoaderBuilder> loaderById, Map<PersistentKlassId, KlassBuilder> klassById, Map<CompilationId, CompilationBuilder> compilationById, Map<PersistentMethodId, MethodBuilder> methodById, Map<UncommonTrapId, UncommonTrapBuilder> trapById) {
        this.loaderById = Objects.requireNonNull(loaderById, "loaderById");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        this.compilationById = Objects.requireNonNull(compilationById, "compilationById");
        this.methodById = Objects.requireNonNull(methodById, "methodById");
        this.trapById = Objects.requireNonNull(trapById, "trapById");
    }

    public void process(GulpLog log, LogDecorator outputDecorator, PrintWriter writer) {
        LogWriter logWriter = new LogWriter(writer, outputDecorator);
        final VmStartTransformer vmStartTransformer = new VmStartTransformer(logWriter);
        final ClassLoaderMatchTransformer classLoaderMatchTransformer = new ClassLoaderMatchTransformer(logWriter, this.loaderById, this.klassById);
        final ClassLoadTransformer classLoadTransformer = new ClassLoadTransformer(logWriter, this.klassById, this.loaderById);
        final ClassPartialLinkTransformer classPartialLinkTransformer = new ClassPartialLinkTransformer(logWriter, this.klassById, this.loaderById);
        final ClassInitTransformer classInitTransformer = new ClassInitTransformer(logWriter, this.klassById, this.loaderById);
        final ClassUnloadTransformer classUnloadTransformer = new ClassUnloadTransformer(logWriter, this.klassById, this.loaderById);
        final CompilationTransformer compilationTransformer = new CompilationTransformer(logWriter, this.compilationById, this.methodById, this.klassById);
        final InstallTransformer installTransformer = new InstallTransformer(logWriter, this.compilationById, this.methodById, this.klassById);
        final FirstCallTransformer firstCallTransformer = new FirstCallTransformer(logWriter, this.loaderById, this.klassById, this.compilationById, this.methodById);
        final UncommonTrapTransformer uncommonTrapTransformer = new UncommonTrapTransformer(logWriter, this.klassById, this.compilationById, this.methodById, this.trapById);
        log.process(new GenericProcessor(){

            @Gulp.Process(optional=true)
            public void process(ProfileVmStart vmStart) {
                vmStartTransformer.process(vmStart);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledClassLoaderMatch profiledClassLoaderMatch) {
                classLoaderMatchTransformer.process(profiledClassLoaderMatch);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledClassLoad profiledCLassLoad) {
                classLoadTransformer.process(profiledCLassLoad);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledClassPartialLink classPartialLink) {
                classPartialLinkTransformer.process(classPartialLink);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledClassInit classInit) {
                classInitTransformer.process(classInit);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledClassUnload classUnload) {
                classUnloadTransformer.process(classUnload);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledTier1Compilation compilation) {
                compilationTransformer.process(compilation);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledTier2Compilation compilation) {
                compilationTransformer.process(compilation);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledTier1Install install) {
                installTransformer.process(install);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledTier2Install install) {
                installTransformer.process(install);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledFirstCall firstCall) {
                firstCallTransformer.process(firstCall);
            }

            @Gulp.Process(optional=true)
            public void process(ProfiledUncommonTrapEnd uncommonTrapEnd) {
                uncommonTrapTransformer.process(uncommonTrapEnd);
            }
        });
    }
}

