/*
 * Decompiled with CFR 0.152.
 */
package com.azul.openjdk.console.matchers;

import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.gulp.text.support.RegexLineMatcher;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompilerId;
import com.azul.jvm.compile.StashFlavor;
import com.azul.openjdk.logcompilation.CompilationLevel;
import java.util.regex.Pattern;

public abstract class BaseOpenJdkTieredCompilationLineMatcher<T>
extends RegexLineMatcher<T> {
    private static final Pattern COMP_PATTERN = Pattern.compile("\\s*(\\d+)\\s*([ \\%])([ s])([ \\!])([ b])\\s+(\\d)\\s+([\\w\\.\\$]+::[\\w\\$<>]+)(?: @\\s+(\\d+))?\\s+\\((\\d+) bytes\\)\\s*(.*)");

    public BaseOpenJdkTieredCompilationLineMatcher() {
        super(COMP_PATTERN);
    }

    @Override
    public final T fromMatch(Line line, RegexMatcher matcher) throws Exception {
        int bytes;
        CompilationId id = CompilationId.of(matcher.nextInt());
        boolean isNative = false;
        boolean isOsr = matcher.nextChar().equals(Character.valueOf('%'));
        boolean isSynchronized = matcher.nextChar().equals(Character.valueOf('s'));
        boolean hasExceptionHandler = matcher.nextChar().equals(Character.valueOf('!'));
        boolean isBlocking = matcher.nextChar().equals(Character.valueOf('b'));
        boolean isReplacement = false;
        int openjdkTier = matcher.nextInt();
        String method = matcher.nextString();
        String signature = null;
        Integer osrBci = matcher.nextInt();
        int score = bytes = matcher.nextInt().intValue();
        String action = matcher.nextString().trim();
        CompilationLevel level = CompilationLevel.fromInt(openjdkTier);
        CompilationTier tier = level.tier();
        CompilerId compilerId = level.compilerId();
        CompileData compileData = new CompileData(id, isNative, isOsr, isSynchronized, hasExceptionHandler, isReplacement, compilerId, tier, method, signature, osrBci, null, score, bytes, CompilationTrigger.UNKNOWN, StashFlavor.DEFAULT, null, null, null, null, null, -1L, null);
        return this.fromMatch(compileData, action);
    }

    protected abstract T fromMatch(CompileData var1, String var2);
}

