/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer;

import com.azul.log.gui.config.api.Config;
import com.azul.log.parser.impl.c4.custom.C4_CustomLineParsersSupport;
import com.azul.log.utils.CommonUtils;
import com.azul.loganalyzer.Arguments;
import com.azul.loganalyzer.LogAnalyzerGuiImpl;
import com.azul.loganalyzer.LogAnalyzerHeadlessImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Main {
    public static void main(String[] arguments) {
        Locale.setDefault(Locale.US);
        Config.init();
        Arguments args = new Arguments(arguments, "GCLogAnalyzer2.jar", "/usage.txt");
        try {
            args.parse();
            if (args.help) {
                args.printUsage();
                System.exit(0);
            }
            Main.start(args);
        }
        catch (Exception ex) {
            if (args.help) {
                args.printUsage();
                System.exit(0);
            }
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getMessage());
            ex.printStackTrace(System.err);
            System.out.println();
            args.printUsage();
            System.exit(1);
        }
    }

    private static void start(Arguments args) throws Exception {
        boolean uiMode = args.htmlDumpDir == null && args.dumpRawDataFile == null;
        try {
            C4_CustomLineParsersSupport.setDefaultCustomJsonUri(args.customJsonUri);
        }
        catch (Throwable ex) {
            String javaSecurityManagerProperty;
            if (ex.getCause() instanceof UnsupportedOperationException && !"allow".equals(javaSecurityManagerProperty = System.getProperty("java.security.manager"))) {
                try {
                    List<String> command = CommonUtils.getLaunchCommand(Collections.singletonList("-Djava.security.manager=allow"), args.getCommandLine());
                    if (command != null) {
                        ProcessBuilder pb = new ProcessBuilder(command);
                        pb.inheritIO();
                        Process process = pb.start();
                        System.exit(process.waitFor());
                    }
                }
                catch (IOException ioe) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ioe);
                }
            }
            throw ex;
        }
        if (uiMode) {
            new LogAnalyzerGuiImpl(args).start();
        } else {
            if (args.uris.isEmpty()) {
                System.err.println("ERROR: No log file provided.");
                args.printUsage();
                System.exit(1);
            }
            new LogAnalyzerHeadlessImpl(args).start();
        }
    }
}

