/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer;

import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.api.LogParser;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.utils.CommonUtils;
import com.azul.log.utils.ProgressModel;
import com.azul.log.utils.ThrowingConsumer;
import com.azul.log.utils.ThrowingFunction;
import com.azul.loganalyzer.Arguments;
import com.azul.loganalyzer.cli.dump.html.HTMLDumper;
import com.azul.loganalyzer.cli.dump.json.JSONDumper;
import java.io.Console;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class LogAnalyzerHeadlessImpl {
    private final Arguments args;
    private final PrintStream out = System.out;
    private final PrintStream err = System.err;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public LogAnalyzerHeadlessImpl(Arguments args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        block21: {
            System.setProperty("java.awt.headless", "true");
            try {
                ArrayList<LogFile> logFiles = new ArrayList<LogFile>();
                for (URI uri : this.args.uris) {
                    Path path = this.downloadIfNeeded(uri);
                    LogParser parser = LogParser.getParserFor(path, this::confirm);
                    if (parser == null) {
                        this.err.println("ERROR: Unable to recognize file format of " + uri);
                        return;
                    }
                    parser.addParserExceptionHandler(ex -> {
                        int lineNumber = ex.getLineNumber();
                        String line = ex.getLine();
                        this.err.println("WARNING: Exception at line " + lineNumber + ": " + line);
                        this.err.println(ex.getMessage());
                        return true;
                    });
                    LogFile logFile = this.computeWithProgress("Parsing " + uri, parser::parse);
                    if (logFile == null) {
                        this.err.println("ERROR: Unable to recognize file format of " + uri);
                        return;
                    }
                    LogModel logModel = logFile.lookup(LogModel.class);
                    PlotData plotData = this.computeWithProgress("Processing " + uri, progress -> PlotData.create(logModel, progress));
                    logFile.getInstanceContext().add(plotData);
                    logFiles.add(logFile);
                }
                LogFilesModel logFilesModel = new LogFilesModel(logFiles);
                if (this.args.dumpRawDataFile != null) {
                    try (OutputStream output = Files.newOutputStream(Paths.get(this.args.dumpRawDataFile, new String[0]), new OpenOption[0]);){
                        this.runWithProgress("Writing to " + this.args.dumpRawDataFile, progress -> JSONDumper.dump(logFilesModel, output, Integer.MAX_VALUE, progress));
                        break block21;
                    }
                }
                this.runWithProgress("Writing to " + this.args.htmlDumpDir, progress -> HTMLDumper.dump(logFilesModel, this.args, progress));
            }
            finally {
                this.executor.shutdownNow();
            }
        }
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserInteractionHandler.Response confirm(String title, String question) {
        Console console;
        if (title.startsWith("Multiple gc log files found") && this.args.processMatchedSequences != null) {
            switch (this.args.processMatchedSequences.toLowerCase()) {
                case "yes": {
                    return UserInteractionHandler.Response.YES;
                }
                case "no": {
                    return UserInteractionHandler.Response.NO;
                }
            }
        }
        if ((console = System.console()) == null) return UserInteractionHandler.Response.NO;
        try (PrintWriter cw = console.writer();){
            cw.append("[?] ").append(title).append("\n\n").append(question);
            while (true) {
                cw.print("[Y/n] ");
                cw.flush();
                String answer = console.readLine();
                if (answer == null) {
                    cw.write(10);
                    UserInteractionHandler.Response response = UserInteractionHandler.Response.CANCEL;
                    return response;
                }
                if ((answer = answer.toUpperCase()).isEmpty() || "Y".equals(answer)) {
                    UserInteractionHandler.Response response = UserInteractionHandler.Response.YES;
                    return response;
                }
                if ("N".equals(answer)) {
                    UserInteractionHandler.Response response = UserInteractionHandler.Response.NO;
                    return response;
                }
                continue;
                break;
            }
        }
    }

    private Path downloadIfNeeded(URI uri) {
        String scheme = uri.getScheme();
        return scheme == null || "file".equals(scheme) ? new File(uri.getPath()).toPath() : this.computeWithProgress("Downloading " + uri, progress -> CommonUtils.downloadFile(uri, CommonUtils.createTempFileForURI(uri), progress));
    }

    private void runWithProgress(String descr, ThrowingConsumer<ProgressModel, Exception> exec) {
        this.computeWithProgress(descr, progress -> {
            exec.throwingAccept((ProgressModel)progress);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeWithProgress(String descr, ThrowingFunction<ProgressModel, T, Exception> exec) {
        this.out.print(descr + ": ");
        ProgressModel progress = new ProgressModel();
        AtomicInteger prev = new AtomicInteger(-1);
        ScheduledFuture<?> progressTask = this.executor.scheduleAtFixedRate(() -> {
            int percent = (int)(100.0 * progress.getProgress());
            if (percent != prev.get() && percent < 100) {
                this.out.printf("%d%% ... ", percent);
                prev.set(percent);
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            T result = exec.apply(progress);
            this.out.println("100%");
            T t = result;
            return t;
        }
        finally {
            progressTask.cancel(true);
        }
    }
}

