/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.utils;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class ProgressModel {
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final AtomicLong progress = new AtomicLong(0L);
    private final AtomicLong maximum = new AtomicLong(0L);

    public void setProgress(long abs) throws CancellationException {
        if (this.canceled.get()) {
            throw new CancellationException();
        }
        this.progress.set(abs);
    }

    public double getProgress() {
        long max = this.maximum.get();
        return max == 0L ? 0.0 : (double)this.progress.get() / (double)max;
    }

    public void addProgress(long delta) throws CancellationException {
        if (this.canceled.get()) {
            throw new CancellationException();
        }
        this.progress.addAndGet(delta);
    }

    public void setMaximum(long size) throws CancellationException {
        if (this.canceled.get()) {
            throw new CancellationException();
        }
        this.maximum.set(size);
    }

    public long getMaximum() {
        return this.maximum.get();
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public void cancel() {
        this.canceled.set(true);
    }
}

