/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.zgc;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.parser.impl.zgc.ZGC_Summary;

public final class ZGC_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    @Override
    public boolean canCreateConverter() {
        return Context.lookup(ZGC_Summary.class) != null;
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final ZGC_Summary summary = Context.lookup(ZGC_Summary.class);

        @Override
        public void convertImpl(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("GC Info");
            cb.addValue("Garbage Collector", "ZGC");
            cb.addSection("VM Info");
            cb.addValue("Version", this.summary.version);
            cb.addValue("NUMA Support", this.summary.numaSupport);
            cb.addValue("NUMA Nodes", this.summary.numaNodes);
            cb.addValue("CPUs", this.summary.cpuInfo);
            cb.addValue("Memory", this.summary.memory);
            cb.addValue("Large Page Support", this.summary.largePageSupport);
            cb.addValue("Workers", this.summary.workers);
            cb.addValue("Heap backed by file", this.summary.heapBackFile);
            cb.addValue("Available space on backing filesystem", this.summary.heapBackAvailable);
            cb.addValue("Pre-touching", this.summary.preTouching);
            cb.addValue("Pre-mapping", this.summary.preMapping);
            cb.addValue("Runtime Workers", this.summary.runtimeWorkers);
        }
    }
}

