/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.pgc;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.parser.impl.pgc.PGCU_Summary;

public final class PGCU_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    @Override
    public boolean canCreateConverter() {
        return Context.lookup(PGCU_Summary.class) != null;
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final PGCU_Summary summary = Context.lookup(PGCU_Summary.class);

        @Override
        public void convertImpl(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("GC Info");
            cb.addValue("Garbage Collector", "PGC (Parallel Collector)");
            cb.addValue("Heap Address", this.summary.heapAddress);
            cb.addValue("Heap Size", this.summary.heapSize);
            cb.addValue("Compressed Oops Mode", this.summary.compressedOopsMode);
            cb.addValue("Oop Shift Amount", this.summary.oopShiftAmount);
        }
    }
}

