/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.g1;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.parser.impl.g1.G1_Summary;

public final class G1_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    @Override
    public boolean canCreateConverter() {
        return Context.lookup(G1_Summary.class) != null;
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final G1_Summary summary = Context.lookup(G1_Summary.class);

        @Override
        public void convertImpl(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("VM Info");
            cb.addValue("VM Version", this.summary.vmVersion);
            cb.addValues("VM Flags", this.summary.vmFlags);
            cb.addValue("Memory", this.summary.memInfo);
            cb.addSection("CPU Info");
            cb.addValue("Total CPUs", this.summary.totalCPUs);
            cb.addValue("Available CPUs", this.summary.availableCPUs);
            cb.addSection("GC Info");
            cb.addValue("Garbage Collector", "G1 (Garbage-First)");
            cb.addValue("Periodic GC", this.summary.periodicGC);
            cb.addValue("Parallel Workers", this.summary.parallelWorkers);
            cb.addValue("Concurrent Workers", this.summary.concurrentWorkers);
            cb.addValue("Concurrent Refinement Workers", this.summary.concurrentRefinementWorkers);
            cb.addSection("Heap Info");
            cb.addValueIfPresent("Large Page Support", this.summary.largePageSupport);
            cb.addValueIfPresent("NUMA Support", this.summary.numaSupport);
            cb.addValueIfPresent("NUMA Nodes", this.summary.numaNodes);
            cb.addValueIfPresent("Heap Region Size", this.summary.heapRegionSize);
            cb.addValueIfPresent("Heap Address", this.summary.heapAddress);
            cb.addValueIfPresent("Heap Size", this.summary.heapSize);
            cb.addValueIfPresent("Heap Min Capacity", this.summary.heapMinCapacity);
            cb.addValueIfPresent("Heap Initial Capacity", this.summary.heapInitialCapacity);
            cb.addValueIfPresent("Heap Max Capacity", this.summary.heapMaxCapacity);
            cb.addValueIfPresent("Compressed Oops", this.summary.compressedOops);
            cb.addValueIfPresent("Compressed Oops Mode", this.summary.compressedOopsMode);
            cb.addValueIfPresent("Oop Shift Amount", this.summary.oopShiftAmount);
            cb.addValueIfPresent("Pre-Touch", this.summary.preTouch);
        }
    }
}

