/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.cms;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.parser.impl.cms.CMS_Summary;

public final class CMS_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    @Override
    public boolean canCreateConverter() {
        return Context.lookup(CMS_Summary.class) != null;
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final CMS_Summary summary = Context.lookup(CMS_Summary.class);
        private final LogTimeModel timeModel = Context.lookup(LogTimeModel.class);

        @Override
        public void convertImpl(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("GC Info");
            cb.addValue("Garbage Collector", "CMS (Concurrent Mark Sweep)");
            cb.addSection("VM Process Info");
            cb.addValue("VM Version", this.summary.vmVersion);
            cb.addValues("VM Flags", this.summary.vmFlags);
            cb.addValue("Heap Address", this.summary.heapAddress);
            cb.addValue("Heap Size", this.summary.heapSize);
            cb.addValue("Compressed Oops mode", this.summary.compressedOopsMode);
            cb.addValue("Oop shift amount", this.summary.oopShiftAmount);
            DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
            cb.addValue("Start Time", this.timeModel.getAbsoluteTimestampBase(), dtm::toString);
        }
    }
}

