/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.gui.ui.ColorPalette;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.records.HugePageStatRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.records.SystemThreadCpuUsageRecord;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@GraphsDescription(model="C4", category="System", position=70, graphs={@GraphDescription(title="Memory Use", units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="sysMemUsed", label="System Memory Used"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysMemMax", label="System Memory Max"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="memAvailable", label="System Memory Available")}), @GraphDescription(title="Swap Memory", units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="swapUsed", label="Swap Memory Used"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="swapMax", label="Swap Memory Max")}), @GraphDescription(title="Load Average", ylabel="Threads Runnable", units=LogUnits.THREADS, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="load1", label="Average over Last 1 Minute"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="load5", label="Average over Last 5 Minutes"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="load15", label="Average over Last 15 Minutes")}), @GraphDescription(title="Paging Behavior", ylabel="Pages Since Program Start", units=LogUnits.PAGES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="delta_pageIn", label="Pages In"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_pageOut", label="Pages Out")}), @GraphDescription(title="Swapping Behavior", ylabel="Pages Since Program Start", units=LogUnits.PAGES, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="delta_swapPageIn", label="Swap Pages In"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_swapPageOut", label="Swap Pages Out")}), @GraphDescription(title="Linux Memory and Page Cache Use", units=LogUnits.MEGABYTES, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysLinuxMemTotal", label="System Linux Memory Total"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="cacheUseTotal", label="Page Cache Memory Use Total"), @GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="cacheActiveFile", label="Page Cache Active (File)"), @GraphSeries(color="#9EB6D2", source=SysinfoRecord.class, field="cacheInactiveFile", label="Page Cache Inactive (File)"), @GraphSeries(color="#48A7B9", source=SysinfoRecord.class, field="cacheActiveAnon", label="Page Cache Active (Anon)"), @GraphSeries(color="#82559A", source=SysinfoRecord.class, field="cacheInactiveAnon", label="Page Cache Inactive (Anon)"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="swapCached", label="SwapCached"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="buffers", label="Buffers (I/O)"), @GraphSeries(color="#0ABCC8", source=SysinfoRecord.class, field="unevictable", label="Unevictable"), @GraphSeries(color="#D20A3E", source=SysinfoRecord.class, field="mlocked", label="MLocked"), @GraphSeries(color="#808080", source=SysinfoRecord.class, field="mapped", label="Mapped"), @GraphSeries(color="#00A000", source=SysinfoRecord.class, field="dirty", label="Dirty (Waiting to be written to disk)")}), @GraphDescription(title="System Zing Memory Total and Use", units=LogUnits.MEGABYTES, series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="sysZingMemTot", label="System Zing Memory Total (for Partition)"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="sysZingReservableTot", label="System Zing Reservable Memory Total"), @GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="sysZingReservableUsed", label="System Zing Reservable Memory Used"), @GraphSeries(color="#9EB6D2", source=SysinfoRecord.class, field="sysZingContMemTot", label="System Zing Contingency Memory Total"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="sysZingContMemUsed", label="System Zing Contingency Memory Used"), @GraphSeries(color="#826B9A", source=SysinfoRecord.class, field="sysZingPPMemTot", label="System Zing Pause Prevention Memory Total"), @GraphSeries(color="#92AB61", source=SysinfoRecord.class, field="sysZingPPMemUsed", label="System Zing Pause Prevention Memory Used")}), @GraphDescription(title="Threads Blocked/Running/Total", units=LogUnits.PROCESSES, ylabel="Count", series={@GraphSeries(color="#DF833E", source=SysinfoRecord.class, field="procsBlocked", label="Threads Blocked"), @GraphSeries(color="#3774A6", source=SysinfoRecord.class, field="procsRunning", label="Threads Running"), @GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="procsTotal", label="Threads Total")}), @GraphDescription(title="Threads Total Launched Since Program Start", units=LogUnits.PROCESSES, ylabel="Count", series={@GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="delta_processes", label="Total Threads Launched Since Zing VM Start")}), @GraphDescription(title="THP Allocation", units=LogUnits.PAGES, ylabel="Pages Allocated Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="thp_fault_alloc", label="Huge Page allocated (thp_fault_alloc)"), @GraphSeries(source=HugePageStatRecord.class, field="thp_fault_fallback", label="Fallbacks to Small Pages allocation (thp_fault_fallback)"), @GraphSeries(source=HugePageStatRecord.class, field="thp_file_alloc", label="File Huge Page allocated (thp_file_alloc)")}), @GraphDescription(title="THP Mapping", units=LogUnits.MEGABYTES, ylabel="Megabytes Mapped Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="anon_huge_pages", label="Non-file backed HP (AnonHugePages)"), @GraphSeries(source=HugePageStatRecord.class, field="shmem_pmd_mapped", label="Shared memory mapped with HP (ShmemPmdMapped)"), @GraphSeries(source=HugePageStatRecord.class, field="shmem_huge_pages", label="Shared memory + tmpfs allocated with HP (ShmemHugePages)")}), @GraphDescription(title="Static Huge Pages", units=LogUnits.MEGABYTES, ylabel="Megabytes", series={@GraphSeries(source=HugePageStatRecord.class, field="huge_pages_total_mb", label="Total Huge Page Size"), @GraphSeries(source=HugePageStatRecord.class, field="huge_pages_free_mb", label="Free Huge Page Size")}), @GraphDescription(title="Memory Compaction", units=LogUnits.COUNT, ylabel="Compactions Since Program Start", series={@GraphSeries(source=HugePageStatRecord.class, field="compact_stall", label="A Process Stalls for Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_success", label="Successful Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_fail", label="Failed Memory Compaction"), @GraphSeries(source=HugePageStatRecord.class, field="compact_pages_moved", label="Page moved")}), @GraphDescription(title="Thread CPU usage", units=LogUnits.CORES, ylabel="CPU Utilization (cores)", series_comparator=SystemThreadCpuUsageRecordSeriesComparator.class, series={@GraphSeries(source=SystemThreadCpuUsageRecord.class, field="cores", distinct_field="threadName", label="{dv}", colors_provider=SystemThreadCpuUsageRecordColorsProvider.class)})})
public final class SysinfoGraphsDescription
extends GraphsDefinitionProvider {
    private static final String LBL_TOTAL = "TOTAL";
    private static final String LBL_OTHER = "OTHER";

    public static class SystemThreadCpuUsageRecordSeriesComparator
    implements SeriesComparator {
        @Override
        public int compare(DataSeries s1, DataSeries s2) {
            String l2;
            String l1 = s1.getLabel();
            return Objects.equals(l1, l2 = s2.getLabel()) ? 0 : (SysinfoGraphsDescription.LBL_TOTAL.equals(l1) ? 1 : (SysinfoGraphsDescription.LBL_TOTAL.equals(l2) ? -1 : (SysinfoGraphsDescription.LBL_OTHER.equals(l1) ? 1 : (SysinfoGraphsDescription.LBL_OTHER.equals(l2) ? -1 : l1.compareTo(l2)))));
        }
    }

    public static class SystemThreadCpuUsageRecordColorsProvider
    implements ColorsProvider {
        private final Map<String, Color> colors = new HashMap<String, Color>();
        private final Iterator<Color> iterator = ColorPalette.iterator();

        public SystemThreadCpuUsageRecordColorsProvider() {
            this.colors.put(SysinfoGraphsDescription.LBL_TOTAL, Color.decode("#AC3E39"));
            this.colors.put(SysinfoGraphsDescription.LBL_OTHER, Color.decode("#DF833E"));
        }

        @Override
        public Color getColor(String value) {
            Color color = this.colors.get(value);
            if (color != null) {
                return color;
            }
            color = this.iterator.next();
            while (this.colors.containsValue(color)) {
                color = this.iterator.next();
            }
            return color;
        }
    }
}

