/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.ui.ColorPalette;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.records.ThreadCpuUsageRecord;
import com.azul.log.parser.impl.c4.records.VmaCountersRecord;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@GraphsDescription(model="C4", category="Process", position=60, graphs={@GraphDescription(title="Memory Use", units=LogUnits.MEGABYTES, position=10, series={@GraphSeries(color="#AC3E39", source=GCRecord.class, field="total_process_memory_mb", label="Total Committed Process Memory"), @GraphSeries(color="#46A4B5", source=GCRecord.class, field="heap_committed_total_mb", label="Committed Java Heap Memory"), @GraphSeries(color="#92AB61", source=GCRecord.class, field="off_heap_committed_mb", label="Committed Off Heap Memory"), @GraphSeries(color="#3774A6", source=GCRecord.class, field="used_after_gc_mb", label="Java Heap Used After Collection")}), @GraphDescription(title="Page Fault Behavior", units=LogUnits.PAGES, position=20, series={@GraphSeries(color="#47A7B9", source=SysinfoRecord.class, field="majorFaults", label="Number of Attempts to Access Pages that Required Retrieval from Disk (Major)"), @GraphSeries(color="#AC3E39", source=SysinfoRecord.class, field="cMajorFaults", label="Number of Attempts to Access Pages Not in Memory Made by Process's Waited-For Children (CMajor)")}), @GraphDescription(title="Threads", units=LogUnits.THREADS, position=30, series={@GraphSeries(color="#AC3E39", source=GCRecord.class, field="threads", filter="isNew", label="New GC App Threads"), @GraphSeries(color="#3774A6", source=GCRecord.class, field="thread_count", filter="isNew", label="New GC GC Threads"), @GraphSeries(color="#92AB61", source=GCRecord.class, field="delay_count", filter="isNew", label="New GC App Threads Alloc Delayed"), @GraphSeries(color="#47A7B9", source=GCRecord.class, field="threads", filter="isOld", label="Old GC App Threads"), @GraphSeries(color="#82559A", source=GCRecord.class, field="thread_count", filter="isOld", label="Old GC GC Threads")}), @GraphDescription(title="VMA Use", units=LogUnits.COUNT, position=40, series={@GraphSeries(color="#AC3E39", source=VmaCountersRecord.class, field="vmaMax", label="VMA Max"), @GraphSeries(color="#3774A6", source=VmaCountersRecord.class, field="vmaStack", label="VMA Stack"), @GraphSeries(color="#92AB61", source=VmaCountersRecord.class, field="vmaHeap", label="VMA Heap"), @GraphSeries(color="#47A7B9", source=VmaCountersRecord.class, field="vmaOther", label="VMA Other"), @GraphSeries(color="#82559A", source=VmaCountersRecord.class, field="vmaCount", label="VMA Total")}), @GraphDescription(title="Thread CPU usage", units=LogUnits.CORES, ylabel="CPU Utilization (cores)", series={@GraphSeries(colors_provider=ThreadCpuUsageRecordColorsProvider.class, source=ThreadCpuUsageRecord.class, field="cores", distinct_field="threadName", label="{dv}")})})
public final class ProcessGraphsDescription
extends GraphsDefinitionProvider {

    public static class ThreadCpuUsageRecordColorsProvider
    implements ColorsProvider {
        private final Map<String, Color> colors = new HashMap<String, Color>();
        private final Iterator<Color> iterator = ColorPalette.iterator();

        public ThreadCpuUsageRecordColorsProvider() {
            this.colors.put("C1CompThrX", Color.decode("#47A7B9"));
            this.colors.put("GC_task_thr#X", Color.decode("#92AB61"));
            this.colors.put("Tier2_CompilerX", Color.decode("#AC3E39"));
        }

        @Override
        public Color getColor(String value) {
            Color color = this.colors.get(value);
            if (color != null) {
                return color;
            }
            color = this.iterator.next();
            while (this.colors.containsValue(color)) {
                color = this.iterator.next();
            }
            return color;
        }
    }
}

