/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.impl.c4.records.HeuristicsRecord;

@GraphsDescription(model="C4", category="Heuristics", position=50, graphs={@GraphDescription(title="Calculated Free Heap, Old Gen Needed and New Gen Available", position=10, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="calculated_free_heap", label="Calculated New Generation Memory Free"), @GraphSeries(color="#DF833E", source=HeuristicsRecord.class, field="calculated_future_oldGen_needed", label="Calculated Future Old Generation Memory Needed"), @GraphSeries(color="#9EB6D2", source=HeuristicsRecord.class, field="calculated_newGen_memory_available_for_allocations", label="Calculated New Generation Memory Available for Allocation")}), @GraphDescription(title="Estimated Time to Out-of-Memory", position=20, units=LogUnits.SECONDS, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="estimated_time_to_outOfMemory_in_newGen", label="Estimated Time to Out of Memory in New Generation")}), @GraphDescription(title="Model Klass ID Creation Rate", position=30, units=LogUnits.RATE_KIDSPS, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="klass_id_alloc_per_sec", label="Klass IDs Per Second")}), @GraphDescription(title="Model NewGen GC Duration", position=40, units=LogUnits.SECONDS, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_length_seconds", label="Prediction Model 0"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_model1_length_seconds", label="Prediction Model 1"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_model2_length_seconds", label="Prediction Model 2")}), @GraphDescription(title="Model OldGen GC Duration", position=50, units=LogUnits.SECONDS, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_length_seconds", label="Prediction Model 0"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_model1_length_seconds", label="Prediction Model 1"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_model2_length_seconds", label="Prediction Model 2")}), @GraphDescription(title="Model Object Creation Rate", position=60, units=LogUnits.RATE_MBPS, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="new_gen_alloc_mb_per_sec", label="New Generation"), @GraphSeries(color="#DF833E", source=HeuristicsRecord.class, field="old_gen_alloc_mb_per_sec", label="Old Generation (Promoted)"), @GraphSeries(color="#48A7B9", source=HeuristicsRecord.class, field="perm_gen_alloc_mb_per_sec", label="Permanent Generation"), @GraphSeries(color="#9EB6D2", source=HeuristicsRecord.class, field="direct_memory_alloc_mb_per_sec", label="Direct")}), @GraphDescription(title="Number of Klass IDs", position=70, units=LogUnits.KIDS, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="number_of_kids", label="Number of Klass IDs")}), @GraphDescription(title="Reason Code", position=80, ylabel="Heuristic Reason Code", units=LogUnits.UNSPECIFIED, label_converter=HeuristicsInfoLabelConverter.class, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="reason_code", label="Heuristic Reason Code")}), @GraphDescription(title="Sizes of Generations", position=90, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#3774A6", source=HeuristicsRecord.class, field="new_gen_used_mb", label="New Generation"), @GraphSeries(color="#DF833E", source=HeuristicsRecord.class, field="old_gen_used_mb", label="Old Generation (Promoted)"), @GraphSeries(color="#48A7B9", source=HeuristicsRecord.class, field="perm_gen_used_mb", label="Permanent Generation"), @GraphSeries(color="#9EB6D2", source=HeuristicsRecord.class, field="direct_memory_used_mb", label="Direct")}), @GraphDescription(title="NewGC CPU Usage", position=100, units=LogUnits.SECONDS, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_cpu_time_seconds", label="Prediction Model 0"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_model1_cpu_time_seconds", label="Prediction Model 1"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_model2_cpu_time_seconds", label="Prediction Model 2")}), @GraphDescription(title="OldGC CPU Usage", position=110, units=LogUnits.SECONDS, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_cpu_time_seconds", label="Prediction Model 0"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_model1_cpu_time_seconds", label="Prediction Model 1"), @GraphSeries(source=HeuristicsRecord.class, field="estimated_old_gc_model2_cpu_time_seconds", label="Prediction Model 2")}), @GraphDescription(title="Pause Duration", position=120, units=LogUnits.SECONDS, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_pause1_time_seconds", label="NewGC Pause1")}), @GraphDescription(title="GC Time Percentage", position=130, units=LogUnits.PERCENT, series={@GraphSeries(source=HeuristicsRecord.class, field="estimated_new_gc_time_percent", label="New Generation")}), @GraphDescription(title="Target Peak Occupancy", position=140, units=LogUnits.MEGABYTES, series={@GraphSeries(source=HeuristicsRecord.class, field="target_mb_heap", label="Heap"), @GraphSeries(source=HeuristicsRecord.class, field="target_mb_new_gen", label="New Generation")})})
public class HeuristicsGraphsDescription
extends GraphsDefinitionProvider {

    public static class HeuristicsInfoLabelConverter
    implements LogRecordLabelConverter {
        @Override
        public String convert(double value) {
            return HeuristicsRecord.getReasonForCode((int)value);
        }

        @Override
        public String[] getLabels() {
            return HeuristicsRecord.getReasonLabels();
        }
    }
}

