/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4.charts;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.HeapCommitRecord;

@GraphsDescription(model="C4", category="Java Heap Use", position=30, graphs={@GraphDescription(title="Committed/Peak/AfterCollection", position=10, units=LogUnits.MEGABYTES, filter=CPAOldFilter.class, series={@GraphSeries(color="#92AB61", source=GCRecord.class, filter="isNew", field="used_after_gc_mb", label="New GC After Collection Use"), @GraphSeries(color="#AC3E39", source=GCRecord.class, filter="isNew", field="peak", label="New GC Peak Use"), @GraphSeries(color="#DF833E", source=GCRecord.class, filter="isOld", field="used_after_gc_mb", label="Old GC After Collection Use"), @GraphSeries(color="#47A7B9", source=GCRecord.class, filter="isOld", field="peak", label="Old GC Peak Use"), @GraphSeries(color="#826B9A", source=GCRecord.class, field="heap_committed_non_pause_mb", label="After Collection Committed"), @GraphSeries(color="#175486", source=GCRecord.class, field="peak_committed_mb", label="Peak Committed"), @GraphSeries(color="#9EB6D2", source=GCRecord.class, field="java_heap_Xmx_mb", label="Xmx")}), @GraphDescription(title="Committed/Peak/AfterCollection", position=10, units=LogUnits.MEGABYTES, filter=CPANewFilter.class, series={@GraphSeries(color="#92AB61", source=GCRecord.class, filter="isNew", field="used_after_gc_mb", label="New GC After Collection Use"), @GraphSeries(color="#AC3E39", source=GCRecord.class, filter="isNew", field="peak", label="New GC Peak Use"), @GraphSeries(color="#DF833E", source=GCRecord.class, filter="isOld", field="used_after_gc_mb", label="Old GC After Collection Use"), @GraphSeries(color="#47A7B9", source=GCRecord.class, filter="isOld", field="peak", label="Old GC Peak Use"), @GraphSeries(color="#826B9A", source=GCRecord.class, default_state="hidden", field="heap_committed_non_pause_mb", label="After Collection Committed"), @GraphSeries(color="#175486", source=GCRecord.class, field="peak_committed_mb", label="Peak Committed"), @GraphSeries(color="#9EB6D2", source=GCRecord.class, field="java_heap_Xmx_mb", label="Xmx")}), @GraphDescription(title="Commit/Uncommit Sizes", position=15, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#AC3E39", source=HeapCommitRecord.class, field="heap_mb", label="Committed Java Heap memory"), @GraphSeries(color="#47A7B9", source=HeapCommitRecord.class, field="commit_mb", label="Committed since the last report"), @GraphSeries(color="#826B9A", source=HeapCommitRecord.class, field="uncommit_mb", label="Uncommitted since the last report")}), @GraphDescription(title="Distribution", position=20, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#3774A6", source=GCRecord.class, field="new_gen_used", label="New Gen Objects"), @GraphSeries(color="#AC3E39", source=GCRecord.class, field="old_gen_used", label="Old Gen Objects"), @GraphSeries(color="#7FFF00", source=GCRecord.class, field="perm_gen_used", label="Perm Gen Objects"), @GraphSeries(color="#47A7B9", source=GCRecord.class, field="internal_used", label="Non-Object Data"), @GraphSeries(color="#826B9A", source=GCRecord.class, field="java_system_max", label="Java System Data")}), @GraphDescription(title="New Gen", position=30, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=GCRecord.class, filter="isNew", field="new_gen_used", label="New GC - Heap Use New Gen"), @GraphSeries(color="#AC3E39", source=GCRecord.class, filter="isOld", field="new_gen_used", label="Old GC - Heap Use New Gen"), @GraphSeries(color="#D9A09F", source=GCRecord.class, filter="isNew", field="gen_frag", label="New GC Fragmentation")}), @GraphDescription(title="Old Gen", position=40, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=GCRecord.class, filter="isNew", field="old_gen_used", label="New GC - Heap Use Old Gen"), @GraphSeries(color="#AC3E39", source=GCRecord.class, filter="isOld", field="old_gen_used", label="Old GC - Heap Use Old Gen"), @GraphSeries(color="#D9A09F", source=GCRecord.class, filter="isOld", field="gen_frag", label="Old GC Fragmentation")}), @GraphDescription(title="Perm Gen", position=50, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#47A7B9", source=GCRecord.class, filter="isNew", field="perm_gen_used", label="New GC - Heap Use Perm Gen"), @GraphSeries(color="#AC3E39", source=GCRecord.class, filter="isOld", field="perm_gen_used", label="Old GC - Heap Use Perm Gen")}), @GraphDescription(title="Generation Virtual Use Limits/Peak", position=60, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#92AB61", source=GCRecord.class, field="new_gen_virtual_use_limit_mb", label="New Gen Virtual Use Limit"), @GraphSeries(color="#3774A6", source=GCRecord.class, field="gen_peak", filter="isNew", label="New Gen Peak"), @GraphSeries(color="#DF833E", source=GCRecord.class, field="old_and_perm_gen_virtual_use_limit_mb", label="Old/Perm Gens Virtual Use Limit"), @GraphSeries(color="#AC3E39", source=GCRecord.class, field="gen_peak", filter="isOld", label="Old/Perm Gens Peak")}), @GraphDescription(title="Generation Physical Use Soft Limits/Max", position=60, units=LogUnits.MEGABYTES, series={@GraphSeries(color="#826B9A", source=GCRecord.class, field="new_gen_physical_use_soft_limit_mb", label="New Gen Physical Use Soft Limit"), @GraphSeries(color="#3774A6", source=GCRecord.class, field="gen_peak", filter="isNew", label="New Gen Peak"), @GraphSeries(color="#47A7B9", source=GCRecord.class, field="old_and_perm_gen_physical_use_soft_limit_mb", label="Old/Perm Gens Physical Use Soft Limit"), @GraphSeries(color="#AC3E39", source=GCRecord.class, field="gen_peak", filter="isOld", label="Old/Perm Gens Peak")})})
public class HeapUsageGraphsDescription
extends GraphsDefinitionProvider {
    private static <T extends LogRecord> boolean isDefined(LogModel logModel, Class<T> klass, String fieldName) {
        LogRecordsList records = logModel.getRecordsMap().getRecords(klass, null, null, null, null);
        try {
            return records.isEmpty() || ((LogRecord)records.get(0)).isFieldDefined(klass.getField(fieldName));
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public static final class CPANewFilter
    implements GraphDescriptionFilter {
        @Override
        public boolean isApplicable(LogModel logModel) {
            return HeapUsageGraphsDescription.isDefined(logModel, GCRecord.class, "peak_committed_mb");
        }
    }

    public static final class CPAOldFilter
    implements GraphDescriptionFilter {
        @Override
        public boolean isApplicable(LogModel logModel) {
            return !HeapUsageGraphsDescription.isDefined(logModel, GCRecord.class, "peak_committed_mb");
        }
    }
}

