/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.c4;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.C4_FieldTypes;
import com.azul.log.parser.impl.c4.C4_LogModel;
import com.azul.log.parser.impl.c4.C4_Summary;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.utils.C4_LogFilesSupport;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.ui.impl.c4.C4_VMFlags;
import java.util.ArrayList;
import java.util.List;

public final class C4_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    private static final String NA = "n/a";

    @Override
    public boolean canCreateConverter() {
        return null != Context.lookup(C4_Summary.class) && null != Context.lookup(C4_LogHeader.class);
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static String value(String value, String defaultValue, String suffix) {
        return value == null ? defaultValue : value + (suffix == null ? "" : " " + suffix);
    }

    private static String value(String value) {
        return C4_SummaryConverterProvider.value(value, NA, null);
    }

    private static String value(Number value, String defaultValue, String suffix) {
        return value == null ? defaultValue : value + " " + suffix;
    }

    private static String value(Number value, String suffix) {
        return C4_SummaryConverterProvider.value(value, NA, suffix);
    }

    private static String value(Boolean value) {
        return value == null ? NA : (value != false ? "Yes" : "No");
    }

    private static String formatCPUInfo(int ... values) {
        StringBuilder sb = new StringBuilder();
        for (int v : values) {
            sb.append(v > 0 ? Integer.valueOf(v) : "?");
            sb.append('/');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static void addCGroupsInfo(LogSummaryToUIModelConverter.Callback c, C4_LogHeader h) {
        String[] data = new String[]{C4_SummaryConverterProvider.cgLimits(h.cg_cpu_quota_us, "us"), C4_SummaryConverterProvider.cgLimits(h.cg_cpu_period_us, "us"), C4_SummaryConverterProvider.cgLimits(h.cg_cpu_shares, null), C4_SummaryConverterProvider.cgLimitsInGB(h.cg_memory_and_swap_limit_bytes), C4_SummaryConverterProvider.cgLimitsInGB(h.cg_memory_limit_bytes), C4_SummaryConverterProvider.cgLimitsInGB(h.cg_memory_soft_limit_bytes)};
        for (int i = 0; i < 3; ++i) {
            String s1 = data[i];
            String s2 = data[i + 3];
            int len = Math.max(s1.length(), s2.length());
            data[i] = String.format("%-" + len + "s", s1);
            data[i + 3] = String.format("%-" + len + "s", s2);
        }
        c.addValue("Resource Management Information:", "");
        c.addValue("  Control Group System", h.cg_type);
        c.addValue("  Active Processors Count", "" + h.cg_active_processor_count);
        c.addValue("  Available Memory Nodes", h.cg_available_memory_nodes);
        c.addValue("  Available CPUs", h.cg_available_cpus);
        c.addValue("  CPU Limits    (Quota  / Period  / Shares)", data[0] + " / " + data[1] + " / " + data[2]);
        c.addValue("  Memory Limits (Mem and Swap / Mem / Soft)", data[3] + " / " + data[4] + " / " + data[5]);
        c.addIndent();
    }

    private static String cgLimitsInGB(long bytes) {
        String result = bytes == -1L ? "unlimited" : (bytes == -2L ? "-" : (bytes < -2L ? "-" : String.format("%.2f", (double)bytes / 1.073741824E9) + " GB"));
        return result;
    }

    private static String cgLimits(int value, String suffix) {
        String result = value == -1 ? "unlimited" : (value == -2 ? "-" : (value < -2 ? "-" : (suffix == null ? value + "" : value + " " + suffix)));
        return result;
    }

    private static String formatTableRow(List<String[]> table, String[] data) {
        StringBuilder sb = new StringBuilder();
        int space = 0;
        for (int col = 1; col < data.length; ++col) {
            int max_len = 0;
            for (String[] row : table) {
                max_len = Math.max(max_len, row[col].length());
            }
            if (data[col].contains("<")) {
                sb.append(String.format("%" + (max_len + space + 3) + "s", data[col].replace("<", "&lt;")));
            } else {
                sb.append(String.format("%" + (max_len + space) + "s", data[col]));
            }
            space = 3;
        }
        return sb.toString();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final C4_Summary s = Context.lookup(C4_Summary.class);
        private final C4_LogHeader h = Context.lookup(C4_LogHeader.class);

        @Override
        public void convertImpl(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("System Info");
            cb.addValue("Host Name", this.h.machine_name);
            cb.addValueIfPresent("Architecture", this.h.hardware_type);
            cb.addValueIfPresent("CPUs", this.h.cpu_model, model -> this.h.max_cpu_id + 1 + " x " + model.replaceAll(" +", " "));
            String os = C4_SummaryConverterProvider.value(this.h.os_name);
            if (this.h.os_release != null) {
                os = os + " (" + this.h.os_release + ")";
            }
            cb.addValue("OS", os);
            cb.addValueIfPresent("ZST Version", this.h.zst_version);
            cb.addValue("ZVM Version", this.h.vm_release);
            cb.addValue("Total RAM", C4_SummaryConverterProvider.value(this.h.system_ram_total, "MB"));
            cb.addIndent();
            if (this.h.use_zmm == null && this.h.javaSystemMax_mb > 0) {
                this.h.use_zmm = true;
            }
            String zmmUsed = "Use ZST Memory";
            if (this.h.use_zmm == null) {
                cb.addValue(zmmUsed, C4_SummaryConverterProvider.NA);
            } else if (this.h.use_zmm.booleanValue()) {
                cb.addValue(zmmUsed, "On");
                cb.addValue("Configuration Policy", this.h.zmm_configuration_policy);
                if (this.h.zmm_configuration_policy != null) {
                    String fmt = "%10s %16s %16s %18s";
                    if ("reserve-at-config".equals(this.h.zmm_configuration_policy)) {
                        cb.addValue("Linux Memory, MB", "" + this.h.reserve_at_config_linux_memory_max_mb);
                        cb.addValue("Zing Memory,  MB", String.format(fmt, "Total", "Reservable", "Contingency", "Pause Prevention"));
                        cb.addValue("", String.format(fmt, this.h.system_zing_memory_config_system_zing_memory_total_mb, this.h.system_zing_memory_config_max_reservable_mb, this.h.system_zing_memory_config_max_contingency_mb, this.h.system_zing_memory_config_max_pause_mb));
                    } else {
                        cb.addValue("Linux Memory, MB", "" + this.h.reserve_at_launch_linux_memory_available_mb);
                        cb.addValue("Zing Memory,  MB", String.format(fmt, "Total", "Reservable", "Contingency", "Pause Prevention"));
                        cb.addValue("   Initial Size", String.format(fmt, this.h.system_zing_memory_launch_initial_reserved_mb, this.h.system_zing_memory_launch_initial_reserved_reservable_mb, this.h.system_zing_memory_launch_initial_reserved_contingency_mb, this.h.system_zing_memory_launch_initial_reserved_pause_mb));
                        cb.addValue("   Reserved Size", String.format(fmt, this.h.system_zing_memory_launch_total_reserved_mb, this.h.system_zing_memory_launch_reserved_reservable_mb, this.h.system_zing_memory_launch_reserved_contingency_mb, this.h.system_zing_memory_launch_reserved_pause_mb));
                        cb.addValue("   Upper Limit", String.format(fmt, this.h.system_zing_memory_launch_overall_upper_limit_mb, this.h.system_zing_memory_launch_upper_limit_reservable_mb, this.h.system_zing_memory_launch_upper_limit_contingency_mb, this.h.system_zing_memory_launch_upper_limit_pause_mb));
                    }
                }
            } else {
                cb.addValue(zmmUsed, "Off");
            }
            cb.addIndent();
            C4_FieldTypes.CPUInfo cpu_info = this.h.cpu_info;
            cb.addValue("Hardware Threads / CPU cores installed ", cpu_info == null ? C4_SummaryConverterProvider.NA : C4_SummaryConverterProvider.formatCPUInfo(new int[]{cpu_info.processor_count, cpu_info.physical_core_count}));
            cb.addValue("Hardware Threads available for this process ", cpu_info == null ? C4_SummaryConverterProvider.NA : C4_SummaryConverterProvider.formatCPUInfo(new int[]{cpu_info.active_processor_count}));
            cb.addValue("Hardware Threads / CPU cores assigned to this process ", cpu_info == null ? C4_SummaryConverterProvider.NA : C4_SummaryConverterProvider.formatCPUInfo(new int[]{cpu_info.assigned_logical_core_count, cpu_info.assigned_physical_core_count}));
            cb.addSection("Execution Environment Info");
            String containerEngine = this.h.container_engine != null ? this.h.container_engine : (this.h.zing_vm_is_running_in_container != null && this.h.zing_vm_is_running_in_container != false ? "other" : C4_SummaryConverterProvider.NA);
            cb.addValue("Container Engine", containerEngine);
            if (this.h.cg_type != null) {
                cb.addIndent();
                C4_SummaryConverterProvider.addCGroupsInfo(cb, this.h);
            }
            cb.addSection("VM Process Info");
            cb.addValue("Process ID", this.h.current_process_id != null && this.h.current_process_id > 0 ? "" + this.h.current_process_id : C4_SummaryConverterProvider.NA);
            cb.addValue("Process Number of CPU Threads/Cores ", cpu_info == null ? C4_SummaryConverterProvider.NA : C4_SummaryConverterProvider.formatCPUInfo(new int[]{cpu_info.assigned_logical_core_count, cpu_info.assigned_physical_core_count}));
            if (this.h.jvm_start_time != null) {
                DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
                cb.addValue("Start Time", dtm.toString(this.h.jvm_start_time) + " / " + this.h.jvm_start_time.toString());
            } else {
                cb.addValue("Start Time", C4_SummaryConverterProvider.NA);
            }
            cb.addValue("JVM Command", C4_SummaryConverterProvider.value(this.h.jvm_command));
            String jvm_arguments = this.h.jvm_arguments;
            String header = "JVM Arguments";
            if (jvm_arguments != null) {
                String vmVersion = this.h.vm_release;
                C4_VMFlags vmFlags = C4_VMFlags.init(vmVersion, () -> this.fireChange(null));
                String[] split = (" " + jvm_arguments.trim()).split(" +-");
                for (int i = 1; i < split.length; ++i) {
                    String arg = split[i].trim();
                    if (arg.startsWith("XX:")) {
                        int eq;
                        String flag_name = arg.charAt(3) == '+' || arg.charAt(3) == '-' ? arg.substring(4) : ((eq = arg.indexOf(61)) < 0 ? arg.substring(3) : arg.substring(3, eq));
                        cb.addValue(header, vmFlags.getEntry(flag_name, "-" + arg));
                    } else {
                        cb.addValue(header, "-" + arg);
                    }
                    header = "";
                }
            } else {
                cb.addValue(header, C4_SummaryConverterProvider.NA);
            }
            cb.addSection("VM Process Performance Summary");
            cb.addValue("Garbage Collector Information:", "");
            cb.addValue("  Dynamic GC Thread Count Scheme", this.h.gc_thread_count_scheme == null ? "Disabled" : this.h.gc_thread_count_scheme);
            if (this.h.maxOldGCThreads != null && this.h.maxNewGCThreads != null) {
                cb.addValue("  Max Number of GC Threads", this.h.maxOldGCThreads + " Old, " + this.h.maxNewGCThreads + " New");
            } else if (this.h.oldGCThreads != null && this.h.newGCThreads != null) {
                cb.addValue("  Number of GC Threads", this.s.oldGCThreads + " Old, " + this.s.newGCThreads + " New");
            } else if (this.s.oldGCThreads > 0 && this.s.newGCThreads > 0) {
                cb.addValue("  Max Number of GC Threads", this.s.oldGCThreads + " Old, " + this.s.newGCThreads + " New");
            }
            cb.addValue("  Page Zeroing Threads", this.h.pageZeroingThreads);
            cb.addValue("  Heap Commit Threads", this.h.heapCommitThreads);
            cb.addValue("  GC Phase Encoding", C4_SummaryConverterProvider.value(this.h.phase_bits_encoding));
            Integer xmx = this.h.java_heap_Xmx_mb;
            Integer xms = this.h.java_heap_Xms_mb == null ? this.h.java_heap_Xmx_mb : this.h.java_heap_Xms_mb;
            cb.addValue("  Initial Heap Size", C4_SummaryConverterProvider.value(xms, "MB"));
            cb.addValue("  Max Heap Size", C4_SummaryConverterProvider.value(xmx, "MB"));
            if (this.s.javaHeapUseMax >= 0L) {
                cb.addValue("  Heap Max Use", (this.s.javaHeapUseMax == 0L ? "&lt; 1" : Long.valueOf(this.s.javaHeapUseMax)) + " MB");
            }
            cb.addIndent();
            cb.addValue("JIT Compiler Information:", "");
            cb.addValue("  Tier 1", this.s.compTier1Threads > 0 ? String.format("%-10s%s", C4_SummaryConverterProvider.value(this.h.tier1_compiler) + ",", this.s.compTier1Threads + " threads") : C4_SummaryConverterProvider.value(this.h.tier1_compiler));
            cb.addValue("  Tier 2", this.s.compTier2Threads > 0 ? String.format("%-10s%s", C4_SummaryConverterProvider.value(this.h.tier2_compiler) + ",", this.s.compTier2Threads + " threads") : C4_SummaryConverterProvider.value(this.h.tier2_compiler));
            if (this.h.code_cache_size_limit_mb != null || this.h.monitor_cache_size_limit_mb != null) {
                cb.addIndent();
                ArrayList<String[]> tbl = new ArrayList<String[]>();
                tbl.add(new String[]{"Internal Structures Information:", "Location", "MLocked", "Initial Size", "Peak Use", "Peak Alloc", "Size Limit"});
                if (this.h.code_cache_size_limit_mb != null) {
                    String[] stringArray = new String[7];
                    stringArray[0] = "  Code Cache";
                    stringArray[1] = this.h.code_cache_location == null ? C4_SummaryConverterProvider.NA : TextUtils.toCamelCase(this.h.code_cache_location.toString());
                    stringArray[2] = C4_SummaryConverterProvider.value(this.h.code_cache_is_mlocked);
                    stringArray[3] = C4_SummaryConverterProvider.value(this.h.code_cache_initial_size_mb, "-", "MB");
                    String string = this.s.codeCacheUseMax < 0L ? C4_SummaryConverterProvider.NA : (stringArray[4] = (this.s.codeCacheUseMax == 0L ? "< 1" : Long.valueOf(this.s.codeCacheUseMax)) + " MB");
                    stringArray[5] = this.s.codeCacheAllocatedMax < 0L ? C4_SummaryConverterProvider.NA : (this.s.codeCacheAllocatedMax == 0L ? "< 1" : Long.valueOf(this.s.codeCacheAllocatedMax)) + " MB";
                    stringArray[6] = C4_SummaryConverterProvider.value(this.h.code_cache_size_limit_mb, "MB");
                    tbl.add(stringArray);
                }
                if (this.h.monitor_cache_size_limit_mb != null) {
                    String[] stringArray = new String[7];
                    stringArray[0] = "  Monitor Cache";
                    stringArray[1] = this.h.monitor_cache_location == null ? C4_SummaryConverterProvider.NA : TextUtils.toCamelCase(this.h.monitor_cache_location.toString());
                    stringArray[2] = C4_SummaryConverterProvider.value(this.h.monitor_cache_is_mlocked);
                    stringArray[3] = C4_SummaryConverterProvider.value(this.h.monitor_cache_initial_size_mb, "-", "MB");
                    String string = this.s.monitorCacheUseMax < 0L ? C4_SummaryConverterProvider.NA : (stringArray[4] = (this.s.monitorCacheUseMax == 0L ? "< 1" : Long.valueOf(this.s.monitorCacheUseMax)) + " MB");
                    stringArray[5] = this.s.monitorCacheAllocatedMax < 0L ? C4_SummaryConverterProvider.NA : (this.s.monitorCacheAllocatedMax == 0L ? "< 1" : Long.valueOf(this.s.monitorCacheAllocatedMax)) + " MB";
                    stringArray[6] = C4_SummaryConverterProvider.value(this.h.monitor_cache_size_limit_mb, "MB");
                    tbl.add(stringArray);
                }
                tbl.forEach(d -> cb.addValue(d[0], C4_SummaryConverterProvider.formatTableRow(tbl, d)));
            }
            if (this.s.profInfo != null) {
                String outputProfileLogName = C4_SummaryConverterProvider.NA;
                String inputProfileLogName = C4_SummaryConverterProvider.NA;
                String cncHost = C4_SummaryConverterProvider.NA;
                if (jvm_arguments != null) {
                    String[] args;
                    for (String arg : args = (" " + jvm_arguments.trim()).split(" +-")) {
                        if (arg.startsWith("XX:ProfileLogName=")) {
                            outputProfileLogName = inputProfileLogName = arg.substring(arg.indexOf(61) + 1);
                            continue;
                        }
                        if (arg.startsWith("XX:ProfileLogIn=")) {
                            inputProfileLogName = arg.substring(arg.indexOf(61) + 1);
                            continue;
                        }
                        if (arg.startsWith("XX:ProfileLogOut=")) {
                            outputProfileLogName = arg.substring(arg.indexOf(61) + 1);
                            continue;
                        }
                        if (!arg.startsWith("XX:CNCHost=")) continue;
                        cncHost = arg.substring(arg.indexOf(61) + 1);
                    }
                }
                DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
                cb.addIndent();
                cb.addSection("ReadyNow/PLS information");
                cb.addValue("Hostname", cncHost);
                cb.addValue("Output Profile Log", outputProfileLogName);
                cb.addValue("Input Profile Log", inputProfileLogName);
                cb.addValue("Generation", this.s.profInfo.generation);
                cb.addValue("ID", C4_SummaryConverterProvider.value(this.s.profInfo.id));
                cb.addValue("LastUpdate", dtm.toString(AbsoluteTimestamp.of((double)this.s.profInfo.lastUpdated, LogUnits.MILLISECONDS)));
                if (this.s.firstProfChunkInfoINRecord != null) {
                    cb.addValue("Time", String.format("Successfully loaded in %.3f seconds, starting at %.3f seconds", this.s.lastProfChunkInfoINRecord.getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS) - this.s.firstProfChunkInfoINRecord.getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS), this.s.lastProfChunkInfoINRecord.getEventRelativeTimestamp().getInUnits(LogUnits.SECONDS)));
                }
                cb.addValue("Size", String.format("%,d bytes in %,d chunk(s)", this.s.profInfo.byteSize, this.s.profInfo.chunkCount));
            }
        }

        @Override
        protected void convertLogFilesInfo(LogSummaryToUIModelConverter.Callback cb) {
            cb.addSection("Log Info");
            List<C4_LogFilesSupport.C4_GCLogFile> gcLogFiles = ((C4_LogModel)this.logModel).getGCLogFiles();
            int maxFileNameLength = gcLogFiles.stream().mapToInt(f -> f.getPath().toString().length()).max().orElse(0);
            StringBuilder n = new StringBuilder("Log File");
            gcLogFiles.stream().map(f -> String.format("%-" + maxFileNameLength + "s   [Sequence no: %d]", f.getPath().toString(), f.getSequenceNumber())).forEach(v -> {
                cb.addValue(n.toString(), v);
                n.setLength(0);
            });
        }
    }
}

