/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.spi.GraphTooltipProvider;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class GraphTooltipProviderImpl
implements GraphTooltipProvider {
    private static final NumberFormat nf = UIUtils.getNumberFormat();

    @Override
    public String getTooltip(GraphDefinition graphDefinition, int seriesIndex, int itemIndex, int valueFractionDigits) {
        return TimeAdjustmentSupport.withLogModel(graphDefinition.getLogModel(), () -> this.getTooltipImpl(graphDefinition, seriesIndex, itemIndex, valueFractionDigits));
    }

    private String getTooltipImpl(GraphDefinition graphDefinition, int seriesIndex, int itemIndex, int valueFractionDigits) {
        UIElement selection;
        JFreeChartRecordElement sel;
        String value;
        List<DataSeries> graphData = graphDefinition.getGraphData();
        DataSeries ds = graphData.get(seriesIndex);
        LogRecordsList<LogRecord> recordsList = ds.getData();
        LogRecord record = recordsList.get(itemIndex);
        LogDataConverter c = ds.getConverter();
        RelativeTimestamp recordTime = record.getEventRelativeTimestamp();
        Aggregation aggregation = recordsList.getAggregation();
        Double recordValue = aggregation == Aggregation.UNSPECIFIED ? c.getValue(record) : recordsList.getAggregatedValue(itemIndex);
        String valueUnits = c.getValueUnits().toString();
        switch (aggregation) {
            case COUNT: {
                value = "" + recordValue.intValue();
                valueUnits = "";
                break;
            }
            case SUM: {
                value = c.getValueAsText(recordValue, valueFractionDigits);
                break;
            }
            case UNSPECIFIED: {
                value = c.getValueAsText(record, valueFractionDigits);
                break;
            }
            default: {
                throw new InternalError("Unhandled aggregation");
            }
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<table class='tooltip'>");
        sb.append("<tr style='border-bottom-width: 1; border-bottom-style: solid; border-bottom-color: gray;'><td colspan=2>").append(ds.getLabel());
        if (aggregation != Aggregation.UNSPECIFIED) {
            sb.append(" <font color=#aaaaaa>[\u0192(x) = ").append(aggregation.name()).append("]</font>");
        } else if (record instanceof GCRecord) {
            sb.append(" <font color=#aaaaaa>[").append(((GCRecord)record).type).append("]</font>");
        }
        sb.append("</td></tr>");
        DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
        DisplayTimeModel.Units units = dtm.getUnits();
        if (DisplayTimeModel.Units.ABSOLUTE == units) {
            units = DisplayTimeModel.Units.AUTO;
        }
        JFreeChartRecordElement jFreeChartRecordElement = sel = (selection = UIElementSelectionModel.getInstance().getSelectedElement()) instanceof JFreeChartRecordElement ? (JFreeChartRecordElement)selection : null;
        if (sel != null && graphDefinition == sel.graphDefinition && sel.seriesIndex == seriesIndex && sel.itemIndex != itemIndex) {
            String vsign;
            LogRecord selRecord = sel.getLogRecord();
            RelativeTimestamp selTime = selRecord.getEventRelativeTimestamp();
            long tdiff = (long)RelativeTimestamp.delta(recordTime, selTime, TimeUnit.MILLISECONDS);
            String tsign = tdiff >= 0L ? "+" : "";
            sb.append(String.format("<tr><th>Time:</th><td align='right' style='padding: 0 10 0 10';>%s</td><td>(%s%s)</td></tr>", dtm.toString(recordTime), tsign, units.fromMillis(tdiff, true)));
            Double selValue = aggregation != Aggregation.UNSPECIFIED ? recordsList.getAggregatedValue(sel.itemIndex) : c.getValue(selRecord);
            double vdiff = recordValue - selValue;
            String string = vsign = vdiff >= 0.0 ? "+" : "";
            if (selValue != 0.0) {
                double percent = recordValue * 100.0 / selValue - 100.0;
                sb.append(String.format("<tr><th>Value:</th><td align='right' style='padding: 0 10 0 10';>%s</td><td>(%s%s %s, %s%.2f%%)</td></tr>", value, vsign, UIUtils.getNumberFormat().format(vdiff), valueUnits, vsign, percent));
            } else {
                sb.append(String.format("<tr><th>Value:</th><td align='right' style='padding: 0 10 0 10';>%s</td><td>(%s%s %s)</td></tr>", value, vsign, UIUtils.getNumberFormat().format(vdiff), valueUnits));
            }
            if (Config.isActive("SHOW_ITEM_NUM_IN_TOOLTIP")) {
                int idiff = itemIndex - sel.itemIndex;
                String isign = idiff >= 0 ? "+" : "";
                sb.append(String.format("<tr><th style='padding: 10 0 0 0';><font color=#555555>Item#:</font></th><td align='right' style='padding: 10 10 0 10';><font color=#555555>%s</font></td><td style='padding: 10 0 0 0';><font color=#555555>(%s%s)</font></td></tr>", nf.format(itemIndex + 1), isign, nf.format(idiff)));
            }
        } else {
            sb.append(String.format("<tr><th>Time:</th><td align='right' style='padding: 0 10 0 10';>%s</td></tr><tr><th>Value:</th><td align='right' style='padding: 0 10 0 10';>%s</td></tr>", dtm.toString(recordTime), value));
            if (Config.isActive("SHOW_ITEM_NUM_IN_TOOLTIP")) {
                sb.append(String.format("<tr><th style='padding: 10 0 0 0';><font color=#555555>Item#:</font></th><td style='padding: 10 10 0 10'; align='right'><font color=#555555>%s</font></td></tr>", nf.format(itemIndex + 1)));
            }
        }
        sb.append("</table>");
        return sb.toString();
    }
}

