/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.spi.ChartElementShapeProviderFactory;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.parser.impl.c4.records.GCRecord;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class ChartElementShapeProviderFactoryImpl
implements ChartElementShapeProviderFactory {
    private final Shape ntoShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    private final Shape oldShape = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);

    @Override
    public ChartElementShapeProviderFactory.ChartElementShapeProvider getProviderFor(GraphDefinition gd) {
        boolean hasGCRecords = gd.getGraphData().stream().map(DataSeries::getData).filter(LogRecordsList::hasData).map(records -> records.get(0)).anyMatch(GCRecord.class::isInstance);
        if (!hasGCRecords) {
            return null;
        }
        boolean active = Config.isActive("USE_GC_TYPE_SPECIFIC_SHAPES");
        return record -> {
            if (active && record instanceof GCRecord) {
                GCRecord gcInfo = (GCRecord)record;
                if (gcInfo.isNto()) {
                    return this.ntoShape;
                }
                if (gcInfo.isOld()) {
                    return this.oldShape;
                }
            }
            return DEFAULT_SHAPE;
        };
    }
}

