/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.utils;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.utils.CharSequenceTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class TextUtils {
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    private TextUtils() {
    }

    public static Float parseFloat(CharSequence num) throws NumberFormatException {
        Double result = TextUtils.parseDouble(num);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    public static Double parseDouble(CharSequence num) throws NumberFormatException {
        int len = num.length();
        if (len == 0 || "-".contentEquals(num)) {
            return null;
        }
        int state = 0;
        long r1 = 0L;
        long r2 = 0L;
        int sign = 1;
        int p = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = num.charAt(i);
            switch (state) {
                case 0: {
                    state = 1;
                    if ('-' == c) {
                        sign = -1;
                        continue block5;
                    }
                }
                case 1: {
                    if ('0' <= c && c <= '9') {
                        r1 = r1 * 10L + (long)(c - 48);
                        continue block5;
                    }
                    if (c == '.' || c == ',') {
                        state = 2;
                        continue block5;
                    }
                    if ('e' == c) {
                        return Double.parseDouble(num.toString());
                    }
                    throw new NumberFormatException("Unable to parse double from " + num);
                }
                case 2: {
                    if ('0' <= c && c <= '9') {
                        r2 = r2 * 10L + (long)(c - 48);
                        ++p;
                        continue block5;
                    }
                    if ('e' == c) {
                        return Double.parseDouble(num.toString());
                    }
                    throw new NumberFormatException("Unable to parse double from " + num);
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        return (double)sign * ((double)r1 + (double)r2 / (double)POWERS_OF_10[p]);
    }

    public static Short parseShort(CharSequence num) throws NumberFormatException {
        Integer result = TextUtils.parseInt(num);
        return result == null ? null : Short.valueOf(result.shortValue());
    }

    public static Boolean parseBoolean(CharSequence val) {
        return !(val == null || val.length() != 4 || val.charAt(0) != 't' && val.charAt(0) != 'T' || val.charAt(1) != 'r' && val.charAt(1) != 'R' || val.charAt(2) != 'u' && val.charAt(2) != 'U' || val.charAt(3) != 'e' && val.charAt(3) != 'E');
    }

    public static Integer parseInt(CharSequence num) throws NumberFormatException {
        int len = num.length();
        if (len == 0 || "-".contentEquals(num)) {
            return null;
        }
        int r = 0;
        int i = 0;
        boolean negative = false;
        if (num.charAt(0) == '-') {
            negative = true;
            i = 1;
        }
        while (i < len) {
            char c = num.charAt(i);
            if ('0' > c || c > '9') {
                throw new NumberFormatException("Unable to parse integer");
            }
            r = r * 10 + (c - 48);
            ++i;
        }
        return negative ? -r : r;
    }

    public static Long parseLong(CharSequence num) throws NumberFormatException {
        int len = num.length();
        if (len == 0 || "-".contentEquals(num)) {
            return null;
        }
        long r = 0L;
        int i = 0;
        boolean negative = false;
        if (num.charAt(0) == '-') {
            negative = true;
            i = 1;
        }
        while (i < len) {
            char c = num.charAt(i);
            if ('0' > c || c > '9') {
                throw new NumberFormatException("Unable to parse long");
            }
            r = r * 10L + (long)(c - 48);
            ++i;
        }
        return negative ? -r : r;
    }

    public static Long parseSize(CharSequence size, LogUnits defaultUnits) throws ParserException {
        int len = size.length();
        if (len == 0 || "-".contentEquals(size)) {
            return null;
        }
        int state = 0;
        long r1 = 0L;
        long r2 = 0L;
        int p = 0;
        LogUnits units = defaultUnits;
        block4: for (int i = 0; i < len; ++i) {
            char c = size.charAt(i);
            switch (state) {
                case 0: {
                    if ('0' <= c && c <= '9') {
                        r1 = r1 * 10L + (long)(c - 48);
                        continue block4;
                    }
                    if (c == '.' || c == ',') {
                        state = 1;
                        continue block4;
                    }
                    if (c == 'B') {
                        units = LogUnits.BYTES;
                        break block4;
                    }
                    if (c == 'K') {
                        units = LogUnits.KILOBYTES;
                        break block4;
                    }
                    if (c == 'M') {
                        units = LogUnits.MEGABYTES;
                        break block4;
                    }
                    if (c == 'G') {
                        units = LogUnits.GIGABYTES;
                        break block4;
                    }
                    if (c == 'T') {
                        units = LogUnits.TERABYTES;
                        break block4;
                    }
                    if (c == ' ') continue block4;
                    throw new ParserException("Unable to parse size: " + size);
                }
                case 1: {
                    if ('0' <= c && c <= '9') {
                        r2 = r2 * 10L + (long)(c - 48);
                        ++p;
                        continue block4;
                    }
                    if (c == 'B') {
                        units = LogUnits.BYTES;
                        break block4;
                    }
                    if (c == 'K') {
                        units = LogUnits.KILOBYTES;
                        break block4;
                    }
                    if (c == 'M') {
                        units = LogUnits.MEGABYTES;
                        break block4;
                    }
                    if (c == 'G') {
                        units = LogUnits.GIGABYTES;
                        break block4;
                    }
                    if (c == 'T') {
                        units = LogUnits.TERABYTES;
                        break block4;
                    }
                    throw new ParserException("Unable to parse size: " + size);
                }
                default: {
                    throw new ParserException("Unable to parse size: " + size);
                }
            }
        }
        return (long)units.convertTo((double)r1 + (double)r2 / (double)POWERS_OF_10[p], LogUnits.BYTES);
    }

    public static LogFieldTypes.Duration parseDuration(String duration, LogUnits defaultUnits) throws ParserException {
        int len = duration.length();
        if (len == 0 || "-".equals(duration)) {
            return null;
        }
        int state = 0;
        long r1 = 0L;
        long r2 = 0L;
        LogUnits units = defaultUnits;
        int p = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = duration.charAt(i);
            switch (state) {
                case 0: {
                    if ('0' <= c && c <= '9') {
                        r1 = r1 * 10L + (long)(c - 48);
                        continue block5;
                    }
                    if (c == '.' || c == ',') {
                        state = 1;
                        continue block5;
                    }
                    if (c == ':') {
                        return TextUtils.parseDurationWithColon(duration);
                    }
                    --i;
                    state = 2;
                    continue block5;
                }
                case 1: {
                    if ('0' <= c && c <= '9') {
                        r2 = r2 * 10L + (long)(c - 48);
                        ++p;
                        continue block5;
                    }
                    --i;
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (' ' == c) continue block5;
                    if (TextUtils.checkSuffix("ms", duration, i)) {
                        units = LogUnits.MILLISECONDS;
                        break block5;
                    }
                    if (TextUtils.checkSuffix("s", duration, i)) {
                        units = LogUnits.SECONDS;
                        break block5;
                    }
                    if (TextUtils.checkSuffix("min", duration, i)) {
                        units = LogUnits.MINUTES;
                        break block5;
                    }
                    if (TextUtils.checkSuffix("mic", duration, i)) {
                        units = LogUnits.MICROSECONDS;
                        break block5;
                    }
                    if (TextUtils.checkSuffix("us", duration, i)) {
                        units = LogUnits.MICROSECONDS;
                        break block5;
                    }
                }
                default: {
                    throw new ParserException("Unable to parse duration: " + duration);
                }
            }
        }
        return new LogFieldTypes.Duration((long)units.convertTo((double)r1 + (double)r2 / (double)POWERS_OF_10[p], LogUnits.NANOSECONDS));
    }

    private static LogFieldTypes.Duration parseDurationWithColon(String duration) throws ParserException {
        LogUnits[] units = new LogUnits[]{LogUnits.SECONDS, LogUnits.MINUTES, LogUnits.HOURS};
        int uidx = 0;
        int sidx = duration.length();
        LogFieldTypes.Duration r = new LogFieldTypes.Duration(0L);
        do {
            int eidx = sidx;
            LogFieldTypes.Duration d = TextUtils.parseDuration(duration.substring((sidx = duration.lastIndexOf(58, sidx - 1)) + 1, eidx), units[uidx]);
            if (d != null) {
                r = r.add(d);
            }
            ++uidx;
        } while (sidx >= 0);
        return r;
    }

    private static boolean checkSuffix(String suffix, String str, int pos) {
        return suffix.contentEquals(str.subSequence(pos, Math.min(str.length(), pos + suffix.length())));
    }

    public static boolean findIgnoreCase(String haystack, String needle, int needleLength) {
        if (needleLength == 0) {
            return false;
        }
        char c1_lo = Character.toLowerCase(needle.charAt(0));
        char c1_hi = Character.toUpperCase(needle.charAt(0));
        for (int i = 0; i <= haystack.length() - needleLength; ++i) {
            char ch = haystack.charAt(i);
            if (ch != c1_lo && ch != c1_hi || !haystack.regionMatches(true, i, needle, 0, needleLength)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, char needle, int idx) {
        for (int i = idx; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, char needle) {
        for (int i = haystack.length() - 1; i >= 0; --i) {
            if (haystack.charAt(i) != needle) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence haystack, String needle, int idx) {
        int needle_length = needle.length();
        while (idx <= haystack.length() - needle_length) {
            int i;
            for (i = 0; i < needle_length && haystack.charAt(idx + i) == needle.charAt(i); ++i) {
            }
            if (i == needle_length) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence haystack, String needle, int idx) {
        int needle_length = needle.length();
        needle = needle.toLowerCase();
        while (idx <= haystack.length() - needle_length) {
            int i;
            for (i = 0; i < needle_length && Character.toLowerCase(haystack.charAt(idx + i)) == needle.charAt(i); ++i) {
            }
            if (i == needle_length) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static boolean startsWith(CharSequence haystack, CharSequence prefix) {
        if (haystack.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (haystack.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence haystack, CharSequence suffix) {
        if (haystack.length() < suffix.length()) {
            return false;
        }
        int i = suffix.length() - 1;
        int j = haystack.length() - 1;
        while (i >= 0) {
            if (haystack.charAt(j) != suffix.charAt(i)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public static String toCamelCase(CharSequence line) {
        StringBuilder sb = new StringBuilder();
        CharSequenceTokenizer tokenizer = new CharSequenceTokenizer(" ");
        tokenizer.init(line);
        while (tokenizer.hasMoreTokens()) {
            CharSequence word = tokenizer.nextToken();
            char first = word.charAt(0);
            sb.append(Character.toUpperCase(first));
            sb.append(word.subSequence(1, word.length())).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static CharSequence trim(CharSequence line) {
        int s;
        int e = line.length() - 1;
        for (s = 0; s <= e && Character.isWhitespace(line.charAt(s)); ++s) {
        }
        while (e >= s && Character.isWhitespace(line.charAt(e))) {
            --e;
        }
        return line.subSequence(s, e + 1);
    }

    public static CharSequence trimRight(CharSequence line) {
        int e;
        for (e = line.length() - 1; e >= 0 && Character.isWhitespace(line.charAt(e)); --e) {
        }
        return line.subSequence(0, e + 1);
    }

    public static int countWords(CharSequence string) {
        int count = 0;
        boolean inWord = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    inWord = false;
                    continue block4;
                }
                case ':': {
                    inWord = false;
                    ++count;
                    continue block4;
                }
                default: {
                    if (inWord) continue block4;
                    inWord = true;
                    ++count;
                }
            }
        }
        return count;
    }

    public static String getTimeUnitSuffix(TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return "d.";
            }
            case HOURS: {
                return "h.";
            }
            case MICROSECONDS: {
                return "us.";
            }
            case MILLISECONDS: {
                return "ms.";
            }
            case MINUTES: {
                return "min.";
            }
            case NANOSECONDS: {
                return "ns.";
            }
            case SECONDS: {
                return "sec.";
            }
        }
        throw new InternalError("Unknown TimeUnit " + (Object)((Object)timeUnit));
    }

    public static void split(CharSequence line, char delimiter, Consumer<CharSequence> consumer) {
        int idx;
        for (idx = 0; idx < line.length() && line.charAt(idx) == delimiter; ++idx) {
        }
        line = line.subSequence(idx, line.length());
        for (idx = line.length(); idx > 0 && line.charAt(idx - 1) == delimiter; --idx) {
        }
        line = line.subSequence(0, idx);
        int start = 0;
        while (true) {
            int end;
            if ((end = TextUtils.indexOf(line, delimiter, start)) < 0) {
                consumer.accept(line.subSequence(start, line.length()));
                return;
            }
            consumer.accept(line.subSequence(start, end));
            start = end + 1;
        }
    }

    public static String toValidJavaIdentifier(String prefix, String column) {
        char[] chars = column.toCharArray();
        boolean hasBadChars = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isJavaIdentifierPart(c)) continue;
            chars[i] = 95;
            hasBadChars = true;
        }
        return hasBadChars ? prefix + new String(chars) + Long.toHexString(column.hashCode()) : new String(chars);
    }
}

