/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.support;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import java.util.concurrent.Callable;

public final class TimeAdjustmentSupport {
    private static final ThreadLocal<Long> timeAdjustmentNanoRef = ThreadLocal.withInitial(() -> 0L);

    private TimeAdjustmentSupport() {
    }

    public static RelativeTimestamp adjust(RelativeTimestamp ts) {
        return ts.shift((double)timeAdjustmentNanoRef.get().longValue(), LogUnits.NANOSECONDS);
    }

    public static void withLogModel(LogModel logModel, Runnable runnable) {
        Long prev = timeAdjustmentNanoRef.get();
        timeAdjustmentNanoRef.set(logModel.getTimeAdjustmentNano());
        try {
            runnable.run();
        }
        finally {
            timeAdjustmentNanoRef.set(prev);
        }
    }

    public static <T> T withLogModel(LogModel logModel, Callable<T> callable) {
        Long prev = timeAdjustmentNanoRef.get();
        timeAdjustmentNanoRef.set(logModel.getTimeAdjustmentNano());
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            timeAdjustmentNanoRef.set(prev);
        }
    }
}

