/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.util.Lookup;

public abstract class ParserFactory<T extends LogParserImpl<?>> {
    private final List<String[]> sets;
    private final Confidence confidence;

    public ParserFactory(Confidence confidence, String[] ... sets) {
        this.sets = new ArrayList(Arrays.asList(sets));
        this.confidence = confidence;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<? extends ParserFactory<?>> getParserFactoriesFor(Path log) {
        try (Stream<String> linesStream = Files.lines(log);){
            List lines = linesStream.limit(500L).collect(Collectors.toList());
            Collection<ParserFactory> factories = Lookup.getDefault().lookupAll(ParserFactory.class);
            List list = factories.stream().filter(f -> f.matches(lines)).collect(Collectors.toList());
            return list;
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    public final Confidence getConfidence() {
        return this.confidence;
    }

    protected boolean matches(List<String> lines) {
        ArrayList<String[]> toSearch = new ArrayList<String[]>(this.sets);
        for (String line : lines) {
            Iterator it = toSearch.iterator();
            while (it.hasNext()) {
                String[] set = (String[])it.next();
                if (!Arrays.stream(set).anyMatch(line::contains)) continue;
                it.remove();
                if (!toSearch.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract T createParser(Path var1, UserInteractionHandler var2);

    public static enum Confidence {
        HIGH,
        LOW;

    }
}

