/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogLineWithTimeProvider;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.LogReader;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.LogApiPackageAccessor;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.utils.ProgressModel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class LogParserImpl<T extends ParserState>
implements Lookup.Provider {
    protected final T state;
    protected final LogModel model;
    protected final InstanceContent ic = new InstanceContent();
    private final Lookup lookup = new AbstractLookup(this.ic);
    private final LogApiPackageAccessor accessor = LogApiPackageAccessor.getInstance();

    protected LogParserImpl(LogModel model, T state) {
        this.state = state;
        this.model = model;
        this.ic.add(model);
        this.ic.add(state);
        this.ic.add(((ParserState)state).getLogTimeModel());
        this.ic.add(new LogLineWithTimeProviderImpl());
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public final void processLine(int lineNumber, CharSequence line) throws ParserException {
        LogLineWithTime logLineWithTime = this.parseLogLineImpl(line);
        if (logLineWithTime == null) {
            logLineWithTime = new LogLineWithTime(line);
        }
        this.processLine(lineNumber, logLineWithTime);
    }

    public final void processLine(int lineNumber, LogLineWithTime logLineWithTime) throws ParserException {
        ((ParserState)this.state).setCurrentLogLine(lineNumber, logLineWithTime);
        List<LogRecord> records = this.getLogRecordsImpl(logLineWithTime.getData());
        if (records != null) {
            RelativeTimestamp ts = ((ParserState)this.state).getCurrentLineRelativeTimestamp();
            records.forEach(r -> {
                this.accessor.setRecordLineNumberAndRelativeLogTimestamp((LogRecord)r, lineNumber, ts);
                this.accessor.addRecordToLogRecordsMap(this.model.getRecordsMap(), (LogRecord)r);
                ((ParserState)((Object)this.state)).setLastRecord((LogRecord)r);
            });
        }
    }

    public final LogModel getModel() {
        return this.model;
    }

    protected List<Path> initFiles(Path path, UserInteractionHandler ui) {
        return Collections.singletonList(path);
    }

    public void teardown() {
    }

    public LogReader createReader(ProgressModel progress) throws IOException {
        return LogReader.create(this.model, progress);
    }

    protected abstract LogLineWithTime parseLogLineImpl(CharSequence var1) throws ParserException;

    protected abstract List<? extends LogRecord> getLogRecordsImpl(String var1) throws ParserException;

    private class LogLineWithTimeProviderImpl
    implements LogLineWithTimeProvider {
        private LogLineWithTimeProviderImpl() {
        }

        @Override
        public LogLineWithTime parse(CharSequence line) throws ParserException {
            return LogParserImpl.this.parseLogLineImpl(line);
        }
    }
}

