/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.zgc;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.impl.spi.annotations.GCLogFieldsLineDataParserParams;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.impl.support.SingleLineRecordParser;
import com.azul.log.parser.impl.zgc.ZGC_ParserState;
import com.azul.log.parser.spi.annotations.LogLineField;
import java.lang.reflect.Field;

public final class ZGC_LogRecords {
    private ZGC_LogRecords() {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: ([0-9]*) stripe\\(s\\), ([0-9]*) proactive flush\\(es\\), ([0-9]*) terminate flush\\(es\\), ([0-9]*) completion\\(s\\), ([0-9]*) continuation\\(s\\)")
    public static final class ZGC_MarkDetails
    extends LogRecord {
        @LogLineField
        public int stripes;
        @LogLineField
        public int proactive_flushes;
        @LogLineField
        public int terminate_flushes;
        @LogLineField
        public int completions;
        @LogLineField
        public int continuations;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: .*, ([0-9]*)M relocated")
    public static final class ZGC_Relocation
    extends LogRecord {
        @LogLineField(defaultUnits=LogUnits.MEGABYTES)
        public int relocated_mb;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: 2ms/([0-9.]*)%, 5ms/([0-9.]*)%, 10ms/([0-9.]*)%, 20ms/([0-9.]*)%, 50ms/([0-9.]*)%, 100ms/([0-9.]*)%")
    public static final class ZGC_MinMutatorUtilization
    extends LogRecord {
        @LogLineField
        public double mmu2ms;
        @LogLineField
        public double mmu5ms;
        @LogLineField
        public double mmu10ms;
        @LogLineField
        public double mmu20ms;
        @LogLineField
        public double mmu50ms;
        @LogLineField
        public double mmu100ms;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: ([0-9]*)M used, ([0-9]*)M capacity, ([0-9]*)M committed, ([0-9]*)M reserved")
    public static final class ZGC_Metaspace
    extends LogRecord {
        @LogLineField(defaultUnits=LogUnits.MEGABYTES)
        public int used_mb;
        @LogLineField(defaultUnits=LogUnits.MEGABYTES)
        public int capacity_mb;
        @LogLineField(defaultUnits=LogUnits.MEGABYTES)
        public int committed_mb;
        @LogLineField(defaultUnits=LogUnits.MEGABYTES)
        public int reserved_mb;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: ([0-9]*) registered, ([0-9]*) unregistered")
    public static final class ZGC_NMethods
    extends LogRecord {
        @LogLineField
        public int registered;
        @LogLineField
        public int unregistered;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: ([0-9.]*)/([0-9.]*)/([0-9.]*)")
    public static final class ZGC_SystemLoadAverage
    extends LogRecord {
        @LogLineField
        public double avg1;
        @LogLineField
        public double avg5;
        @LogLineField
        public double avg15;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex="Safepoint \"(.*)\", Time since last: ([0-9]+) ns, Reaching safepoint: ([0-9]+) ns, At safepoint: ([0-9]+) ns, .*")
    public static final class ZGC_Safepoint
    extends LogRecord {
        @LogLineField
        public String kind;
        @LogLineField(defaultUnits=LogUnits.NANOSECONDS)
        public long since_last_ns;
        @LogLineField(defaultUnits=LogUnits.NANOSECONDS)
        public long ttsp_ns;
        @LogLineField(defaultUnits=LogUnits.NANOSECONDS)
        public long duration_ns;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex="Pause (.*) ([0-9.]+)ms")
    public static final class ZGC_Pause
    extends LogRecord {
        @LogLineField
        public String reason;
        @LogLineField(defaultUnits=LogUnits.MILLISECONDS)
        public double duration;
    }

    public static final class ZGC_PhantomRefCount
    extends ZGC_RefCount {
    }

    public static final class ZGC_FinalRefCount
    extends ZGC_RefCount {
    }

    public static final class ZGC_WeakRefCount
    extends ZGC_RefCount {
    }

    public static final class ZGC_SoftRefCount
    extends ZGC_RefCount {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: ([0-9]+) encountered, ([0-9]+) discovered, ([0-9]+) enqueued")
    public static class ZGC_RefCount
    extends LogRecord {
        @LogLineField
        public int encountered;
        @LogLineField
        public int discovered;
        @LogLineField
        public int enqueued;
    }

    public static final class ZGC_CRelocate
    extends ZGC_DurationRecord {
    }

    public static final class ZGC_CPrepareRelocationSet
    extends ZGC_DurationRecord {
    }

    public static final class ZGC_CSelectRelocationSet
    extends ZGC_DurationRecord {
    }

    public static final class ZGC_CDestroyDetachedPages
    extends ZGC_DurationRecord {
    }

    public static final class ZGC_CResetRelocationSet
    extends ZGC_DurationRecord {
    }

    public static final class ZGC_CProcessNonStrongRefs
    extends ZGC_DurationRecord {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".* (.*)")
    public static class ZGC_DurationRecord
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex="Allocation Stall \\((.*)\\) (.*)")
    public static final class ZGC_AllocationStallRecord
    extends LogRecord {
        @LogLineField
        public String reason;
        @LogLineField
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="Garbage Collection (.*) ([0-9]+.*)\\(([0-9]+)%\\)->([0-9]+.*)\\(([0-9]+)%\\)")
    public static final class ZGC_GC_Record
    extends LogRecord {
        @LogLineField
        public String reason;
        @LogLineField
        public LogFieldTypes.Size before;
        @LogLineField
        public int before_percent;
        @LogLineField
        public LogFieldTypes.Size after;
        @LogLineField
        public int after_percent;
        @LogLineField
        public int gc_cycle;

        public static class Parser
        extends SingleLineRecordParser<ZGC_GC_Record, ZGC_ParserState> {
            private final Field gc_cycle = ZGC_GC_Record.class.getField("gc_cycle");

            public Parser(Class<ZGC_GC_Record> klass) throws NoSuchFieldException {
                super(klass);
            }

            @Override
            public void postProcessRecord(ZGC_GC_Record record, ZGC_ParserState state) {
                this.accessor.setFieldValue(record, this.gc_cycle, state.getGCCycleID());
            }
        }
    }
}

