/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.zgc;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.PrefixedLinesParser;
import com.azul.log.parser.impl.UnifiedPrefixedLinesParser;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.impl.zgc.ZGC_LogRecords;
import com.azul.log.parser.impl.zgc.ZGC_ParserState;
import com.azul.log.parser.impl.zgc.ZGC_Summary;

public class ZGC_LogParser
extends UnifiedPrefixedLinesParser<ZGC_ParserState> {
    private final SummarySupport summarySupport;
    private final ZGC_Summary summary = new ZGC_Summary();

    public ZGC_LogParser(LogModel model) {
        super(model, new ZGC_ParserState(), new PrefixedLinesParser.PrefixedLineDefinition[]{new PrefixedLinesParser.PrefixedLineDefinition("Garbage Collection", ZGC_LogRecords.ZGC_GC_Record.class), new PrefixedLinesParser.PrefixedLineDefinition("Allocation Stall", ZGC_LogRecords.ZGC_AllocationStallRecord.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Process Non-Strong References", ZGC_LogRecords.ZGC_CProcessNonStrongRefs.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Reset Relocation Set", ZGC_LogRecords.ZGC_CResetRelocationSet.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Destroy Detached Pages", ZGC_LogRecords.ZGC_CDestroyDetachedPages.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Select Relocation Set", ZGC_LogRecords.ZGC_CSelectRelocationSet.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Prepare Relocation Set", ZGC_LogRecords.ZGC_CPrepareRelocationSet.class), new PrefixedLinesParser.PrefixedLineDefinition("Concurrent Relocate", ZGC_LogRecords.ZGC_CRelocate.class), new PrefixedLinesParser.PrefixedLineDefinition("Load: ", ZGC_LogRecords.ZGC_SystemLoadAverage.class), new PrefixedLinesParser.PrefixedLineDefinition("MMU: ", ZGC_LogRecords.ZGC_MinMutatorUtilization.class), new PrefixedLinesParser.PrefixedLineDefinition("Mark: ", ZGC_LogRecords.ZGC_MarkDetails.class), new PrefixedLinesParser.PrefixedLineDefinition("Relocation: ", ZGC_LogRecords.ZGC_Relocation.class), new PrefixedLinesParser.PrefixedLineDefinition("NMethods: ", ZGC_LogRecords.ZGC_NMethods.class), new PrefixedLinesParser.PrefixedLineDefinition("Metaspace: ", ZGC_LogRecords.ZGC_Metaspace.class), new PrefixedLinesParser.PrefixedLineDefinition("Soft: ", ZGC_LogRecords.ZGC_SoftRefCount.class), new PrefixedLinesParser.PrefixedLineDefinition("Weak: ", ZGC_LogRecords.ZGC_WeakRefCount.class), new PrefixedLinesParser.PrefixedLineDefinition("Final: ", ZGC_LogRecords.ZGC_FinalRefCount.class), new PrefixedLinesParser.PrefixedLineDefinition("Phantom: ", ZGC_LogRecords.ZGC_PhantomRefCount.class), new PrefixedLinesParser.PrefixedLineDefinition("Pause ", ZGC_LogRecords.ZGC_Pause.class), new PrefixedLinesParser.PrefixedLineDefinition("Safepoint ", ZGC_LogRecords.ZGC_Safepoint.class)});
        this.summarySupport = this.initSummarySupport();
        this.ic.add(this.summary);
    }

    @Override
    protected boolean processRawLine(CharSequence line) {
        this.summarySupport.process(line);
        return true;
    }

    private SummarySupport initSummarySupport() {
        SummarySupport ss = new SummarySupport(l -> ((ZGC_ParserState)this.state).getCurrentLineNumber() > 50);
        ss.addPrefixedExtractorC("Version: ", v -> {
            this.summary.version = v;
        });
        ss.addPrefixedExtractorC("NUMA Support: ", v -> {
            this.summary.numaSupport = v;
        });
        ss.addPrefixedExtractorC("NUMA Nodes: ", v -> {
            this.summary.numaNodes = v;
        });
        ss.addPrefixedExtractorC("CPUs: ", v -> {
            this.summary.cpuInfo = v;
        });
        ss.addPrefixedExtractorC("Memory: ", v -> {
            this.summary.memory = v;
        });
        ss.addPrefixedExtractorC("Large Page Support: ", v -> {
            this.summary.largePageSupport = v;
        });
        ss.addPrefixedExtractorC("Workers: ", v -> {
            this.summary.workers = v;
        });
        ss.addPrefixedExtractorC("Heap backed by file", v -> {
            this.summary.heapBackFile = v;
        });
        ss.addPrefixedExtractorC("Available space on backing filesystem", v -> {
            this.summary.heapBackAvailable = v;
        });
        ss.addPrefixedExtractorC("Pre-touching", v -> {
            this.summary.preTouching = v;
        });
        ss.addPrefixedExtractorC("Pre-mapping", v -> {
            this.summary.preMapping = v;
        });
        ss.addPrefixedExtractorC("Runtime Workers", v -> {
            this.summary.runtimeWorkers = v;
        });
        return ss;
    }
}

