/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogSummary;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.UnifiedParserState;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.impl.support.UnifiedLogFormatSupport;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import com.azul.log.parser.spi.annotations.LogRecordField;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UnifiedLogGCCycleParser<StateType extends UnifiedParserState, SummaryType extends LogSummary>
extends LogParserImpl<StateType> {
    private final UnifiedLogFormatSupport ufs;
    private final Map<Integer, GCCycleParser> cycleIdToParser = new HashMap<Integer, GCCycleParser>();
    private final Map<Integer, List<CharSequence>> cycleIdToUnparsed = new HashMap<Integer, List<CharSequence>>();
    private final Map<GCCycleParser, Integer> parserToCycleId = new HashMap<GCCycleParser, Integer>();
    private final GCCycleParser[] cycleParsers;
    private final SummarySupport summarySupport;

    protected UnifiedLogGCCycleParser(LogModel model, StateType state, GCCycleParser[] cycleParsers, SummaryType summary, BiFunction<SummaryType, StateType, SummarySupport> summarySupportInit) {
        super(model, state);
        this.cycleParsers = cycleParsers;
        this.ufs = UnifiedLogFormatSupport.get();
        this.summarySupport = summarySupportInit.apply(summary, state);
        this.ic.add(summary);
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) {
        ((UnifiedParserState)this.state).reset();
        UnifiedLogFormatSupport.GCCycleLogLineWithTime logLine = this.ufs.rawLineToGCCycleLogLine(line);
        int gc_cycle = logLine.getGCCycleID();
        if (gc_cycle >= 0) {
            ((UnifiedParserState)this.state).setGCCycleID(gc_cycle);
        }
        return logLine;
    }

    @Override
    protected List<? extends LogRecord> getLogRecordsImpl(String data) throws ParserException {
        this.summarySupport.process(data);
        return this.parseLineData(data);
    }

    protected List<? extends LogRecord> parseLineData(CharSequence data) throws ParserException {
        Integer cycleID = ((UnifiedParserState)this.state).getGCCycleID();
        if (cycleID == null) {
            return null;
        }
        GCCycleParser cycleParser = this.getGCCycleParser(cycleID);
        if (cycleParser == null) {
            for (GCCycleParser cp : this.cycleParsers) {
                if (!cp.canParse(data)) continue;
                cycleParser = cp;
                break;
            }
            if (cycleParser == null) {
                this.addUnparsedData(cycleID, data);
                return null;
            }
            cycleParser.reset();
            this.setGCCycleParser(cycleID, cycleParser);
            ArrayList result = new ArrayList();
            List<CharSequence> unparsed = this.cycleIdToUnparsed.remove(cycleID);
            if (unparsed != null) {
                for (CharSequence d : unparsed) {
                    Optional.ofNullable(cycleParser.process((UnifiedParserState)this.state, cycleID, d)).ifPresent(result::addAll);
                }
            }
            result.addAll(cycleParser.process((UnifiedParserState)this.state, cycleID, data));
            return result;
        }
        return cycleParser.process((UnifiedParserState)this.state, cycleID, data);
    }

    protected GCCycleParser getGCCycleParser(Integer cycleID) {
        return this.cycleIdToParser.get(cycleID);
    }

    protected void setGCCycleParser(Integer cycleID, GCCycleParser cycleParser) {
        this.cycleIdToParser.put(cycleID, cycleParser);
        Integer prevCycleId = this.parserToCycleId.put(cycleParser, cycleID);
        if (prevCycleId != null) {
            this.cycleIdToParser.remove(prevCycleId);
        }
    }

    protected void addUnparsedData(Integer cycleID, CharSequence data) {
        this.cycleIdToUnparsed.computeIfAbsent(cycleID, id -> new ArrayList()).add(data);
    }

    public static abstract class GCCycleParser<R extends GCCycleRecord, S extends UnifiedParserState>
    extends LogLineParser<R, S> {
        protected final List<GCCycleLineParser<R>> lineParsers = new ArrayList<GCCycleLineParser<R>>();
        private final String prefix;
        private final Function<Integer, R> recordInit;
        private int patternIdx;
        private R record;

        public GCCycleParser(String prefix, Function<Integer, R> init) {
            this.prefix = prefix;
            this.recordInit = init;
        }

        public static <R extends GCCycleRecord> GCCycleLineParser<R> of(String pattern, BiFunction<R, Matcher, List<R>> consumer) {
            return new GCCycleLineParser(pattern, consumer);
        }

        @Override
        public List<R> parseDataChunk(CharSequence dataChunk) {
            throw new InternalError("Should not be called");
        }

        public boolean canParse(CharSequence data) {
            return TextUtils.startsWith(data, this.prefix);
        }

        public List<R> process(S state, Integer cycleID, CharSequence line) {
            for (int i = 0; i < this.lineParsers.size(); ++i) {
                List records;
                this.patternIdx = (this.patternIdx + 1) % this.lineParsers.size();
                GCCycleLineParser<R> p = this.lineParsers.get(this.patternIdx);
                Matcher m = ((GCCycleLineParser)p).matches(line);
                if (!m.matches()) continue;
                if (this.record == null) {
                    this.record = (GCCycleRecord)this.recordInit.apply(cycleID);
                }
                if ((records = ((GCCycleLineParser)p).process(this.record, m)) == null) continue;
                records.forEach(r -> this.postProcessRecord(this.record, state));
                return records;
            }
            return Collections.emptyList();
        }

        @Override
        public final void postProcessRecord(R record, S state) {
            GCCycleRecord prev = (GCCycleRecord)((ParserState)state).getLastRecordOfType(record.getClass());
            if (prev != null) {
                long currentStart = ((ParserState)state).getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS) - ((GCCycleRecord)record).cycleDuration.getNanos();
                long previousEnd = (long)prev.getEventRelativeTimestamp(TimeUnit.NANOSECONDS);
                ((GCCycleRecord)record).interCycleDuration = new LogFieldTypes.Duration(currentStart - previousEnd, LogUnits.NANOSECONDS);
            }
            this.postProcessRecord(prev, record, state);
            this.accessor.resolveDefinedFields((LogRecord)record);
        }

        protected void postProcessRecord(R previousRecord, R currentRecord, S state) {
        }

        public void reset() {
            this.patternIdx = -1;
            this.record = null;
        }

        protected final void set(R record, Matcher m, Field ... fields) {
            for (int i = 0; i < Math.min(fields.length, m.groupCount()); ++i) {
                this.accessor.setFieldValueFromString((LogRecord)record, fields[i], m.group(i + 1));
            }
        }

        protected final void set(R record, Matcher m, Function<CharSequence, CharSequence> convertor, Field ... fields) {
            for (int i = 0; i < Math.min(fields.length, m.groupCount()); ++i) {
                this.accessor.setFieldValueFromString((LogRecord)record, fields[i], convertor.apply(m.group(i + 1)));
            }
        }

        protected final GCCycleLineParser<R> regExp(String pattern, Field ... fields) {
            return GCCycleParser.of(pattern, (r, m) -> {
                this.set((R)r, (Matcher)m, fields);
                return null;
            });
        }

        protected final GCCycleLineParser<R> regExp(String pattern, Function<CharSequence, CharSequence> convertor, Field ... fields) {
            return GCCycleParser.of(pattern, (r, m) -> {
                this.set((R)r, (Matcher)m, convertor, fields);
                return null;
            });
        }
    }

    public static final class GCCycleLineParser<R extends GCCycleRecord> {
        private final Pattern pattern;
        private final BiFunction<R, Matcher, List<R>> consumer;

        private GCCycleLineParser(String pattern, BiFunction<R, Matcher, List<R>> consumer) {
            this.pattern = Pattern.compile(pattern);
            this.consumer = consumer;
        }

        private Matcher matches(CharSequence line) {
            return this.pattern.matcher(line);
        }

        private List<R> process(R r, Matcher m) {
            return this.consumer.apply(r, m);
        }
    }

    public static abstract class GCCycleRecord
    extends LogRecord {
        private final int id;
        @LogRecordField
        public LogFieldTypes.Duration cycleDuration;
        @LogRecordCalculatedField(deps={"cycleDuration"})
        public LogFieldTypes.Duration interCycleDuration;

        protected GCCycleRecord(int id) {
            this.id = id;
        }
    }
}

