/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.utils.CharSequenceTokenizer;
import com.azul.log.parser.utils.TextUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UnifiedLogFormatSupport {
    private static final CharSequenceTokenizer tokenizer = new CharSequenceTokenizer("[]");
    private Decorator[] decorators = null;

    private UnifiedLogFormatSupport() {
    }

    public static UnifiedLogFormatSupport get() {
        return new UnifiedLogFormatSupport();
    }

    public GCCycleLogLineWithTime rawLineToGCCycleLogLine(CharSequence line) {
        if (line.length() == 0 || line.charAt(0) != '[') {
            return new GCCycleLogLineWithTime(line);
        }
        if (this.decorators == null) {
            this.decorators = this.resolveDecorators(line);
        }
        tokenizer.init(line);
        AbsoluteTimestamp absoluteTimestamp = null;
        RelativeTimestamp relativeTimestamp = null;
        for (Decorator d : this.decorators) {
            try {
                if (!tokenizer.hasMoreTokens()) {
                    return null;
                }
                CharSequence tok = TextUtils.trim(tokenizer.nextToken());
                switch (d) {
                    case OTHER: {
                        break;
                    }
                    case TIME: {
                        absoluteTimestamp = AbsoluteTimestamp.parse(tok);
                        break;
                    }
                    case UPTIME_S: {
                        relativeTimestamp = RelativeTimestamp.parse(tok, LogUnits.SECONDS);
                        break;
                    }
                    case TIME_MS: {
                        absoluteTimestamp = AbsoluteTimestamp.parse(tok, LogUnits.MILLISECONDS);
                        break;
                    }
                    case UPTIME_MS: {
                        relativeTimestamp = RelativeTimestamp.parse(tok, LogUnits.MILLISECONDS);
                        break;
                    }
                    case TIME_NS: {
                        absoluteTimestamp = AbsoluteTimestamp.parse(tok, LogUnits.NANOSECONDS);
                        break;
                    }
                    case UPTIME_NS: {
                        relativeTimestamp = RelativeTimestamp.parse(tok, LogUnits.NANOSECONDS);
                        break;
                    }
                    default: {
                        throw new InternalError("Unknown decorator");
                    }
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(UnifiedLogFormatSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        CharSequence reminder = TextUtils.trim(tokenizer.remainder());
        int length = reminder.length();
        int idx = 0;
        int gc_cycle = -1;
        if (length > 3 && "GC(".contentEquals(reminder.subSequence(idx, idx + 3))) {
            gc_cycle = 0;
            idx += 3;
            while (idx < length) {
                char c;
                if ('0' <= (c = reminder.charAt(idx++)) && c <= '9') {
                    gc_cycle = gc_cycle * 10 + (c - 48);
                    continue;
                }
                --idx;
                break;
            }
            idx = idx >= length - 2 ? 0 : (!") ".contentEquals(reminder.subSequence(idx, idx + 2)) ? 0 : (idx += 2));
        }
        return new GCCycleLogLineWithTime(absoluteTimestamp, relativeTimestamp, gc_cycle, tokenizer.getPosition() + idx + 1, line);
    }

    private Decorator[] resolveDecorators(CharSequence line) {
        Decorator d;
        String tok;
        ArrayList<Decorator> result = new ArrayList<Decorator>();
        tokenizer.init(line);
        while (tokenizer.hasMoreTokens() && !(tok = tokenizer.nextToken().toString()).startsWith(" ") && (d = Decorator.guess(tok)) != null) {
            result.add(d);
        }
        return result.toArray(new Decorator[0]);
    }

    public static class GCCycleLogLineWithTime
    extends LogLineWithTime {
        private final int gc_cycle;

        public GCCycleLogLineWithTime(AbsoluteTimestamp absTime, RelativeTimestamp relTime, int gc_cycle, int dataStartIndex, CharSequence rawLine) {
            super(absTime, relTime, dataStartIndex, rawLine);
            this.gc_cycle = gc_cycle;
        }

        public GCCycleLogLineWithTime(CharSequence rawLine) {
            this(null, null, -1, 0, rawLine);
        }

        public int getGCCycleID() {
            return this.gc_cycle;
        }
    }

    static enum Decorator {
        TIME,
        UPTIME_S,
        TIME_MS,
        UPTIME_MS,
        TIME_NS,
        UPTIME_NS,
        OTHER;

        private static final SimpleDateFormat time_fmt;

        private static SimpleDateFormat initTimeFormat() {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            return fmt;
        }

        private static Decorator guess(String field) {
            try {
                time_fmt.parse(field);
                return TIME;
            }
            catch (ParseException parseException) {
                char c;
                int i;
                for (i = 0; i < field.length() && (Character.isDigit(c = field.charAt(i)) || c == '.' || c == ','); ++i) {
                }
                if (i == 0) {
                    return OTHER;
                }
                try {
                    switch (field.substring(i)) {
                        case "s": {
                            return UPTIME_S;
                        }
                        case "ms": {
                            return NumberFormat.getIntegerInstance().parse(field).longValue() > 31536000000L ? TIME_MS : UPTIME_MS;
                        }
                        case "ns": {
                            return NumberFormat.getIntegerInstance().parse(field).longValue() > 31536000000000L ? TIME_NS : UPTIME_NS;
                        }
                    }
                    return OTHER;
                }
                catch (ParseException parseException2) {
                    return null;
                }
            }
        }

        static {
            time_fmt = Decorator.initTimeFormat();
        }
    }
}

