/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.spi.annotations.GCLogFieldsLineDataParserParams;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.spi.annotations.LogLineField;
import com.azul.log.parser.utils.CharSequenceTokenizer;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SingleLineRecordParser<T extends LogRecord, S extends ParserState>
extends LogLineParser<T, S> {
    private final CharSequenceTokenizer tokenizer;
    private final Pattern regex;
    private final Map<CharSequence, Field> prefixToField = new HashMap<CharSequence, Field>();
    private final List<Field> fields = new ArrayList<Field>();
    private final Supplier<T> lineFactory;

    public SingleLineRecordParser(Class<T> lineClass) {
        GCLogFieldsLineDataParserParams annotation = null;
        for (Class<T> c = lineClass; c != null && (annotation = c.getAnnotation(GCLogFieldsLineDataParserParams.class)) == null; c = c.getSuperclass()) {
        }
        if (annotation == null) {
            throw new IllegalArgumentException("GCLogFieldsLineDataParserParams annotation is not defined for class " + lineClass);
        }
        this.tokenizer = annotation.separators().isEmpty() ? null : new CharSequenceTokenizer(annotation.separators());
        this.regex = annotation.regex().isEmpty() ? null : Pattern.compile(annotation.regex());
        for (Field field : lineClass.getFields()) {
            LogLineField a = field.getAnnotation(LogLineField.class);
            if (a == null) continue;
            if (!a.prefix().isEmpty()) {
                this.prefixToField.put(a.prefix(), field);
                continue;
            }
            this.fields.add(field);
        }
        try {
            Constructor lineConstructor = lineClass.getDeclaredConstructor(new Class[0]);
            this.lineFactory = () -> {
                try {
                    return (LogRecord)lineConstructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                    Logger.getLogger(SingleLineRecordParser.class.getName()).log(Level.SEVERE, null, ex);
                    throw new InternalError("Should not happen");
                }
            };
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("Class " + lineClass + " has to have a declared constructor with no arguments");
        }
    }

    @Override
    public List<T> parseDataChunk(CharSequence line) {
        try {
            Matcher matcher;
            if (this.tokenizer != null) {
                LogRecord o = (LogRecord)this.lineFactory.get();
                this.tokenizer.init(line);
                while (this.tokenizer.hasMoreTokens()) {
                    CharSequence tok = TextUtils.trim(this.tokenizer.nextToken());
                    Field fld = this.prefixToField.get(tok);
                    if (fld == null) continue;
                    tok = TextUtils.trim(this.tokenizer.nextToken());
                    this.accessor.setFieldValueFromString(o, fld, tok);
                }
                return Collections.singletonList(o);
            }
            if (this.regex != null && (matcher = this.regex.matcher(line)).matches()) {
                LogRecord o = (LogRecord)this.lineFactory.get();
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    this.accessor.setFieldValueFromString(o, this.fields.get(i), matcher.group(i + 1));
                }
                return Collections.singletonList(o);
            }
            if (this.regex == null) {
                return Collections.singletonList(this.lineFactory.get());
            }
        }
        catch (IllegalArgumentException | SecurityException ex) {
            Logger.getLogger(SingleLineRecordParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

