/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.support;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RecordsProcessingSupport {

    public static final class OverTimeAllocationRate {
        private final List<LogRecord> records = new ArrayList<LogRecord>();
        private final RecordUpdater recordUpdater;
        private final long bucketDuration;
        private long accumulatedDuration = 0L;
        private long accumulatedAllocated = 0L;
        private double lastRate = 0.0;

        public OverTimeAllocationRate(long bucketDuration, TimeUnit units, RecordUpdater recordUpdater) {
            this.recordUpdater = recordUpdater;
            this.bucketDuration = units.toNanos(bucketDuration);
        }

        public void process(LogFieldTypes.Duration sampleDuration, LogFieldTypes.Size sampleAllocated, LogRecord record) {
            if (!this.records.isEmpty()) {
                this.accumulatedDuration += sampleDuration.getNanos();
                this.accumulatedAllocated += Math.max(0L, sampleAllocated.getBytes());
                if (this.accumulatedDuration > this.bucketDuration) {
                    double mb = LogUnits.BYTES.convertTo(this.accumulatedAllocated, LogUnits.MEGABYTES);
                    double sec = LogUnits.NANOSECONDS.convertTo(this.accumulatedDuration, LogUnits.SECONDS);
                    this.lastRate = mb / sec;
                    this.records.forEach(r -> this.recordUpdater.set((LogRecord)r, this.lastRate));
                    this.accumulatedAllocated = 0L;
                    this.accumulatedDuration = 0L;
                    this.records.clear();
                }
            }
            this.recordUpdater.set(record, this.lastRate);
            this.records.add(record);
        }
    }

    @FunctionalInterface
    public static interface RecordUpdater {
        public void set(LogRecord var1, double var2);
    }
}

