/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.shenandoah;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.shenandoah.Shenandoah_GCCycleRecordFields;
import com.azul.log.parser.impl.shenandoah.Shenandoah_LogRecords;
import com.azul.log.parser.impl.shenandoah.Shenandoah_ParserState;
import com.azul.log.parser.impl.shenandoah.Shenandoah_Summary;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.impl.support.UnifiedLogGCCycleParser;
import com.azul.log.parser.utils.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public final class Shenandoah_LogParser
extends UnifiedLogGCCycleParser<Shenandoah_ParserState, Shenandoah_Summary> {
    private static Shenandoah_LogParser currentParser;

    public Shenandoah_LogParser(LogModel model) {
        super(model, new Shenandoah_ParserState(), new UnifiedLogGCCycleParser.GCCycleParser[]{new Shenandoah_GCCycleParser()}, new Shenandoah_Summary(), Shenandoah_LogParser::initSummarySupport);
        currentParser = this;
    }

    private static SummarySupport initSummarySupport(Shenandoah_Summary s, Shenandoah_ParserState state) {
        SummarySupport ss = new SummarySupport(l -> state.getCurrentLineNumber() > 50);
        ArrayList ergoFlags = new ArrayList();
        ss.addPrefixedExtractorC("Regions: ", v -> {
            s.regions = v;
        });
        ss.addPrefixedExtractorC("Humongous object threshold: ", v -> {
            s.humongousObjThreshold = v;
        });
        ss.addPrefixedExtractorC("Max TLAB size: ", v -> {
            s.maxTLABSize = v;
        });
        ss.addPrefixedExtractorC("GC threads: ", v -> {
            s.gcThreads = Arrays.stream(v.split(",")).map(String::trim).collect(Collectors.toList());
        });
        ss.addPrefixedExtractorC("Reference processing: ", v -> {
            s.referenceProcessingMode = v;
        });
        ss.addPrefixedExtractorF("Heuristics ergonomically sets ", v -> {
            ergoFlags.add(v);
            return false;
        });
        ss.addPrefixedExtractorC("Using Shenandoah", v -> {
            s.ergoFlags = ergoFlags;
        });
        ss.addPrefixedExtractorC("Shenandoah heuristics: ", v -> {
            s.heuristicsMode = v;
        });
        ss.addPrefixedExtractorC("Initialize Shenandoah heap: ", v -> {
            s.initialHeap = Arrays.stream(v.split(",")).map(String::trim).collect(Collectors.toList());
        });
        ss.addPrefixedExtractorC("Safepointing mechanism: ", v -> {
            s.safepointingMode = v;
        });
        return ss;
    }

    @Override
    protected List<? extends LogRecord> getLogRecordsImpl(String data) throws ParserException {
        Integer stateCycleId = ((Shenandoah_ParserState)this.state).getGCCycleID();
        if (stateCycleId != null) {
            ((Shenandoah_ParserState)this.state).lastCycleId = stateCycleId;
        }
        return super.getLogRecordsImpl(data);
    }

    @Override
    protected List<? extends LogRecord> parseLineData(CharSequence data) throws ParserException {
        if (((Shenandoah_ParserState)this.state).getGCCycleID() == null) {
            if (TextUtils.startsWith(data, "Trigger: ")) {
                ((Shenandoah_ParserState)this.state).setGCCycleID(((Shenandoah_ParserState)this.state).lastCycleId + 1);
            } else if (TextUtils.startsWith(data, "Concurrent uncommit ")) {
                ((Shenandoah_ParserState)this.state).setGCCycleID(((Shenandoah_ParserState)this.state).lastCycleId);
            } else if (TextUtils.startsWith(data, "Metaspace: ")) {
                ((Shenandoah_ParserState)this.state).setGCCycleID(((Shenandoah_ParserState)this.state).lastCycleId);
            }
        }
        return super.parseLineData(data);
    }

    private static final class Shenandoah_GCCycleParser
    extends UnifiedLogGCCycleParser.GCCycleParser<Shenandoah_LogRecords.Shenandoah_GCCycleRecord, Shenandoah_ParserState>
    implements Shenandoah_GCCycleRecordFields {
        private boolean cycleEndWithUncommit;

        public Shenandoah_GCCycleParser() {
            super("Trigger:", Shenandoah_LogRecords.Shenandoah_GCCycleRecord::new);
            this.lineParsers.addAll(Arrays.asList(Shenandoah_GCCycleParser.of("Trigger: (.*)", (r, m) -> {
                String reasonText = m.group(1);
                int idx = reasonText.indexOf(" is below ");
                if (idx > 0) {
                    reasonText = "Free" + reasonText.substring(idx);
                } else if (reasonText.indexOf("above the time for allocation rate") > 0) {
                    reasonText = "Allocation Rate";
                }
                this.accessor.setFieldValueFromString((LogRecord)r, reason, reasonText);
                this.accessor.setFieldValue((LogRecord)r, start_ns, Shenandoah_GCCycleParser.lineTime_ns());
                this.cycleEndWithUncommit = m.group(1).startsWith("Explicit");
                return null;
            }), this.regExp("Concurrent reset ([.0-9]*ms)", concurrentResetDuration), this.regExp("Pause Init Mark.* ([.0-9]*ms)", pauseInitMarkDuration), this.regExp("Concurrent marking.* ([.0-9]*ms)", concurrentMarkingDuration), this.regExp("Concurrent precleaning ([.0-9]*ms)", concurrentPrecleaningDuration), this.regExp("Pause Final Mark.* ([.0-9]*ms)", pauseFinalMarkDuration), Shenandoah_GCCycleParser.of("Concurrent cleanup (.*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                LogFieldTypes.Duration prevDuration = r.concurrentCleanupDuration;
                this.set(r, (Matcher)m, heapUseBeforeConcurrentCleanup, heapUseAfterConcurrentCleanup, heapAllocAfterConcurrentCleanup, concurrentCleanupDuration);
                if (prevDuration != null) {
                    r.concurrentCleanupDuration = r.concurrentCleanupDuration.add(prevDuration);
                }
                if (this.cycleEndWithUncommit) {
                    return null;
                }
                long end_ns = Shenandoah_GCCycleParser.lineTime_ns();
                LogFieldTypes.Duration gcDuration = new LogFieldTypes.Duration(end_ns - r.start_ns);
                this.accessor.setFieldValue((LogRecord)r, cycleDuration, gcDuration);
                return Collections.singletonList(r);
            }), this.regExp("Concurrent evacuation (.*)", concurrentEvacuationDuration), this.regExp("Pause Init Update Refs (.*)", pauseInitUpdateRefsDuration), this.regExp("Concurrent update references (.*)", concurrentUpdateRefsDuration), this.regExp("Pause Final Update Refs (.*)", pauseFinalUpdateRefsDuration), Shenandoah_GCCycleParser.of("Concurrent uncommit (.*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                this.set(r, (Matcher)m, heapUseBeforeConcurrentUncommit, heapUseAfterConcurrentUncommit, heapAllocAfterConcurrentUncommit, concurrentUncommitDuration);
                long end_ns = Shenandoah_GCCycleParser.lineTime_ns();
                LogFieldTypes.Duration gcDuration = new LogFieldTypes.Duration(end_ns - r.start_ns);
                this.accessor.setFieldValue((LogRecord)r, cycleDuration, gcDuration);
                return Collections.singletonList(r);
            }), this.regExp("Metaspace: (.*)\\((.*)\\)->(.*)\\((.*)\\) NonClass: (.*)\\((.*)\\)->(.*)\\((.*)\\) Class: (.*)\\((.*)\\)->(.*)\\((.*)\\)", metaspaceUseBeforeGC, metaspaceAllocatedBeforeGC, metaspaceUseAfterGC, metaspaceAllocatedAfterGC, metaspaceNonClassUseBeforeGC, metaspaceNonClassAllocatedBeforeGC, metaspaceNonClassUseAfterGC, metaspaceNonClassAllocatedAfterGC, metaspaceClassUseBeforeGC, metaspaceClassAllocatedBeforeGC, metaspaceClassUseAfterGC, metaspaceClassAllocatedAfterGC), this.regExp("Free: (.*), Max: (.*) regular, (.*) humongous, Frag: (.*)% external, (.*)% internal; Reserve: (.*), Max: (.*)", heapFreeTotal, heapFreeMaxRegular, heapFreeMaxHumongous, heapFragExternal, heapFragInternal, heapReserveFreeTotal, heapReserveFreeMaxRegular), this.regExp("Collectable Garbage: (.*) \\((.*)%\\), Immediate: (.*) \\((.*)%\\), CSet: (.*) \\((.*)%\\)", collectableGarbageTotalSize, collectableGarbageTotalPercent, collectableGarbageImmediateSize, collectableGarbageImmediatePercent, cSetSize, cSetPercent)));
        }

        private static long lineTime_ns() {
            return ((Shenandoah_ParserState)currentParser.state).getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS);
        }
    }
}

