/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.pgc;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.impl.pgc.PGCU_FieldTypes;
import com.azul.log.parser.impl.pgc.PGCU_ParserState;
import com.azul.log.parser.impl.spi.annotations.GCLogFieldsLineDataParserParams;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.impl.support.SingleLineRecordParser;
import com.azul.log.parser.spi.annotations.LogLineField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class PGCU_LogRecords {
    private PGCU_LogRecords() {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators="= ")
    public static final class PGCU_CPUTimes
    extends LogRecord {
        @LogLineField(prefix="User")
        public LogFieldTypes.Duration user;
        @LogLineField(prefix="Sys")
        public LogFieldTypes.Duration sys;
        @LogLineField(prefix="Real")
        public LogFieldTypes.Duration real;
    }

    public static class PGCU_PostCompactPhaseDuration
    extends PGCU_PhaseDuration {
    }

    public static class PGCU_CompactionPhaseDuration
    extends PGCU_PhaseDuration {
    }

    public static class PGCU_AdjustRootsPhaseDuration
    extends PGCU_PhaseDuration {
    }

    public static class PGCU_SummaryPhaseDuration
    extends PGCU_PhaseDuration {
    }

    public static class PGCU_MarkingPhaseDuration
    extends PGCU_PhaseDuration {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".* ([^ ]+)$")
    public static class PGCU_PhaseDuration
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;
    }

    public static class PGCU_MetaspaceStats
    extends PGCU_RegionsStats3 {
    }

    public static class PGCU_ParOldGenStats
    extends PGCU_RegionsStats3 {
    }

    public static class PGCU_PSYoungGenStats
    extends PGCU_RegionsStats3 {
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(regex=".*: (.*)->(.*)\\((.*)\\)$")
    public static class PGCU_RegionsStats3
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Size beforeGC;
        @LogLineField
        public LogFieldTypes.Size afterGC;
        @LogLineField
        public LogFieldTypes.Size allocated;
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="Pause ([^ ]*) \\(([^()]*)\\) ([^ ]*)->([^ ]*)\\(([^ ]*)\\) ([^ ]*)")
    public static final class PGCU_GCStats
    extends LogRecord {
        @LogLineField
        public PGCU_FieldTypes.Generation generation;
        @LogLineField
        public PGCU_FieldTypes.GCReason reason;
        @LogLineField
        public LogFieldTypes.Size useBeforeGC;
        @LogLineField
        public LogFieldTypes.Size useAfterGC;
        @LogLineField
        public LogFieldTypes.Size allocated;
        @LogLineField
        public LogFieldTypes.Duration cycleDuration;
        @LogLineField
        public int gcCycleID;
        @LogLineField
        public double interCycleAllocationRateMbps;
        @LogLineField
        public LogFieldTypes.Duration interCycleDuration;

        public static class Parser
        extends SingleLineRecordParser<PGCU_GCStats, PGCU_ParserState> {
            private final Map<PGCU_FieldTypes.Generation, AtomicInteger> gentoid = new HashMap<PGCU_FieldTypes.Generation, AtomicInteger>();
            private final Field interCycleAllocationRate = PGCU_GCStats.class.getField("interCycleAllocationRateMbps");
            private final Field interCycleTime = PGCU_GCStats.class.getField("interCycleDuration");
            private final Field gc_cycle = PGCU_GCStats.class.getField("gcCycleID");

            public Parser(Class<PGCU_GCStats> klass) throws NoSuchFieldException {
                super(klass);
            }

            @Override
            public void postProcessRecord(PGCU_GCStats record, PGCU_ParserState state) {
                PGCU_GCStats prev = state.getLastRecordOfType(PGCU_GCStats.class);
                if (prev != null) {
                    long currentEnd_ns = state.getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS);
                    long currentDuration_ns = record.cycleDuration.getNanos();
                    long currentStart_ns = currentEnd_ns - currentDuration_ns;
                    long previousEnd_ns = prev.getEventRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS);
                    long time_between_ns = Math.max(0L, currentStart_ns - previousEnd_ns);
                    double interCycleTimeSec = LogUnits.NANOSECONDS.convertTo(time_between_ns, LogUnits.SECONDS);
                    this.accessor.setFieldValue(record, this.interCycleTime, new LogFieldTypes.Duration(time_between_ns, LogUnits.NANOSECONDS));
                    long bytesAfterPreviousGC = prev.useAfterGC.getBytes();
                    long bytesBeforeCurrentGC = record.useBeforeGC.getBytes();
                    double interCycleAllocatedMb = Math.max(0.0, LogUnits.BYTES.convertTo(bytesBeforeCurrentGC - bytesAfterPreviousGC, LogUnits.MEGABYTES));
                    if (interCycleAllocatedMb > 0.0 && interCycleTimeSec > 0.0) {
                        this.accessor.setFieldValue(record, this.interCycleAllocationRate, interCycleAllocatedMb / interCycleTimeSec);
                    }
                }
                AtomicInteger gen_counter = this.gentoid.computeIfAbsent(record.generation, g -> new AtomicInteger(0));
                this.accessor.setFieldValue(record, this.gc_cycle, gen_counter.getAndIncrement());
            }
        }
    }
}

