/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.pgc;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.PrefixedLinesParser;
import com.azul.log.parser.impl.UnifiedPrefixedLinesParser;
import com.azul.log.parser.impl.pgc.PGCU_LogRecords;
import com.azul.log.parser.impl.pgc.PGCU_ParserState;
import com.azul.log.parser.impl.pgc.PGCU_Summary;
import com.azul.log.parser.impl.support.SummarySupport;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public final class PGCU_LogParser
extends UnifiedPrefixedLinesParser<PGCU_ParserState> {
    private final SummarySupport summarySupport;
    private final PGCU_Summary summary = new PGCU_Summary();

    public PGCU_LogParser(LogModel model) {
        super(model, new PGCU_ParserState(), new PrefixedLinesParser.PrefixedLineDefinition[]{new PrefixedLinesParser.PrefixedLineDefinition("Pause", PGCU_LogRecords.PGCU_GCStats.class), new PrefixedLinesParser.PrefixedLineDefinition("User", PGCU_LogRecords.PGCU_CPUTimes.class), new PrefixedLinesParser.PrefixedLineDefinition("PSYoungGen", PGCU_LogRecords.PGCU_PSYoungGenStats.class), new PrefixedLinesParser.PrefixedLineDefinition("ParOldGen", PGCU_LogRecords.PGCU_ParOldGenStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Metaspace", PGCU_LogRecords.PGCU_MetaspaceStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Marking Phase ", PGCU_LogRecords.PGCU_MarkingPhaseDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Summary Phase ", PGCU_LogRecords.PGCU_SummaryPhaseDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Adjust Roots ", PGCU_LogRecords.PGCU_AdjustRootsPhaseDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Compaction Phase ", PGCU_LogRecords.PGCU_CompactionPhaseDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Post Compact ", PGCU_LogRecords.PGCU_PostCompactPhaseDuration.class)});
        this.summarySupport = this.initSummarySupport();
        this.ic.add(this.summary);
    }

    @Override
    protected boolean processRawLine(CharSequence line) {
        this.summarySupport.process(line);
        return true;
    }

    private SummarySupport initSummarySupport() {
        SummarySupport ss = new SummarySupport(l -> ((PGCU_ParserState)this.state).getCurrentLineNumber() > 10);
        ss.addPrefixedExtractorC("Heap address: ", v -> {
            Map<String, String> data = Arrays.stream(("Heap address: " + v).split(",")).map(String::trim).map(s -> s.split(":")).collect(Collectors.toMap(x -> x[0].trim(), y -> y[1].trim()));
            this.summary.compressedOopsMode = data.get("Compressed Oops mode");
            this.summary.oopShiftAmount = data.get("Oop shift amount");
            this.summary.heapAddress = data.get("Heap address");
            this.summary.heapSize = data.get("size");
        });
        return ss;
    }
}

