/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.g1;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.cms.CMS_FieldTypes;
import com.azul.log.parser.impl.g1.G1_FieldTypes;
import com.azul.log.parser.impl.g1.G1_ParserState;
import com.azul.log.parser.impl.spi.annotations.GCLogFieldsLineDataParserParams;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.impl.support.SingleLineRecordParser;
import com.azul.log.parser.spi.annotations.LogLineField;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class G1_LogRecords {
    private G1_LogRecords() {
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="Total time for which application threads were stopped: ([0-9.]*) seconds, Stopping threads took: ([0-9.]*) seconds")
    public static final class G1_ApplicationStoppedTime
    extends LogRecord {
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration stoppedTime;
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration stoppingTime;

        public static class Parser
        extends SingleLineRecordParser<G1_ApplicationStoppedTime, G1_ParserState> {
            public Parser(Class<G1_ApplicationStoppedTime> klass) {
                super(klass);
            }
        }
    }

    public static class G1_GCWorkerEndDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_GCWorkerTotalDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_GCWorkerOtherDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_TerminationAttemptsStats
    extends G1_GCParallelPhaseStats {
    }

    public static class G1_TerminationDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_ObjectCopyDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_CodeRootScanningDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_ScanRSDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_ProcessBuffersStats
    extends G1_GCParallelPhaseStats {
    }

    public static class G1_UpdateRootSetDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_ExtRootScanningDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    public static class G1_GCWorkerStartDurationStats
    extends G1_GCParallelPhaseDurationStats {
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="Eden: (.*)\\((.*)\\)->(.*)\\((.*)\\) Survivors: (.*)->(.*) Heap: (.*)\\((.*)\\)->(.*)\\((.*)\\)")
    public static final class G1_GCHeapStats
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Size edenUseBefore;
        @LogLineField
        public LogFieldTypes.Size edenAllocatedBefore;
        @LogLineField
        public LogFieldTypes.Size edenUseAfter;
        @LogLineField
        public LogFieldTypes.Size edenAllocatedAfter;
        @LogLineField
        public LogFieldTypes.Size survivorsUseBefore;
        @LogLineField
        public LogFieldTypes.Size survivorsUseAfter;
        @LogLineField
        public LogFieldTypes.Size heapUseBefore;
        @LogLineField
        public LogFieldTypes.Size heapAllocatedBefore;
        @LogLineField
        public LogFieldTypes.Size heapUseAfter;
        @LogLineField
        public LogFieldTypes.Size heapAllocatedAfter;
        @LogLineField
        public LogFieldTypes.Duration cycleDuration;
        @LogLineField
        public double allocationRate;
        @LogLineField
        public LogFieldTypes.Duration interCycleDuration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCHeapStats, G1_ParserState> {
            private final Field cycleDuration = G1_GCHeapStats.class.getField("cycleDuration");
            private final Field allocationRate = G1_GCHeapStats.class.getField("allocationRate");
            private final Field interCycleDuration = G1_GCHeapStats.class.getField("interCycleDuration");

            public Parser(Class<G1_GCHeapStats> klass) throws NoSuchFieldException {
                super(klass);
            }

            @Override
            public void postProcessRecord(G1_GCHeapStats record, G1_ParserState state) {
                LogFieldTypes.Duration currentGCCycleDuration = state.getCurrentGCCycleDuration();
                if (currentGCCycleDuration != null) {
                    this.accessor.setFieldValue(record, this.cycleDuration, currentGCCycleDuration);
                    G1_GCHeapStats prev = state.getLastRecordOfType(G1_GCHeapStats.class);
                    if (prev != null) {
                        long currentStart = state.getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS) - currentGCCycleDuration.getNanos();
                        double previousEnd = prev.getEventRelativeTimestamp(TimeUnit.NANOSECONDS);
                        double allocatedMb = Math.max(0.0, LogUnits.BYTES.convertTo(record.edenUseBefore.getBytes() - prev.edenUseAfter.getBytes(), LogUnits.MEGABYTES));
                        double ms_diff = LogUnits.NANOSECONDS.convertTo((double)currentStart - previousEnd, LogUnits.MILLISECONDS);
                        if (ms_diff > 1.0) {
                            this.accessor.setFieldValue(record, this.allocationRate, allocatedMb / ms_diff * LogUnits.SECONDS.convertTo(1.0, LogUnits.MILLISECONDS));
                        }
                        this.accessor.setFieldValue(record, this.interCycleDuration, new LogFieldTypes.Duration((double)currentStart - previousEnd, LogUnits.NANOSECONDS));
                    }
                }
            }
        }
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="GC concurrent-root-region-scan-end, (.*)")
    public static final class G1_GCConcurrentRootScan
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCConcurrentRootScan, G1_ParserState> {
            public Parser(Class<G1_GCConcurrentRootScan> klass) {
                super(klass);
            }
        }
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="GC concurrent-cleanup-end, (.*)")
    public static final class G1_GCConcurrentCleanup
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCConcurrentCleanup, G1_ParserState> {
            public Parser(Class<G1_GCConcurrentCleanup> klass) {
                super(klass);
            }
        }
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="GC concurrent-mark-end, (.*)")
    public static final class G1_GCConcurrentMark
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCConcurrentMark, G1_ParserState> {
            public Parser(Class<G1_GCConcurrentMark> klass) {
                super(klass);
            }
        }
    }

    @GCLogLineData(parserClass=G1_GCCleanupStats.Parser.class)
    @GCLogFieldsLineDataParserParams(regex="GC remark, (.*)")
    public static final class G1_GCRemarkStats
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Duration duration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCRemarkStats, G1_ParserState> {
            public Parser(Class<G1_GCRemarkStats> klass) {
                super(klass);
            }
        }
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams(regex="GC cleanup (.*)->(.*)\\((.*)\\), (.*)")
    public static final class G1_GCCleanupStats
    extends LogRecord {
        @LogLineField
        public LogFieldTypes.Size useBeforeGC;
        @LogLineField
        public LogFieldTypes.Size useAfterGC;
        @LogLineField
        public LogFieldTypes.Size allocated;
        @LogLineField
        public LogFieldTypes.Duration duration;

        public static class Parser
        extends SingleLineRecordParser<G1_GCCleanupStats, G1_ParserState> {
            public Parser(Class<G1_GCCleanupStats> klass) {
                super(klass);
            }
        }
    }

    @GCLogLineData(parserClass=Parser.class)
    @GCLogFieldsLineDataParserParams
    public static final class G1_GCPauseWithMemStats
    extends LogRecord {
        @LogLineField
        public G1_FieldTypes.GCPauseType type;
        @LogLineField
        public CMS_FieldTypes.Generation generation;
        @LogLineField
        public LogFieldTypes.Size useBeforeGC;
        @LogLineField
        public LogFieldTypes.Size useAfterGC;
        @LogLineField
        public LogFieldTypes.Size allocated;
        @LogLineField
        public LogFieldTypes.Duration cycleDuration;
        @LogLineField
        public double allocationRate;
        @LogLineField
        public LogFieldTypes.Duration interCycleDuration;

        void setGCCycleDurationFrom(String line) throws ParserException {
            this.setFieldValue(Parser.cycleDuration, LogFieldTypes.Duration.fromString(line, null));
        }

        public static class Parser
        extends SingleLineRecordParser<G1_GCPauseWithMemStats, G1_ParserState> {
            private static final Field type;
            private static final Field generation;
            private static final Field useBeforeGC;
            private static final Field useAfterGC;
            private static final Field allocated;
            private static final Field cycleDuration;
            private static final Field allocationRate;
            private static final Field interCycleDuration;

            public Parser(Class<G1_GCPauseWithMemStats> klass) {
                super(klass);
            }

            @Override
            public List<G1_GCPauseWithMemStats> parseDataChunk(CharSequence line) {
                return this.parseGCPauseLine(line, (lexems, hasDuration) -> {
                    int size = lexems.size();
                    G1_GCPauseWithMemStats stats = new G1_GCPauseWithMemStats();
                    stats.setFieldValue(Parser.type, G1_FieldTypes.GCPauseType.fromString(((CharSequence)lexems.get(0)).toString(), null));
                    stats.setFieldValue(Parser.generation, CMS_FieldTypes.Generation.fromString(((CharSequence)lexems.get(1)).toString(), null));
                    try {
                        if (size == 6) {
                            stats.setFieldValue(Parser.useBeforeGC, LogFieldTypes.Size.fromString(((CharSequence)lexems.get(2)).toString(), null));
                            stats.setFieldValue(Parser.useAfterGC, LogFieldTypes.Size.fromString(((CharSequence)lexems.get(3)).toString(), null));
                            stats.setFieldValue(Parser.allocated, LogFieldTypes.Size.fromString(((CharSequence)lexems.get(4)).toString(), null));
                            stats.setFieldValue(Parser.cycleDuration, LogFieldTypes.Duration.fromString(((CharSequence)lexems.get(5)).toString(), null));
                        } else if (size == 3 && hasDuration.booleanValue()) {
                            stats.setFieldValue(Parser.cycleDuration, LogFieldTypes.Duration.fromString(((CharSequence)lexems.get(2)).toString(), null));
                        }
                    }
                    catch (ParserException ex) {
                        Logger.getLogger(G1_LogRecords.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return stats;
                });
            }

            @Override
            public void postProcessRecord(G1_GCPauseWithMemStats record, G1_ParserState state) {
                state.setCurrentGCCycleDuration(record.cycleDuration);
                G1_GCPauseWithMemStats prev = state.getLastRecordOfType(G1_GCPauseWithMemStats.class);
                if (prev != null && prev.useBeforeGC != null && record.cycleDuration != null) {
                    long currentStart = state.getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS) - record.cycleDuration.getNanos();
                    double previousEnd = prev.getEventRelativeTimestamp(TimeUnit.NANOSECONDS);
                    double allocatedMb = Math.max(0.0, LogUnits.BYTES.convertTo(record.useBeforeGC.getBytes() - prev.useAfterGC.getBytes(), LogUnits.MEGABYTES));
                    double ms_diff = LogUnits.NANOSECONDS.convertTo((double)currentStart - previousEnd, LogUnits.MILLISECONDS);
                    if (ms_diff > 1.0) {
                        this.accessor.setFieldValue(record, allocationRate, allocatedMb / ms_diff * LogUnits.SECONDS.convertTo(1.0, LogUnits.MILLISECONDS));
                    }
                    record.setFieldValue(Parser.interCycleDuration, new LogFieldTypes.Duration((double)currentStart - previousEnd, LogUnits.NANOSECONDS));
                }
            }

            private List<G1_GCPauseWithMemStats> parseGCPauseLine(CharSequence line, BiFunction<List<CharSequence>, Boolean, G1_GCPauseWithMemStats> factory) {
                ArrayList<CharSequence> lexems = new ArrayList<CharSequence>();
                int length = line.length();
                int br_nesting = 0;
                int lex_start = 0;
                boolean in_ws = true;
                boolean has_duration = false;
                block9: for (int pos = "GC pause ".length(); pos < length; ++pos) {
                    char c = line.charAt(pos);
                    if (br_nesting == 0) {
                        switch (c) {
                            case ' ': 
                            case '-': 
                            case '>': {
                                if (lex_start > 0) {
                                    lexems.add(line.subSequence(lex_start, pos));
                                    lex_start = 0;
                                }
                                in_ws = true;
                                break;
                            }
                            case ',': {
                                lexems.add(TextUtils.trim(line.subSequence(pos + 1, length)));
                                pos = length;
                                has_duration = true;
                                break;
                            }
                            case '(': {
                                if (lex_start > 0) {
                                    lexems.add(line.subSequence(lex_start, pos));
                                }
                                ++br_nesting;
                                lex_start = ++pos;
                                in_ws = false;
                                break;
                            }
                            default: {
                                if (!in_ws) continue block9;
                                lex_start = pos;
                                in_ws = false;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (c) {
                        case '(': {
                            ++br_nesting;
                            continue block9;
                        }
                        case ')': {
                            if (--br_nesting != 0) continue block9;
                            lexems.add(line.subSequence(lex_start, pos));
                            lex_start = 0;
                        }
                    }
                }
                if (lex_start > 0) {
                    lexems.add(line.subSequence(lex_start, length));
                }
                return lexems.size() < 2 ? null : Collections.singletonList(factory.apply(lexems, has_duration));
            }

            static {
                try {
                    type = G1_GCPauseWithMemStats.class.getField("type");
                    generation = G1_GCPauseWithMemStats.class.getField("generation");
                    useBeforeGC = G1_GCPauseWithMemStats.class.getField("useBeforeGC");
                    useAfterGC = G1_GCPauseWithMemStats.class.getField("useAfterGC");
                    allocated = G1_GCPauseWithMemStats.class.getField("allocated");
                    cycleDuration = G1_GCPauseWithMemStats.class.getField("cycleDuration");
                    allocationRate = G1_GCPauseWithMemStats.class.getField("allocationRate");
                    interCycleDuration = G1_GCPauseWithMemStats.class.getField("interCycleDuration");
                }
                catch (NoSuchFieldException ex) {
                    throw new InternalError(ex);
                }
            }
        }
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":, ")
    public static class G1_GCParallelPhaseStats
    extends LogRecord {
        @LogLineField(prefix="Min")
        public double min;
        @LogLineField(prefix="Max")
        public double max;
        @LogLineField(prefix="Avg")
        public double avg;
        @LogLineField(prefix="Diff")
        public double diff;
        @LogLineField(prefix="Sum")
        public double sum;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":, ")
    public static class G1_GCParallelPhaseDurationStats
    extends LogRecord {
        @LogLineField(prefix="Min", defaultUnits=LogUnits.MILLISECONDS)
        public LogFieldTypes.Duration min;
        @LogLineField(prefix="Max", defaultUnits=LogUnits.MILLISECONDS)
        public LogFieldTypes.Duration max;
        @LogLineField(prefix="Avg", defaultUnits=LogUnits.MILLISECONDS)
        public LogFieldTypes.Duration avg;
        @LogLineField(prefix="Diff", defaultUnits=LogUnits.MILLISECONDS)
        public LogFieldTypes.Duration diff;
        @LogLineField(prefix="Sum", defaultUnits=LogUnits.MILLISECONDS)
        public LogFieldTypes.Duration sum;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_FreeCSetDuration
    extends LogRecord {
        @LogLineField(prefix="Free CSet")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_HumongousReclaimDuration
    extends LogRecord {
        @LogLineField(prefix="Humongous Reclaim")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_HumongousRegisterDuration
    extends LogRecord {
        @LogLineField(prefix="Humongous Register")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_RedirtyCardsDuration
    extends LogRecord {
        @LogLineField(prefix="Redirty Cards")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_RefEnqDuration
    extends LogRecord {
        @LogLineField(prefix="Ref Enq")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_RefProcDuration
    extends LogRecord {
        @LogLineField(prefix="Ref Proc")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_ChooseCSetDuration
    extends LogRecord {
        @LogLineField(prefix="Choose CSet")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_OtherDuration
    extends LogRecord {
        @LogLineField(prefix="Other")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_ClearCardTableDuration
    extends LogRecord {
        @LogLineField(prefix="Clear CT")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_CodeRootPurgeDuration
    extends LogRecord {
        @LogLineField(prefix="Code Root Purge")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=":")
    public static final class G1_CodeRootFixupDuration
    extends LogRecord {
        @LogLineField(prefix="Code Root Fixup")
        public LogFieldTypes.Duration duration;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators=",= ")
    public static final class G1_CPUTimes
    extends LogRecord {
        @LogLineField(prefix="user")
        public LogFieldTypes.Duration user;
        @LogLineField(prefix="sys")
        public LogFieldTypes.Duration sys;
        @LogLineField(prefix="real")
        public LogFieldTypes.Duration real;
    }

    @GCLogLineData(parserClass=SingleLineRecordParser.class)
    @GCLogFieldsLineDataParserParams(separators="]:,[")
    public static final class G1_ParallelPhaseStats
    extends LogRecord {
        @LogLineField(prefix="Parallel Time")
        public LogFieldTypes.Duration duration;
        @LogLineField(prefix="GC Workers")
        public int workers;
    }
}

