/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.g1;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.PrefixedLinesParser;
import com.azul.log.parser.impl.g1.G1_LogRecords;
import com.azul.log.parser.impl.g1.G1_ParserState;
import com.azul.log.parser.impl.g1.G1_Summary;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.utils.TextUtils;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class G1_LogParser
extends PrefixedLinesParser<G1_ParserState> {
    private final SummarySupport summarySupport;
    private final G1_Summary summary = new G1_Summary();

    public G1_LogParser(LogModel model) {
        super(model, new G1_ParserState(), new PrefixedLinesParser.PrefixedLineDefinition[]{new PrefixedLinesParser.PrefixedLineDefinition("GC pause", G1_LogRecords.G1_GCPauseWithMemStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC cleanup", G1_LogRecords.G1_GCCleanupStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC remark", G1_LogRecords.G1_GCRemarkStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC concurrent-mark-end", G1_LogRecords.G1_GCConcurrentMark.class), new PrefixedLinesParser.PrefixedLineDefinition("GC concurrent-cleanup-end", G1_LogRecords.G1_GCConcurrentCleanup.class), new PrefixedLinesParser.PrefixedLineDefinition("GC concurrent-root-region-scan-end", G1_LogRecords.G1_GCConcurrentRootScan.class), new PrefixedLinesParser.PrefixedLineDefinition("Parallel Time", G1_LogRecords.G1_ParallelPhaseStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC Worker Start (ms)", G1_LogRecords.G1_GCWorkerStartDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Ext Root Scanning (ms)", G1_LogRecords.G1_ExtRootScanningDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Update RS (ms)", G1_LogRecords.G1_UpdateRootSetDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Processed Buffers", G1_LogRecords.G1_ProcessBuffersStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Scan RS (ms)", G1_LogRecords.G1_ScanRSDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Code Root Scanning (ms)", G1_LogRecords.G1_CodeRootScanningDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Object Copy (ms)", G1_LogRecords.G1_ObjectCopyDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Termination (ms)", G1_LogRecords.G1_TerminationDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Termination Attempts", G1_LogRecords.G1_TerminationAttemptsStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC Worker Other (ms)", G1_LogRecords.G1_GCWorkerOtherDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC Worker Total (ms)", G1_LogRecords.G1_GCWorkerTotalDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("GC Worker End (ms)", G1_LogRecords.G1_GCWorkerEndDurationStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Code Root Fixup", G1_LogRecords.G1_CodeRootFixupDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Code Root Purge", G1_LogRecords.G1_CodeRootPurgeDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Clear CT", G1_LogRecords.G1_ClearCardTableDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Other", G1_LogRecords.G1_OtherDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Choose CSet", G1_LogRecords.G1_ChooseCSetDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Ref Proc", G1_LogRecords.G1_RefProcDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Ref Enq", G1_LogRecords.G1_RefEnqDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Redirty Cards", G1_LogRecords.G1_RedirtyCardsDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Humongous Register", G1_LogRecords.G1_HumongousRegisterDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Humongous Reclaim", G1_LogRecords.G1_HumongousReclaimDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Free CSet", G1_LogRecords.G1_FreeCSetDuration.class), new PrefixedLinesParser.PrefixedLineDefinition("Eden", G1_LogRecords.G1_GCHeapStats.class), new PrefixedLinesParser.PrefixedLineDefinition("Times", G1_LogRecords.G1_CPUTimes.class), new PrefixedLinesParser.PrefixedLineDefinition("Total time for which application threads were stopped", G1_LogRecords.G1_ApplicationStoppedTime.class)});
        this.summarySupport = this.initSummarySupport();
        this.ic.add(this.summary);
    }

    @Override
    protected boolean processRawLine(CharSequence line) {
        G1_LogRecords.G1_GCPauseWithMemStats stats;
        this.summarySupport.process(line);
        if (((G1_ParserState)this.state).getCurrentGCCycleDuration() == null && TextUtils.startsWith(line, ",") && (stats = ((G1_ParserState)this.state).getLastRecordOfType(G1_LogRecords.G1_GCPauseWithMemStats.class)) != null) {
            try {
                stats.setGCCycleDurationFrom(line.subSequence(2, line.length()).toString());
                ((G1_ParserState)this.state).setCurrentGCCycleDuration(stats.cycleDuration);
            }
            catch (ParserException ex) {
                Logger.getLogger(G1_LogParser.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    private SummarySupport initSummarySupport() {
        SummarySupport ss = new SummarySupport(l -> ((G1_ParserState)this.state).getCurrentLineNumber() > 10);
        ss.addExtractor(l -> {
            int p2;
            int p1 = TextUtils.indexOf(l, " VM ", 0);
            if (p1 > 0 && (p2 = TextUtils.indexOf(l, ", built on", p1)) > 0) {
                this.summary.vmVersion = l.subSequence(0, p2).toString();
                return true;
            }
            return false;
        });
        ss.addPrefixedExtractorC("CommandLine flags: ", s -> {
            this.summary.vmFlags = Arrays.stream((" " + s).split("[ ]+-")).map(String::trim).filter(f -> !f.isEmpty()).map(f -> "-" + f).collect(Collectors.toList());
        });
        ss.addPrefixedExtractorC("Memory: ", v -> {
            this.summary.memInfo = v;
        });
        return ss;
    }
}

