/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.g1;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;

public final class G1_FieldTypes {
    private G1_FieldTypes() {
    }

    public static class GCPauseType
    extends LogFieldTypes.LogFieldType {
        private static final GCPauseType[] types = new GCPauseType[]{new GCPauseType("G1 Evacuation Pause"), new GCPauseType("G1 Humongous Allocation"), new GCPauseType("GCLocker Initiated GC"), new GCPauseType("Metadata GC Threshold"), new GCPauseType("System.gc()")};
        private final String name;

        private GCPauseType(String name) {
            this.name = name;
        }

        public static GCPauseType fromString(String info, LogUnits defaultUnits) {
            for (GCPauseType type : types) {
                if (!info.equalsIgnoreCase(type.name)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class GCPriority
    extends LogFieldTypes.LogFieldType {
        private static final GCPriority[] priorities = new GCPriority[]{new GCPriority("normal")};
        private final String name;

        private GCPriority(String name) {
            this.name = name;
        }

        public static GCPriority fromString(String info, LogUnits defaultUnits) {
            for (GCPriority priority : priorities) {
                if (!info.equalsIgnoreCase(priority.name)) continue;
                return priority;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Generation
    extends LogFieldTypes.LogFieldType {
        private static final Generation[] generations = new Generation[]{new Generation("Full"), new Generation("Young"), new Generation("Mixed")};
        private final String name;

        private Generation(String name) {
            this.name = name;
        }

        public static Generation fromString(String info, LogUnits defaultUnits) {
            for (Generation generation : generations) {
                if (!info.equalsIgnoreCase(generation.name)) continue;
                return generation;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class G1PauseYoungReason
    extends LogFieldTypes.DistinctValueType {
        private static final LogFieldTypes.DistinctValuesSupport<G1PauseYoungReason> support = new LogFieldTypes.DistinctValuesSupport();

        public G1PauseYoungReason(int id) {
            super(id);
        }

        public static G1PauseYoungReason fromString(String reason, LogUnits defaultUnits) {
            return LogFieldTypes.DistinctValueType.fromString(G1PauseYoungReason.class, support, reason);
        }

        public String toString() {
            return support.getLabel(this.id);
        }

        public static class LabelConverter
        extends LogFieldTypes.DistinctValuesLabelConverter<G1PauseYoungReason> {
            public LabelConverter() {
                super(support);
            }
        }
    }

    public static final class G1PauseFullCompactionReason
    extends LogFieldTypes.DistinctValueType {
        private static final LogFieldTypes.DistinctValuesSupport<G1PauseFullCompactionReason> support = new LogFieldTypes.DistinctValuesSupport();

        public G1PauseFullCompactionReason(int id) {
            super(id);
        }

        public static G1PauseFullCompactionReason fromString(String reason, LogUnits defaultUnits) {
            return LogFieldTypes.DistinctValueType.fromString(G1PauseFullCompactionReason.class, support, reason);
        }

        public String toString() {
            return support.getLabel(this.id);
        }

        public static class LabelConverter
        extends LogFieldTypes.DistinctValuesLabelConverter<G1PauseFullCompactionReason> {
            public LabelConverter() {
                super(support);
            }
        }
    }
}

