/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.g1;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.g1.G1ConcurrentCycleRecordFields;
import com.azul.log.parser.impl.g1.G1PauseFullCompactionRecordFields;
import com.azul.log.parser.impl.g1.G1PauseYoungRecordFields;
import com.azul.log.parser.impl.g1.G1U_LogRecords;
import com.azul.log.parser.impl.g1.G1U_ParserState;
import com.azul.log.parser.impl.g1.G1_Summary;
import com.azul.log.parser.impl.support.RecordsProcessingSupport;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.impl.support.UnifiedLogGCCycleParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public final class G1U_LogParser
extends UnifiedLogGCCycleParser<G1U_ParserState, G1_Summary> {
    private static int regionSize_mb = 2;

    public G1U_LogParser(LogModel model) {
        super(model, new G1U_ParserState(), new UnifiedLogGCCycleParser.GCCycleParser[]{new PauseYoungParser(), new G1ConcurrentCycleParser(), new G1PauseFullCompactionParser()}, new G1_Summary(), G1U_LogParser::initSummarySupport);
    }

    private static SummarySupport initSummarySupport(G1_Summary s, G1U_ParserState state) {
        SummarySupport ss = new SummarySupport(l -> state.getCurrentLineNumber() > 50);
        ss.addPrefixedExtractorC("version: ", v -> {
            s.vmVersion = v;
        });
        ss.addPrefixedExtractorC("cpus:", v -> {
            Map<String, String> data = Arrays.stream(v.split(",")).map(String::trim).map(st -> st.split(" ")).collect(Collectors.toMap(x -> x[1].trim(), y -> y[0].trim()));
            s.totalCPUs = data.get("total");
            s.availableCPUs = data.get("available");
        });
        ss.addPrefixedExtractorC("memory: ", v -> {
            s.memInfo = v;
        });
        ss.addPrefixedExtractorC("large page support: ", v -> {
            s.largePageSupport = v;
        });
        ss.addPrefixedExtractorC("numa support: ", v -> {
            s.numaSupport = v;
        });
        ss.addPrefixedExtractorC("numa nodes: ", v -> {
            s.numaNodes = v;
        });
        ss.addPrefixedExtractorC("compressed oops: ", v -> {
            s.compressedOops = v;
        });
        ss.addPrefixedExtractorC("heap region size:", v -> {
            s.heapRegionSize = v;
            try {
                regionSize_mb = LogFieldTypes.Size.fromString(v, LogUnits.MEGABYTES).getDoubleValue(LogUnits.MEGABYTES).intValue();
            }
            catch (ParserException ex) {
                Logger.getLogger(G1U_LogParser.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        ss.addPrefixedExtractorC("heap address: ", v -> {
            Map<String, String> data = Arrays.stream(("Heap address: " + v).split(",")).map(String::trim).map(st -> st.split(":")).collect(Collectors.toMap(x -> x[0].trim(), y -> y[1].trim()));
            s.compressedOopsMode = data.get("Compressed Oops mode");
            s.oopShiftAmount = data.get("Oop shift amount");
            s.heapAddress = data.get("Heap address");
            s.heapSize = data.get("size");
        });
        ss.addPrefixedExtractorC("heap min capacity: ", v -> {
            s.heapMinCapacity = v;
        });
        ss.addPrefixedExtractorC("heap initial capacity: ", v -> {
            s.heapInitialCapacity = v;
        });
        ss.addPrefixedExtractorC("heap max capacity: ", v -> {
            s.heapMaxCapacity = v;
        });
        ss.addPrefixedExtractorC("pre-touch: ", v -> {
            s.preTouch = v;
        });
        ss.addPrefixedExtractorC("parallel workers: ", v -> {
            s.parallelWorkers = v;
        });
        ss.addPrefixedExtractorC("concurrent workers: ", v -> {
            s.concurrentWorkers = v;
        });
        ss.addPrefixedExtractorC("concurrent refinement workers: ", v -> {
            s.concurrentRefinementWorkers = v;
        });
        ss.addPrefixedExtractorC("periodic gc: ", v -> {
            s.periodicGC = v;
        });
        ss.addPrefixedExtractorC("periodic gc ", v -> {
            s.periodicGC = v;
        });
        return ss;
    }

    private static CharSequence regionsToSize(CharSequence count) {
        return LogFieldTypes.Size.of(Long.parseLong(count.toString()) * (long)regionSize_mb, LogUnits.MEGABYTES).toString();
    }

    private static final class G1ConcurrentCycleParser
    extends UnifiedLogGCCycleParser.GCCycleParser<G1U_LogRecords.G1ConcurrentCycleRecord, G1U_ParserState>
    implements G1ConcurrentCycleRecordFields {
        public G1ConcurrentCycleParser() {
            super("Concurrent Cycle", G1U_LogRecords.G1ConcurrentCycleRecord::new);
            this.lineParsers.addAll(Arrays.asList(this.regExp("Concurrent Clear Claimed Marks (.*)", concurrentClearClaimedMarksDuration), this.regExp("Concurrent Scan Root Regions (.*)", concurrentScanRootRegionsDuration), this.regExp("Using (.*) workers of (.*) for marking", markingActiveWorkers, markingTotalWorkers), this.regExp("Concurrent Mark From Roots (.*)", concurrentMarkFromRootsDuration), this.regExp("Concurrent Preclean (.*)", concurrentPrecleanDuration), this.regExp("Concurrent Mark \\((.*), (.*)\\) (.*)", concurrentMarkStart, concurrentMarkEnd, concurrentMarkDuration), this.regExp("Cleaned string and symbol table, strings: (.*) processed, (.*) removed, symbols: (.*) processed, (.*) removed", stringsProcessed, stringsRemoved, symbolsProcessed, symbolsRemoved), this.regExp("Pause Remark (.*)->(.*)\\((.*)\\) (.*)", remarkPauseHeapBefore, remarkPauseHeapAfter, remarkPauseHeapAllocated, remarkPauseDuration), this.regExp("Concurrent Rebuild Remembered Sets (.*)", concurrentRebuildRememberedSetsDuration), this.regExp("Pause Cleanup (.*)->(.*)\\((.*)\\) (.*)", cleanupPauseHeapBefore, cleanupPauseHeapAfter, cleanupPauseHeapAllocated, cleanupPauseDuration), this.regExp("Concurrent Cleanup for Next Mark (.*)", concurrentCleanupForNextMarkDuration), G1ConcurrentCycleParser.of("Concurrent Cycle (.*)", (r, m) -> {
                this.set(r, (Matcher)m, cycleDuration);
                return Collections.singletonList(r);
            })));
        }
    }

    private static final class G1PauseFullCompactionParser
    extends UnifiedLogGCCycleParser.GCCycleParser<G1U_LogRecords.G1PauseFullCompactionRecord, G1U_ParserState>
    implements G1PauseFullCompactionRecordFields {
        public G1PauseFullCompactionParser() {
            super("Pause Full", G1U_LogRecords.G1PauseFullCompactionRecord::new);
            this.lineParsers.addAll(Arrays.asList(this.regExp("Using (.*) workers of (.*) for full compaction", fullCompactionActiveWorkers, fullCompactionTotalWorkers), this.regExp("Cleaned string and symbol table, strings: (.*) processed, (.*) removed, symbols: (.*) processed, (.*) removed", stringsProcessed, stringsRemoved, symbolsProcessed, symbolsRemoved), this.regExp("Phase 1: Mark live objects (.*)", markLiveObjectsDuration), this.regExp("Phase 2: Prepare for compaction (.*)", prepareForCompactionDuration), this.regExp("Phase 3: Adjust pointers (.*)", adjustPointersDuration), this.regExp("Phase 4: Compact heap (.*)", compactHeapDuration), this.regExp("Eden regions: (.*)->(.*)\\((.*)\\)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), edenBeforeGC, edenAfterGC, edenAllocated), this.regExp("Survivor regions: (.*)->(.*)\\((.*)\\)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), survivorBeforeGC, survivorAfterGC, survivorAllocated), this.regExp("Old regions: (.*)->(.*)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), oldBeforeGC, oldAfterGC), this.regExp("Humongous regions: (.*)->(.*)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), humongousBeforeGC, humongousAfterGC), this.regExp("Metaspace: (.*)\\((.*)\\)->(.*)\\((.*)\\) NonClass: (.*)\\((.*)\\)->(.*)\\((.*)\\) Class: (.*)\\((.*)\\)->(.*)\\((.*)\\)", metaspaceUseBeforeGC, metaspaceAllocatedBeforeGC, metaspaceUseAfterGC, metaspaceAllocatedAfterGC, metaspaceNonClassUseBeforeGC, metaspaceNonClassAllocatedBeforeGC, metaspaceNonClassUseAfterGC, metaspaceNonClassAllocatedAfterGC, metaspaceClassUseBeforeGC, metaspaceClassAllocatedBeforeGC, metaspaceClassUseAfterGC, metaspaceClassAllocatedAfterGC), G1PauseFullCompactionParser.of("Pause Full \\((.*)\\) (.*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                this.set(r, (Matcher)m, reason, heapUseBeforeGC, heapUseAfterGC, heapAllocated, cycleDuration);
                return Collections.singletonList(r);
            }), this.regExp("User=(.*) Sys=(.*) Real=(.*)", uTime, sTime, rTime)));
        }
    }

    private static final class PauseYoungParser
    extends UnifiedLogGCCycleParser.GCCycleParser<G1U_LogRecords.G1PauseYoungRecord, G1U_ParserState>
    implements G1PauseYoungRecordFields {
        private final List<RecordsProcessingSupport.OverTimeAllocationRate> allocationRatesOverTime;

        public PauseYoungParser() {
            super("Pause Young", G1U_LogRecords.G1PauseYoungRecord::new);
            this.lineParsers.addAll(Arrays.asList(this.regExp("Using ([0-9]+) workers of ([0-9]+) for evacuation", evacuationActiveWorkers, evacuationTotalWorkers), this.regExp("Pre Evacuate Collection Set: (.*)", preEvacuateCollectionSetDuration), this.regExp("Evacuate Collection Set: (.*)", evacuateCollectionSetDuration), this.regExp("Post Evacuate Collection Set: (.*)", postEvacuateCollectionSetDuration), this.regExp("Other: (.*)", otherDuration), this.regExp("Eden regions: (.*)->(.*)\\((.*)\\)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), edenBeforeGC, edenAfterGC, edenAllocated), this.regExp("Survivor regions: (.*)->(.*)\\((.*)\\)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), survivorBeforeGC, survivorAfterGC, survivorAllocated), this.regExp("Old regions: (.*)->(.*)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), oldBeforeGC, oldAfterGC), this.regExp("Humongous regions: (.*)->(.*)", (CharSequence x$0) -> G1U_LogParser.regionsToSize(x$0), humongousBeforeGC, humongousAfterGC), this.regExp("Metaspace: (.*)\\((.*)\\)->(.*)\\((.*)\\) NonClass: (.*)\\((.*)\\)->(.*)\\((.*)\\) Class: (.*)\\((.*)\\)->(.*)\\((.*)\\)", metaspaceUseBeforeGC, metaspaceAllocatedBeforeGC, metaspaceUseAfterGC, metaspaceAllocatedAfterGC, metaspaceNonClassUseBeforeGC, metaspaceNonClassAllocatedBeforeGC, metaspaceNonClassUseAfterGC, metaspaceNonClassAllocatedAfterGC, metaspaceClassUseBeforeGC, metaspaceClassAllocatedBeforeGC, metaspaceClassUseAfterGC, metaspaceClassAllocatedAfterGC), PauseYoungParser.of("Pause Young \\((.*)\\) \\((.*)\\) ([^ ]*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                this.set(r, (Matcher)m, type, reason, heapUseBeforeGC, heapUseAfterGC, heapAllocated, cycleDuration);
                return Collections.singletonList(r);
            }), this.regExp("User=(.*) Sys=(.*) Real=(.*)", uTime, sTime, rTime)));
            this.allocationRatesOverTime = Arrays.asList(new RecordsProcessingSupport.OverTimeAllocationRate(0L, TimeUnit.SECONDS, (r, u) -> this.accessor.setFieldValue(r, interCycleAllocationRate, u)), new RecordsProcessingSupport.OverTimeAllocationRate(1L, TimeUnit.SECONDS, (r, u) -> this.accessor.setFieldValue(r, interCycleAllocationRate_1, u)), new RecordsProcessingSupport.OverTimeAllocationRate(30L, TimeUnit.SECONDS, (r, u) -> this.accessor.setFieldValue(r, interCycleAllocationRate_30, u)));
        }

        @Override
        public void postProcessRecord(G1U_LogRecords.G1PauseYoungRecord previousRecord, G1U_LogRecords.G1PauseYoungRecord currentRecord, G1U_ParserState state) {
            if (previousRecord != null) {
                long currentStart = state.getCurrentLineRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS) - currentRecord.cycleDuration.getNanos();
                double previousEnd = previousRecord.getEventRelativeTimestamp(TimeUnit.NANOSECONDS);
                LogFieldTypes.Duration dur = new LogFieldTypes.Duration((double)currentStart - previousEnd, LogUnits.NANOSECONDS);
                LogFieldTypes.Size alloc = currentRecord.heapUseBeforeGC.subtract(previousRecord.heapUseAfterGC);
                this.allocationRatesOverTime.forEach(u -> u.process(dur, alloc, currentRecord));
            }
        }
    }
}

