/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.cms;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.cms.CMS_FieldTypes;
import com.azul.log.parser.impl.cms.CMS_ParserState;
import com.azul.log.parser.impl.spi.annotations.GCLogFieldsLineDataParserParams;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.impl.support.SingleLineRecordParser;
import com.azul.log.parser.spi.annotations.LogLineField;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CMS_LogRecords {
    private CMS_LogRecords() {
    }

    @GCLogLineData(parserClass=Parser.class)
    public static class CMS_GCStats
    extends LogRecord {

        public static class Parser
        extends LogLineParser<CMS_GCStats, CMS_ParserState> {
            private final LogLineParser.LogRecordFieldSetter<CMS_FieldTypes.GCSpace> spaceStatSpace = this.fieldSetter(CMS_GCSpaceStat.class, "space");
            private final LogLineParser.LogRecordFieldSetter<LogFieldTypes.Duration> spaceStatDuration;
            private final LogLineParser.LogRecordFieldSetter<CMS_FieldTypes.GC> cycleNewGenGC;
            private final LogLineParser.LogRecordFieldSetter<LogFieldTypes.Size> heapSizeDelta;
            private final LogLineParser.LogRecordFieldSetter<LogFieldTypes.Size> spaceSizeDelta = this.fieldSetter(CMS_GCSpaceStat.class, "sizeDelta");
            private final LogLineParser.LogRecordFieldSetter<LogFieldTypes.Size> newGenPromotion;

            public Parser(Class<CMS_GCStats> klass) throws NoSuchFieldException, NoSuchMethodException {
                this.spaceStatDuration = this.fieldSetter(CMS_GCSpaceStat.class, "duration");
                this.cycleNewGenGC = this.fieldSetter(CMS_GCCycle.class, "newGenGC");
                this.heapSizeDelta = this.fieldSetter(CMS_GCCycle.class, "sizeDelta");
                this.newGenPromotion = this.fieldSetter(CMS_GCCycle.class, "newGenPromoted");
            }

            @Override
            public List<CMS_GCStats> parseDataChunk(CharSequence line) throws ParserException {
                ArrayList<CMS_GCStats> records = new ArrayList<CMS_GCStats>();
                StringBuilder data = new StringBuilder();
                ArrayList<String> chunks = new ArrayList<String>();
                int in_brackets = 0;
                int start = 0;
                int end = TextUtils.indexOf(line, "[Times: ", 0);
                if (end < 0) {
                    return null;
                }
                for (int i = 0; i < end; ++i) {
                    char c = line.charAt(i);
                    if (c == '[') {
                        ++in_brackets;
                        start = i + 1;
                        continue;
                    }
                    if (c == ']') {
                        if (--in_brackets != 0) continue;
                        chunks.add(line.subSequence(start, i).toString());
                        continue;
                    }
                    if (in_brackets > 0 || c == ',') continue;
                    data.append(c);
                }
                chunks.add(line.subSequence(end + 1, line.length()).toString());
                String cycleInfo = data.toString().replaceAll(" [0-9.]*:", "").replace("  ", " ").trim();
                CMS_GCCycle gcCycle = (CMS_GCCycle)CMS_GCCycle.parser.parseDataChunk(cycleInfo).get(0);
                String newGen = (String)chunks.get(0);
                CMS_GCSpaceStat newGenStat = (CMS_GCSpaceStat)CMS_GCSpaceStat.parser.parseDataChunk(newGen).get(0);
                LogFieldTypes.Size heapDelta = gcCycle.heapUseAfterGC != null && gcCycle.heapUseBeforeGC != null ? gcCycle.heapUseAfterGC.subtract(gcCycle.heapUseBeforeGC) : LogFieldTypes.Size.of(0L, LogUnits.BYTES);
                LogFieldTypes.Size newGenDelta = newGenStat.afterGC.subtract(newGenStat.beforeGC);
                try {
                    this.heapSizeDelta.assign((LogRecord)gcCycle, heapDelta);
                    this.spaceSizeDelta.assign((LogRecord)newGenStat, newGenDelta);
                    String gc = newGen.substring(0, newGen.indexOf(58));
                    this.cycleNewGenGC.assign((LogRecord)gcCycle, gc);
                    this.spaceStatSpace.assign((LogRecord)newGenStat, "New");
                    int duration_start = newGen.lastIndexOf(", ");
                    int duration_end = newGen.lastIndexOf(32);
                    String duration = newGen.substring(duration_start + 2, duration_end);
                    this.spaceStatDuration.assign(newGenStat, duration, LogUnits.SECONDS);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    if (ex.getCause() instanceof ParserException) {
                        throw (ParserException)ex.getCause();
                    }
                    Logger.getLogger(CMS_LogRecords.class.getName()).log(Level.SEVERE, null, ex);
                }
                records.add(gcCycle);
                records.add(newGenStat);
                LogFieldTypes.Duration remaining_duration = gcCycle.cycleDuration.subtract(newGenStat.duration);
                boolean new_only = true;
                for (int i = 1; i < chunks.size() - 1; ++i) {
                    new_only = false;
                    String spaceInfo = (String)chunks.get(i);
                    CMS_GCSpaceStat spaceStat = (CMS_GCSpaceStat)CMS_GCSpaceStat.parser.parseDataChunk(spaceInfo).get(0);
                    try {
                        this.spaceSizeDelta.assign((LogRecord)spaceStat, spaceStat.afterGC.subtract(spaceStat.beforeGC));
                        String space = spaceInfo.substring(0, spaceInfo.indexOf(58));
                        this.spaceStatSpace.assign((LogRecord)spaceStat, space);
                        int duration_start = spaceInfo.lastIndexOf(", ");
                        int duration_end = spaceInfo.lastIndexOf(32);
                        if (duration_start > 0) {
                            String duration = spaceInfo.substring(duration_start + 2, duration_end);
                            LogFieldTypes.Duration d = this.spaceStatDuration.assign(spaceStat, duration, LogUnits.SECONDS);
                            remaining_duration.subtract(d);
                        } else {
                            this.spaceStatDuration.assign((LogRecord)spaceStat, remaining_duration);
                        }
                        records.add(spaceStat);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        Logger.getLogger(CMS_LogRecords.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (new_only) {
                    try {
                        this.newGenPromotion.assign((LogRecord)gcCycle, heapDelta.subtract(newGenDelta));
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(CMS_LogRecords.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                records.addAll(CMS_CPUTimes.parser.parseDataChunk((CharSequence)chunks.get(chunks.size() - 1)));
                return records;
            }
        }
    }

    @GCLogFieldsLineDataParserParams(regex="Times: user=([0-9.]*) sys=([0-9.]*), real=([0-9.]*) secs")
    public static final class CMS_CPUTimes
    extends CMS_GCStats {
        private static final Parser parser = new Parser();
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration user;
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration sys;
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration real;

        public static class Parser
        extends SingleLineRecordParser<CMS_CPUTimes, CMS_ParserState> {
            public Parser() {
                super(CMS_CPUTimes.class);
            }
        }
    }

    @GCLogFieldsLineDataParserParams(regex=".* (.*)->(.*)\\((.*)\\).*")
    public static class CMS_GCSpaceStat
    extends CMS_GCStats {
        private static final CMS_GCGenStatParser parser = new CMS_GCGenStatParser();
        @LogLineField
        public LogFieldTypes.Size beforeGC;
        @LogLineField
        public LogFieldTypes.Size afterGC;
        @LogLineField
        public LogFieldTypes.Size size;
        @LogLineField
        public CMS_FieldTypes.GCSpace space;
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration duration;
        @LogRecordCalculatedField(deps={"beforeGC", "afterGC"})
        public LogFieldTypes.Size sizeDelta;

        public static class CMS_GCGenStatParser
        extends SingleLineRecordParser<CMS_GCSpaceStat, CMS_ParserState> {
            public CMS_GCGenStatParser() {
                super(CMS_GCSpaceStat.class);
            }
        }
    }

    @GCLogFieldsLineDataParserParams(regex="(.*) \\((.*)\\) (.*)->(.*)\\((.*)\\) (.*) secs")
    public static final class CMS_GCCycle
    extends CMS_GCStats {
        private static final CMS_GCCycleParser parser = new CMS_GCCycleParser();
        @LogLineField
        public CMS_FieldTypes.Generation generation;
        @LogLineField
        public CMS_FieldTypes.GCReason reason;
        @LogLineField
        public LogFieldTypes.Size heapUseBeforeGC;
        @LogLineField
        public LogFieldTypes.Size heapUseAfterGC;
        @LogLineField
        public LogFieldTypes.Size heapSize;
        @LogLineField(defaultUnits=LogUnits.SECONDS)
        public LogFieldTypes.Duration cycleDuration;
        @LogLineField
        public CMS_FieldTypes.GC newGenGC;
        @LogRecordCalculatedField(deps={"heapUseBeforeGC", "heapUseAfterGC"})
        public LogFieldTypes.Size sizeDelta;
        @LogLineField
        public LogFieldTypes.Size newGenPromoted;

        public static class CMS_GCCycleParser
        extends SingleLineRecordParser<CMS_GCCycle, CMS_ParserState> {
            public CMS_GCCycleParser() {
                super(CMS_GCCycle.class);
            }
        }
    }
}

