/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.cms;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.PrefixedLinesParser;
import com.azul.log.parser.impl.cms.CMS_LogRecords;
import com.azul.log.parser.impl.cms.CMS_ParserState;
import com.azul.log.parser.impl.cms.CMS_Summary;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.utils.TextUtils;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class CMS_LogParser
extends PrefixedLinesParser<CMS_ParserState> {
    private final SummarySupport summarySupport;
    private final CMS_Summary summary = new CMS_Summary();

    public CMS_LogParser(LogModel model) {
        super(model, new CMS_ParserState(), new PrefixedLinesParser.PrefixedLineDefinition[]{new PrefixedLinesParser.PrefixedLineDefinition("Full GC ", CMS_LogRecords.CMS_GCStats.class, CMS_LogRecords.CMS_GCSpaceStat.class, CMS_LogRecords.CMS_GCCycle.class, CMS_LogRecords.CMS_CPUTimes.class), new PrefixedLinesParser.PrefixedLineDefinition("GC ", CMS_LogRecords.CMS_GCStats.class, CMS_LogRecords.CMS_GCSpaceStat.class, CMS_LogRecords.CMS_GCCycle.class, CMS_LogRecords.CMS_CPUTimes.class)});
        this.summarySupport = this.initSummarySupport();
        this.ic.add(this.summary);
    }

    @Override
    protected boolean processRawLine(CharSequence line) {
        this.summarySupport.process(line);
        return true;
    }

    private SummarySupport initSummarySupport() {
        SummarySupport ss = new SummarySupport(l -> ((CMS_ParserState)this.state).getCurrentLineNumber() > 10);
        ss.addExtractor(l -> {
            int p2;
            int p1 = TextUtils.indexOf(l, " VM ", 0);
            if (p1 > 0 && (p2 = TextUtils.indexOf(l, ", built on", p1)) > 0) {
                this.summary.vmVersion = l.subSequence(0, p2).toString();
                return true;
            }
            return false;
        });
        String commandLinePrefix = "CommandLine flags: ";
        int commandLinePrefixLen = commandLinePrefix.length();
        ss.addExtractor(l -> {
            if (TextUtils.startsWith(l, commandLinePrefix)) {
                String s = l.toString().substring(commandLinePrefixLen).trim();
                this.summary.vmFlags = Arrays.stream((" " + s).split(" +-")).map(String::trim).filter(f -> !f.isEmpty()).map(f -> "-" + f).collect(Collectors.toList());
                return true;
            }
            return false;
        });
        return ss;
    }
}

