/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.cms;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.cms.CMSPauseFullRecordFields;
import com.azul.log.parser.impl.cms.CMSPauseYoungRecordFields;
import com.azul.log.parser.impl.cms.CMSU_LogRecords;
import com.azul.log.parser.impl.cms.CMSU_ParserState;
import com.azul.log.parser.impl.cms.CMS_ParserState;
import com.azul.log.parser.impl.cms.CMS_Summary;
import com.azul.log.parser.impl.support.SummarySupport;
import com.azul.log.parser.impl.support.UnifiedLogGCCycleParser;
import com.azul.log.parser.utils.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CMSU_LogParser
extends UnifiedLogGCCycleParser<CMSU_ParserState, CMS_Summary> {
    public CMSU_LogParser(LogModel model) {
        super(model, new CMSU_ParserState(), new UnifiedLogGCCycleParser.GCCycleParser[]{new CMSPauseYoungParser(), new CMSPauseFullParser()}, new CMS_Summary(), CMSU_LogParser::initSummarySupport);
    }

    private static SummarySupport initSummarySupport(CMS_Summary s, CMSU_ParserState state) {
        SummarySupport ss = new SummarySupport(l -> state.getCurrentLineNumber() > 10);
        ss.addPrefixedExtractorC("Heap address", l -> {
            Pattern p = Pattern.compile(": (.*), size: (.*), Compressed Oops mode: (.*), Oop shift amount: (.*)");
            Matcher m = p.matcher((CharSequence)l);
            if (m.matches()) {
                s.heapAddress = m.group(1);
                s.heapSize = m.group(2);
                s.compressedOopsMode = m.group(3);
                s.oopShiftAmount = m.group(4);
            }
        });
        ss.addExtractor(l -> {
            int p2;
            int p1 = TextUtils.indexOf(l, " VM ", 0);
            if (p1 > 0 && (p2 = TextUtils.indexOf(l, ", built on", p1)) > 0) {
                s.vmVersion = l.subSequence(0, p2).toString();
                return true;
            }
            return false;
        });
        String commandLinePrefix = "CommandLine flags: ";
        int commandLinePrefixLen = commandLinePrefix.length();
        ss.addExtractor(l -> {
            if (TextUtils.startsWith(l, commandLinePrefix)) {
                String text = l.toString().substring(commandLinePrefixLen).trim();
                s.vmFlags = Arrays.stream((" " + text).split("[ ]+-")).map(String::trim).filter(f -> !f.isEmpty()).map(f -> "-" + f).collect(Collectors.toList());
                return true;
            }
            return false;
        });
        return ss;
    }

    private static final class CMSPauseFullParser
    extends UnifiedLogGCCycleParser.GCCycleParser<CMSU_LogRecords.CMSPauseFullRecord, CMS_ParserState>
    implements CMSPauseFullRecordFields {
        public CMSPauseFullParser() {
            super("Pause Full", CMSU_LogRecords.CMSPauseFullRecord::new);
            this.lineParsers.addAll(Arrays.asList(this.regExp("Phase 1: Mark live objects (.*)", markLiveObjectsDuration), this.regExp("Phase 2: Compute new object addresses (.*)", computeNewObjectAddressesDuration), this.regExp("Phase 3: Adjust pointers (.*)", adjustPointersDuration), this.regExp("Phase 4: Move objects (.*)", moveObjectsDuration), this.regExp("ParNew: (.*)->(.*)\\((.*)\\)", parNewGenBeforeGC, parNewGenAfterGC, parNewGenAllocated), this.regExp("CMS: (.*)->(.*)\\((.*)\\)", cmsBeforeGC, cmsAfterGC, cmsAllocated), this.regExp("Metaspace: (.*)\\((.*)\\)->(.*)\\((.*)\\) NonClass: (.*)\\((.*)\\)->(.*)\\((.*)\\) Class: (.*)\\((.*)\\)->(.*)\\((.*)\\)", metaspaceUseBeforeGC, metaspaceAllocatedBeforeGC, metaspaceUseAfterGC, metaspaceAllocatedAfterGC, metaspaceNonClassUseBeforeGC, metaspaceNonClassAllocatedBeforeGC, metaspaceNonClassUseAfterGC, metaspaceNonClassAllocatedAfterGC, metaspaceClassUseBeforeGC, metaspaceClassAllocatedBeforeGC, metaspaceClassUseAfterGC, metaspaceClassAllocatedAfterGC), CMSPauseFullParser.of("Pause Full \\((.*)\\) (.*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                this.set(r, (Matcher)m, reason, heapUseBeforeGC, heapUseAfterGC, heapAllocated, cycleDuration);
                return Collections.singletonList(r);
            }), this.regExp("User=(.*) Sys=(.*) Real=(.*)", uTime, sTime, rTime)));
        }
    }

    private static final class CMSPauseYoungParser
    extends UnifiedLogGCCycleParser.GCCycleParser<CMSU_LogRecords.CMSPauseYoungRecord, CMS_ParserState>
    implements CMSPauseYoungRecordFields {
        public CMSPauseYoungParser() {
            super("Pause Young", CMSU_LogRecords.CMSPauseYoungRecord::new);
            this.lineParsers.addAll(Arrays.asList(this.regExp("Using ([0-9]+) workers of ([0-9]+) for evacuation", evacuationActiveWorkers, evacuationTotalWorkers), this.regExp("ParNew: (.*)->(.*)\\((.*)\\)", parNewGenBeforeGC, parNewGenAfterGC, parNewGenAllocated), this.regExp("CMS: (.*)->(.*)\\((.*)\\)", cmsBeforeGC, cmsAfterGC, cmsAllocated), this.regExp("Metaspace: (.*)\\((.*)\\)->(.*)\\((.*)\\) NonClass: (.*)\\((.*)\\)->(.*)\\((.*)\\) Class: (.*)\\((.*)\\)->(.*)\\((.*)\\)", metaspaceUseBeforeGC, metaspaceAllocatedBeforeGC, metaspaceUseAfterGC, metaspaceAllocatedAfterGC, metaspaceNonClassUseBeforeGC, metaspaceNonClassAllocatedBeforeGC, metaspaceNonClassUseAfterGC, metaspaceNonClassAllocatedAfterGC, metaspaceClassUseBeforeGC, metaspaceClassAllocatedBeforeGC, metaspaceClassUseAfterGC, metaspaceClassAllocatedAfterGC), CMSPauseYoungParser.of("Pause Young \\((.*)\\) ([^ ]*)->(.*)\\((.*)\\) (.*)", (r, m) -> {
                this.set(r, (Matcher)m, reason, heapUseBeforeGC, heapUseAfterGC, heapAllocated, cycleDuration);
                return Collections.singletonList(r);
            }), this.regExp("User=(.*) Sys=(.*) Real=(.*)", uTime, sTime, rTime)));
        }
    }
}

