/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="SYSINFOH", data_marker="SYSINFO")
@C4_FieldsDescription(file="c4/SysinfoRecord")
public final class SysinfoRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="sysMemUsed", defaultUnits=LogUnits.MEGABYTES)
    public int sysMemUsed;
    @C4_GCLogRecordField(header="cacheActiveFile", defaultUnits=LogUnits.MEGABYTES)
    public int cacheActiveFile;
    @C4_GCLogRecordField(header="cacheInactiveFile", defaultUnits=LogUnits.MEGABYTES)
    public int cacheInactiveFile;
    @C4_GCLogRecordField(header="cacheActiveAnon", defaultUnits=LogUnits.MEGABYTES)
    public int cacheActiveAnon;
    @C4_GCLogRecordField(header="cacheInactiveAnon", defaultUnits=LogUnits.MEGABYTES)
    public int cacheInactiveAnon;
    @C4_GCLogRecordField(header="swapCached", defaultUnits=LogUnits.MEGABYTES)
    public int swapCached;
    @C4_GCLogRecordField(header="buffers", defaultUnits=LogUnits.MEGABYTES)
    public int buffers;
    @C4_GCLogRecordField(header="unevictable", defaultUnits=LogUnits.MEGABYTES)
    public int unevictable;
    @C4_GCLogRecordField(header="mlocked", defaultUnits=LogUnits.MEGABYTES)
    public int mlocked;
    @C4_GCLogRecordField(header="mapped", defaultUnits=LogUnits.MEGABYTES)
    public int mapped;
    @C4_GCLogRecordField(header="memAvailable", defaultUnits=LogUnits.MEGABYTES)
    public int memAvailable;
    @C4_GCLogRecordField(header="dirty", defaultUnits=LogUnits.MEGABYTES)
    public int dirty;
    @C4_GCLogRecordField(header="totalSysZingMemAcrossPartitions", defaultUnits=LogUnits.MEGABYTES)
    public int totalSysZingMemAcrossPartitions;
    @C4_GCLogRecordField(header="sysZingMemTot", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingMemTot;
    @C4_GCLogRecordField(header="sysZingReservableUsed", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingReservableUsed;
    @C4_GCLogRecordField(header="sysZingReservableTot", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingReservableTot;
    @C4_GCLogRecordField(header="sysZingContMemUsed", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingContMemUsed;
    @C4_GCLogRecordField(header="sysZingContMemTot", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingContMemTot;
    @C4_GCLogRecordField(header="sysZingPPMemUsed", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingPPMemUsed;
    @C4_GCLogRecordField(header="sysZingPPMemTot", defaultUnits=LogUnits.MEGABYTES)
    public int sysZingPPMemTot;
    @C4_GCLogRecordField(header="swapUsed", defaultUnits=LogUnits.MEGABYTES)
    public int swapUsed;
    @C4_GCLogRecordField(header="swapMax", defaultUnits=LogUnits.MEGABYTES)
    public int swapMax;
    @C4_GCLogRecordField(header="load1", defaultUnits=LogUnits.THREADS)
    public double load1;
    @C4_GCLogRecordField(header="load5", defaultUnits=LogUnits.THREADS)
    public double load5;
    @C4_GCLogRecordField(header="load15", defaultUnits=LogUnits.THREADS)
    public double load15;
    @C4_GCLogRecordField(header="pageIn", defaultUnits=LogUnits.PAGES)
    public long pageIn;
    @C4_GCLogRecordField(header="pageOut", defaultUnits=LogUnits.PAGES)
    public long pageOut;
    @C4_GCLogRecordField(header="swapPageIn", defaultUnits=LogUnits.PAGES)
    public int swapPageIn;
    @C4_GCLogRecordField(header="swapPageOut", defaultUnits=LogUnits.PAGES)
    public int swapPageOut;
    @C4_GCLogRecordField(header="majorFaults", defaultUnits=LogUnits.PAGES)
    public int majorFaults;
    @C4_GCLogRecordField(header="cMajorFaults", defaultUnits=LogUnits.PAGES)
    public int cMajorFaults;
    @C4_GCLogRecordField(header="processes", defaultUnits=LogUnits.PROCESSES)
    public long processes;
    @C4_GCLogRecordField(header="procsRunning", defaultUnits=LogUnits.PROCESSES)
    public int procsRunning;
    @C4_GCLogRecordField(header="procsBlocked", defaultUnits=LogUnits.PROCESSES)
    public int procsBlocked;
    @C4_GCLogRecordField(header="procsTotal", defaultUnits=LogUnits.PROCESSES)
    public int procsTotal;
    @C4_GCLogRecordField(header="cgMem_limit_bytes", defaultUnits=LogUnits.BYTES)
    public double cg_mem_limit_bytes;
    @C4_GCLogRecordField(header="cgMem_usage_bytes", defaultUnits=LogUnits.BYTES)
    public double cg_mem_usage_bytes;
    @C4_GCLogRecordField(header="cgMem_max_usage_bytes", defaultUnits=LogUnits.BYTES)
    public double cg_mem_max_usage_bytes;
    @C4_GCLogRecordField(header="cgMem_total_rss_bytes", defaultUnits=LogUnits.BYTES)
    public long cg_mem_total_rss_bytes;
    @C4_GCLogRecordField(header="cgMem_total_shmem_bytes", defaultUnits=LogUnits.BYTES)
    public long cg_mem_total_shmem_bytes;
    @C4_GCLogRecordField(header="cgMem_total_active_file_bytes", defaultUnits=LogUnits.BYTES)
    public long cg_mem_total_active_file_bytes;
    @C4_GCLogRecordField(header="cgMem_total_inactive_file_bytes", defaultUnits=LogUnits.BYTES)
    public long cg_mem_total_inactive_file_bytes;
    @C4_GCLogRecordField(header="cgCPU_usage_ms", defaultUnits=LogUnits.MILLISECONDS)
    public long cg_cpu_usage_ms;
    @C4_GCLogRecordField(header="cgCPU_user_usage_ms", defaultUnits=LogUnits.MILLISECONDS)
    public long cg_cpu_user_usage_ms;
    @C4_GCLogRecordField(header="cgCPU_system_usage_ms", defaultUnits=LogUnits.MILLISECONDS)
    public long cg_cpu_system_usage_ms;
    @C4_GCLogRecordField(header="cgCPU_throttle_nof_periods", defaultUnits=LogUnits.COUNT)
    public long cg_cpu_throttle_nof_periods;
    @C4_GCLogRecordField(header="cgCPU_throttle_nof_throttle", defaultUnits=LogUnits.COUNT)
    public long cg_cpu_throttle_nof_throttle;
    @C4_GCLogRecordField(header="cgCPU_throttle_throttled_ms", defaultUnits=LogUnits.MILLISECONDS)
    public long cg_cpu_throttle_throttled_ms;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int sysMemMax;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"totalSysZingMemAcrossPartitions", "sysZingMemTot"})
    public int sysLinuxMemTotal;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"cacheActiveAnon", "cacheInactiveAnon", "cacheActiveFile", "cacheInactiveFile"})
    public long cacheUseTotal;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PROCESSES, deps={"processes"})
    public long delta_processes;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"pageIn"})
    public long delta_pageIn;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"pageOut"})
    public long delta_pageOut;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"swapPageIn"})
    public long delta_swapPageIn;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"swapPageOut"})
    public long delta_swapPageOut;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cg_cpu_usage_ms"})
    public double cg_cpu_usage_percent;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cg_cpu_usage_ms"})
    public double cg_cpu_usage_percent_30;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cg_cpu_usage_ms"})
    public double cg_cpu_usage_percent_60;
    private RelativeTimestamp eventTimestamp = null;
    private static int eventCounter;
    private static long initialPageIn;
    private static long initialPageOut;
    private static long initialSwapPageIn;
    private static long initialSwapPageOut;
    private static long initialProcesses;
    private static int cgActiveProcessorCount;
    private static final List<CGCpuUsage> cgCpuUsageStats;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return this.eventTimestamp;
    }

    static {
        eventCounter = 0;
        cgCpuUsageStats = Arrays.asList(new CGCpuUsage(0L, TimeUnit.SECONDS, (r, u) -> {
            r.cg_cpu_usage_percent = u;
        }), new CGCpuUsage(30L, TimeUnit.SECONDS, (r, u) -> {
            r.cg_cpu_usage_percent_30 = u;
        }), new CGCpuUsage(60L, TimeUnit.SECONDS, (r, u) -> {
            r.cg_cpu_usage_percent_60 = u;
        }));
    }

    private static final class CGCpuUsage {
        private final List<SysinfoRecord> records = new ArrayList<SysinfoRecord>();
        private final long bucketDuration;
        private final Updater updater;
        private double lastPercent;

        public CGCpuUsage(long bucketDuration, TimeUnit units, Updater updater) {
            this.bucketDuration = units.toMicros(bucketDuration);
            this.updater = updater;
        }

        public void process(SysinfoRecord record) {
            if (!this.records.isEmpty()) {
                SysinfoRecord first = this.records.get(0);
                double first_ts = first.getEventRelativeTimestamp(TimeUnit.MICROSECONDS);
                double cur_ts = record.getEventRelativeTimestamp(TimeUnit.MICROSECONDS);
                double deltaTime = cur_ts - first_ts;
                if (deltaTime > 0.0 && deltaTime >= (double)this.bucketDuration) {
                    this.lastPercent = Math.min(100.0, (double)(100000L * (record.cg_cpu_usage_ms - first.cg_cpu_usage_ms)) / deltaTime / (double)cgActiveProcessorCount);
                    this.records.forEach(r -> this.updater.set((SysinfoRecord)r, this.lastPercent));
                    this.records.clear();
                }
            }
            this.updater.set(record, this.lastPercent);
            this.records.add(record);
        }

        private void reset() {
            this.records.clear();
            this.lastPercent = 0.0;
        }
    }

    private static interface Updater {
        public void set(SysinfoRecord var1, double var2);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<SysinfoRecord> {
        boolean useCgCPUStatOnly;
        private C4_LogHeader header;

        public Parser() {
            super(SysinfoRecord.class);
        }

        @Override
        protected boolean parseHeaderImpl(String header) throws ParserException {
            header = header.replaceAll("throtttle", "throttle");
            header = header.replace("swapMax(MB)", "swapMax");
            return super.parseHeaderImpl(header);
        }

        @Override
        protected void computeCalculatedFields(SysinfoRecord record) {
            record.eventTimestamp = RelativeTimestamp.of(record.end_s, TimeUnit.SECONDS);
            record.cacheUseTotal = record.cacheActiveAnon + record.cacheInactiveAnon + record.cacheActiveFile + record.cacheInactiveFile;
            Integer ramMax = this.header.system_ram_total;
            if (ramMax != null) {
                sysMemMax = ramMax;
                record.sysLinuxMemTotal = sysMemMax - Math.max(record.totalSysZingMemAcrossPartitions, record.sysZingMemTot);
            }
            if (eventCounter == 0) {
                initialPageIn = record.pageIn;
                initialPageOut = record.pageOut;
                initialSwapPageIn = record.swapPageIn;
                initialSwapPageOut = record.swapPageOut;
                initialProcesses = record.processes;
                cgActiveProcessorCount = this.header.cg_active_processor_count;
                boolean bl = this.useCgCPUStatOnly = record.cg_cpu_usage_ms / (record.cg_cpu_system_usage_ms + record.cg_cpu_user_usage_ms + 1L) > 2L;
            }
            if (this.useCgCPUStatOnly) {
                record.cg_cpu_usage_ms = record.cg_cpu_system_usage_ms + record.cg_cpu_user_usage_ms;
            }
            cgCpuUsageStats.forEach(u -> u.process(record));
            eventCounter++;
            record.delta_pageIn = record.pageIn - initialPageIn;
            record.delta_pageOut = record.pageOut - initialPageOut;
            record.delta_swapPageIn = (long)record.swapPageIn - initialSwapPageIn;
            record.delta_swapPageOut = (long)record.swapPageOut - initialSwapPageOut;
            record.delta_processes = record.processes - initialProcesses;
        }

        @Override
        public void init_impl(Lookup lookup) {
            eventCounter = 0;
            this.header = lookup.lookup(C4_LogHeader.class);
            cgCpuUsageStats.forEach(rec$ -> ((CGCpuUsage)rec$).reset());
        }
    }
}

