/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="SPSH", data_marker="SPS")
@C4_FieldsDescription(file="c4/SafepointRecord")
public final class SafepointRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="lock", defaultUnits=LogUnits.MILLISECONDS)
    public double threads_lock_ms;
    @C4_GCLogRecordField(header="suspend", defaultUnits=LogUnits.MILLISECONDS)
    public double suspend_ms;
    @C4_GCLogRecordField(header="gclocker", defaultUnits=LogUnits.MILLISECONDS)
    public double gclocker_engaged_ms;
    @C4_GCLogRecordField(header="notify", defaultUnits=LogUnits.MILLISECONDS)
    public double notify_ms;
    @C4_GCLogRecordField(header="wait", defaultUnits=LogUnits.MILLISECONDS)
    public double wait_ms;
    @C4_GCLogRecordField(header="wext_counts", defaultUnits=LogUnits.COUNT)
    public int ttsp_extended_times;
    @C4_GCLogRecordField(header="wext_reasons")
    public String reasons;
    @C4_GCLogRecordField(header="resuspend", defaultUnits=LogUnits.MILLISECONDS)
    public double resuspend_ms;
    @C4_GCLogRecordField(header="cleanup", defaultUnits=LogUnits.MILLISECONDS)
    public double cleanup_ms;
    @C4_GCLogRecordField(header="op_time", defaultUnits=LogUnits.MILLISECONDS)
    public double op_ms;
    @C4_GCLogRecordField(header="wakeup", defaultUnits=LogUnits.MILLISECONDS)
    public double wakeup_ms;
    @C4_GCLogRecordField(header="total(ms)", defaultUnits=LogUnits.MILLISECONDS)
    public double total_time_ms;
    @C4_GCLogRecordField(header="op_name")
    public String vm_op_name;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double safepoint_end_time_elapsed_secs;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MILLISECONDS, deps={"wait_ms", "notify_ms"})
    public double ttsp_ms;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MILLISECONDS, deps={"total_time_ms"})
    public double total_no_ttsp_time_ms;
    @LogRecordCalculatedField
    public String op_name_label;
    private RelativeTimestamp endTime = null;

    @Override
    public LogRecord.PhaseInfoList getEventPhasesImpl() {
        LogRecord.PhaseInfoList result = new LogRecord.PhaseInfoList(this.vm_op_name + " Safepoint", TimeUnit.MILLISECONDS);
        RelativeTimestamp safepoint_work_done = this.endTime.shift(-this.wakeup_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp safepoint_reached = safepoint_work_done.shift(-this.total_time_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp all_threads_notified = safepoint_reached.shift(-this.wait_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp gpgc_gclocker_engaged = all_threads_notified.shift(-this.notify_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp gpgc_suspend_done = gpgc_gclocker_engaged.shift(-this.gclocker_engaged_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp safepoint_start = gpgc_suspend_done.shift(-this.suspend_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp acquire_threads_lock = safepoint_start.shift(-this.threads_lock_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp gpgc_resuspend_done = safepoint_reached.shift(this.resuspend_ms, LogUnits.MILLISECONDS);
        RelativeTimestamp cleanup_tasks_complete = gpgc_resuspend_done.shift(this.cleanup_ms, LogUnits.MILLISECONDS);
        result.add(new LogRecord.PhaseInfo(acquire_threads_lock, safepoint_start, "Threads Lock Acquisition"));
        result.add(new LogRecord.PhaseInfo(safepoint_start, gpgc_suspend_done, "GPGC Suspend"));
        result.add(new LogRecord.PhaseInfo(gpgc_suspend_done, gpgc_gclocker_engaged, "GPGC Locker Engaging"));
        result.add(new LogRecord.PhaseInfo(gpgc_gclocker_engaged, all_threads_notified, "Threads Notification"));
        result.add(new LogRecord.PhaseInfo(all_threads_notified, safepoint_reached, "Waiting for Threads to Suspend"));
        result.add(new LogRecord.PhaseInfo(safepoint_reached, gpgc_resuspend_done, "Resuspending Threads"));
        result.add(new LogRecord.PhaseInfo(gpgc_resuspend_done, cleanup_tasks_complete, "Cleanup Task"));
        result.add(new LogRecord.PhaseInfo(cleanup_tasks_complete, safepoint_work_done, this.vm_op_name + " Operation Time"));
        result.add(new LogRecord.PhaseInfo(safepoint_work_done, this.endTime, "Waking Up Threads"));
        return result;
    }

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return this.endTime;
    }

    @Override
    public String toString() {
        return "SafepointInfo: @" + String.format("%3.3f", this.getEventRelativeTimestamp().getInUnits(LogUnits.MINUTES)) + " -- " + this.vm_op_name + " " + this.total_time_ms;
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<SafepointRecord> {
        private final Map<String, String> typeMap = new HashMap<String, String>();
        private final StringBuilder buffer = new StringBuilder();
        private static final String[] prefixes = new String[]{"VMThread", "GetOrSet"};

        public Parser() {
            super(SafepointRecord.class);
            this.typeMap.put("NewGC_pause1", "New GC Pause 1 Duration");
            this.typeMap.put("NewGC_pause2", "New GC Pause 2 Duration");
            this.typeMap.put("NewGC_pause3", "New GC Pause 3 Duration");
            this.typeMap.put("NewGC_pause4", "New GC Pause 4 Duration");
            this.typeMap.put("OldGC_pause2", "Old GC Pause 2 Duration");
            this.typeMap.put("OldGC_pause3", "Old GC Pause 3 Duration");
            this.typeMap.put("OldGC_pause4", "Old GC Pause 4 Duration");
            this.typeMap.put("PrintJNI", "Print JNI Pause");
            this.typeMap.put("ParallelGCSystemGC", "ParallelGC System GC Pause");
            this.typeMap.put("ReportJavaOutOfMemory", "Report JavaOutOfMemory Pause");
        }

        @Override
        protected void computeCalculatedFields(SafepointRecord record) {
            record.ttsp_ms = record.wait_ms + record.notify_ms;
            record.total_no_ttsp_time_ms = record.total_time_ms - record.ttsp_ms;
            record.endTime = RelativeTimestamp.of(record.safepoint_end_time_elapsed_secs, LogUnits.SECONDS);
            record.op_name_label = this.getOpNameLabel(record.vm_op_name);
        }

        String getOpNameLabel(String vm_op_name) {
            String type = this.typeMap.get(vm_op_name);
            if (type == null) {
                String name = vm_op_name;
                int pos = name.indexOf(45);
                if (pos > 0) {
                    name = vm_op_name.substring(0, pos);
                    type = this.typeMap.get(name);
                }
                if (type == null) {
                    this.buffer.setLength(0);
                    boolean wasUpperCase = true;
                    boolean forceUp = true;
                    int i = 0;
                    for (String prefix : prefixes) {
                        if (!name.startsWith(prefix)) continue;
                        this.buffer.append(prefix);
                        i = this.buffer.length();
                        break;
                    }
                    while (i < name.length()) {
                        char c = name.charAt(i);
                        if (c == '_') {
                            forceUp = true;
                        } else {
                            boolean isUpperCase;
                            if (forceUp) {
                                c = Character.toUpperCase(c);
                                wasUpperCase = true;
                                forceUp = false;
                            }
                            if (!(isUpperCase = Character.isUpperCase(c)) && wasUpperCase && i > 1) {
                                this.buffer.insert(this.buffer.length() - 1, ' ');
                            }
                            wasUpperCase = isUpperCase;
                            this.buffer.append(c);
                        }
                        ++i;
                    }
                    type = this.buffer.append(" Pause").toString().trim();
                    this.typeMap.put(vm_op_name, type);
                }
            }
            return type;
        }
    }
}

