/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="NUMASTATSH", data_marker="NUMASTATS")
@C4_FieldsDescription(file="c4/NumastatRecord")
public final class NumastatRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="node")
    public int node;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"numa_hit"})
    @C4_GCLogRecordField(header="numa_hit", defaultUnits=LogUnits.COUNT)
    public long numa_hit;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"numa_miss"})
    @C4_GCLogRecordField(header="numa_miss", defaultUnits=LogUnits.COUNT)
    public long numa_miss;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"numa_foreign"})
    @C4_GCLogRecordField(header="numa_foreign", defaultUnits=LogUnits.COUNT)
    public long numa_foreign;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"interleave_hit"})
    @C4_GCLogRecordField(header="interleave_hit", defaultUnits=LogUnits.COUNT)
    public long interleave_hit;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"local_node"})
    @C4_GCLogRecordField(header="local_node", defaultUnits=LogUnits.COUNT)
    public long local_node;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"other_node"})
    @C4_GCLogRecordField(header="other_node", defaultUnits=LogUnits.COUNT)
    public long other_node;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"other_node"})
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<NumastatRecord> {
        Map<Integer, NumastatRecord> init = new HashMap<Integer, NumastatRecord>();

        public Parser() {
            super(NumastatRecord.class);
        }

        @Override
        protected void computeCalculatedFields(NumastatRecord record) {
            int node = record.node;
            if (!this.init.containsKey(node)) {
                NumastatRecord r = new NumastatRecord();
                r.node = record.node;
                r.numa_hit = record.numa_hit;
                r.numa_miss = record.numa_miss;
                r.numa_foreign = record.numa_foreign;
                r.interleave_hit = record.interleave_hit;
                r.local_node = record.local_node;
                r.other_node = record.other_node;
                this.init.put(node, r);
            }
            NumastatRecord first = this.init.get(node);
            record.numa_hit -= first.numa_hit;
            record.numa_miss -= first.numa_miss;
            record.numa_foreign -= first.numa_foreign;
            record.interleave_hit -= first.interleave_hit;
            record.local_node -= first.local_node;
            record.other_node -= first.other_node;
        }

        @Override
        public void init_impl(Lookup lookup) {
            this.init = new HashMap<Integer, NumastatRecord>();
        }
    }
}

