/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DoubleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;

@C4_LogDataRecord(header_marker="COMPSTATSH", data_marker="COMPSTATS")
@C4_FieldsDescription(file="c4/CompstatsRecord")
public final class CompstatsRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="Tier")
    public String tier;
    @C4_GCLogRecordField(header="Threads#Total", defaultUnits=LogUnits.THREADS)
    public int threads_total;
    @C4_GCLogRecordField(header="Threads#Active", defaultUnits=LogUnits.THREADS)
    public int threads_active;
    @C4_GCLogRecordField(header="CompileCounts#FullMethodCompiles", defaultUnits=LogUnits.METHODS)
    public long comp_fullMethodCompiles;
    @C4_GCLogRecordField(header="CompileCounts#OSRMethodCompiles", defaultUnits=LogUnits.METHODS)
    public long comp_osrMethodCompiles;
    @C4_GCLogRecordField(header="CompileCounts#MethodFailToInstall", defaultUnits=LogUnits.METHODS)
    public long comp_methodFailToInstall;
    @C4_GCLogRecordField(header="CompileCounts#OSRFailToInstall", defaultUnits=LogUnits.METHODS)
    public long comp_osrFailToInstall;
    @C4_GCLogRecordField(header="CompileCounts#FullMethodEvicted", defaultUnits=LogUnits.METHODS)
    public long comp_fullMethodEvicted;
    @C4_GCLogRecordField(header="CompileCounts#OSRMethodEvicted", defaultUnits=LogUnits.METHODS)
    public long comp_osrMethodEvicted;
    @C4_GCLogRecordField(header="CompileCounts#HotRankMethodCompiles", defaultUnits=LogUnits.METHODS)
    public long comp_hotRankMethodCompiles;
    @C4_GCLogRecordField(header="CompileCounts#WarmRankMethodCompiles", defaultUnits=LogUnits.METHODS)
    public long comp_warmRankMethodCompiles;
    @C4_GCLogRecordField(header="CompileCounts#SkippedMethodPromotions", defaultUnits=LogUnits.METHODS)
    public long comp_promotionSkippedMethods;
    @C4_GCLogRecordField(header="StashCounts#MethodStashCompiles", defaultUnits=LogUnits.METHODS)
    public long stash_fullMethodCompiles;
    @C4_GCLogRecordField(header="StashCounts#OSRStashCompiles", defaultUnits=LogUnits.METHODS)
    public long stash_osrMethodCompiles;
    @C4_GCLogRecordField(header="StashCounts#MethodStashFailed", defaultUnits=LogUnits.METHODS)
    public long stash_methodFailToInstall;
    @C4_GCLogRecordField(header="StashCounts#OSRStashFailed", defaultUnits=LogUnits.METHODS)
    public long stash_osrFailToInstall;
    @C4_GCLogRecordField(header="StashCounts#MethodStashEvicted", defaultUnits=LogUnits.METHODS)
    public long stash_fullMethodEvicted;
    @C4_GCLogRecordField(header="StashCounts#OSRStashEvicted", defaultUnits=LogUnits.METHODS)
    public long stash_osrMethodEvicted;
    @C4_GCLogRecordField(header="TotalTimes ms#CPUTime", defaultUnits=LogUnits.MILLISECONDS)
    public long cpuTime;
    @C4_GCLogRecordField(header="TotalTimes ms#WallClockTime", defaultUnits=LogUnits.MILLISECONDS)
    public long wallClockTime;
    @C4_GCLogRecordField(header="TotalTimes ms#WaitInQueueTime", defaultUnits=LogUnits.MILLISECONDS)
    public long waitInQueueTime;
    @C4_GCLogRecordField(header="WaitTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10;
    @C4_GCLogRecordField(header="WaitTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long waitTimes_100;
    @C4_GCLogRecordField(header="WaitTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_1000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_100000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long waitTimes_1000000;
    @C4_GCLogRecordField(header="WaitTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long waitTimes_10000000;
    @C4_GCLogRecordField(header="CompileTimes Histogram#0-9", defaultUnits=LogUnits.METHODS)
    public long compileTimes_10;
    @C4_GCLogRecordField(header="CompileTimes Histogram#10-99", defaultUnits=LogUnits.METHODS)
    public long compileTimes_100;
    @C4_GCLogRecordField(header="CompileTimes Histogram#100-999", defaultUnits=LogUnits.METHODS)
    public long compileTimes_1000;
    @C4_GCLogRecordField(header="CompileTimes Histogram#1000-9999", defaultUnits=LogUnits.METHODS)
    public long compileTimes_10000;
    @C4_GCLogRecordField(header="CompileTimes Histogram#10000-99999", defaultUnits=LogUnits.METHODS)
    public long compileTimes_100000;
    @C4_GCLogRecordField(header="CompileTimes Histogram#100000-999999", defaultUnits=LogUnits.METHODS)
    public long compileTimes_1000000;
    @C4_GCLogRecordField(header="CompileTimes Histogram#1000000-INF", defaultUnits=LogUnits.METHODS)
    public long compileTimes_10000000;
    @C4_GCLogRecordField(header="CompQueue#Peak", defaultUnits=LogUnits.METHODS)
    public int comp_queue_peak;
    @C4_GCLogRecordField(header="CompQueue#Active", defaultUnits=LogUnits.METHODS)
    public int comp_queue_active;
    @C4_GCLogRecordField(header="StashQueue#Peak", defaultUnits=LogUnits.METHODS)
    public int stash_queue_peak;
    @C4_GCLogRecordField(header="StashQueue#Active", defaultUnits=LogUnits.METHODS)
    public int stash_queue_active;
    @C4_GCLogRecordField(header="CNC Queue#Peak", defaultUnits=LogUnits.METHODS)
    public int cnc_queue_peak;
    @C4_GCLogRecordField(header="CNC Queue#Active", defaultUnits=LogUnits.METHODS)
    public int cnc_queue_active;
    @C4_GCLogRecordField(header="CompQueueByHotRank#Peak", defaultUnits=LogUnits.METHODS)
    public int comp_queue_by_hot_rank_peak;
    @C4_GCLogRecordField(header="CompQueueByHotRank#Active", defaultUnits=LogUnits.METHODS)
    public int comp_queue_by_hot_rank_active;
    @C4_GCLogRecordField(header="CompQueueByWarmRank#Peak", defaultUnits=LogUnits.METHODS)
    public int comp_queue_by_warm_rank_peak;
    @C4_GCLogRecordField(header="CompQueueByWarmRank#Active", defaultUnits=LogUnits.METHODS)
    public int comp_queue_by_warm_rank_active;

    public static final class Parser
    extends C4_DoubleHeaderDataParser<CompstatsRecord> {
        public Parser() {
            super(CompstatsRecord.class);
        }

        @Override
        protected boolean parseHeaderImpl(String header) throws ParserException {
            boolean res;
            if (header.startsWith("Tier FullMethodCompiles OSRMethodCompiles MethodFailToInstall OSRFailToInstall TotalCPUTimeMS TotalWallClockTimeMS TotalWaitInQueueTimeMS : WaitTimes0ms 10ms 100ms 1000ms 10000ms 100000ms 1000000ms : CompileTimes0ms 10ms 100ms 1000ms 10000ms 100000ms 1000000ms")) {
                res = super.parseHeaderImpl("     CompileCounts                                                             TotalTimes ms                         : WaitTimes Histogram                                               : CompileTimes Histogram ]");
                res &= super.parseHeaderImpl("Tier FullMethodCompiles OSRMethodCompiles MethodFailToInstall OSRFailToInstall CPUTime WallClockTime WaitInQueueTime : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF ]");
            } else if (header.startsWith("Tier FullMethodCompiles OSRMethodCompiles MethodFailToInstall OSRFailToInstall TotalAcutalTimeMS TotalWallClockTimeMS : 0ms 10ms 100ms 1000ms 10000ms 100000ms 1000000ms")) {
                res = super.parseHeaderImpl("     CompileCounts                                                             TotalTimes ms         : CompileTimes Histogram ]");
                res &= super.parseHeaderImpl("Tier FullMethodCompiles OSRMethodCompiles MethodFailToInstall OSRFailToInstall CPUTime WallClockTime : 0-9 10-99 100-999 1000-9999 10000-99999 100000-999999 1000000-INF ]");
            } else {
                res = super.parseHeaderImpl(header.replace(" Counts       ", " CompileCounts"));
            }
            return res;
        }
    }
}

