/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.custom;

import com.azul.log.parser.impl.c4.custom.C4_CustomLineParsersSupport;
import com.azul.log.parser.impl.c4.custom.C4_CustomLogLineParser;
import com.azul.log.parser.impl.c4.custom.C4_CustomRNLogParserFactory;
import com.azul.log.parser.spi.ParserFactory;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.parser.support.SingleModifiableFileLogModel;
import com.azul.log.utils.CommonUtils;
import com.azul.tools.compile2xlog.impl.LogTransformer;
import com.azul.zing.GulpZing;
import com.azul.zing.ZingConsoleLog;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CancellationException;

public final class C4_CustomVMLogParserFactory
extends ParserFactory<C4_CustomLogLineParser> {
    private UserInteractionHandler ui;

    public C4_CustomVMLogParserFactory() {
        super(ParserFactory.Confidence.HIGH, new String[][]{{"1 started", "COMPILE_STARTH"}});
    }

    @Override
    public C4_CustomLogLineParser createParser(Path path, UserInteractionHandler ui) {
        this.ui = ui;
        return new C4_CustomLogLineParser(new VM_SingleFileLogModel("VM", path));
    }

    private final class VM_SingleFileLogModel
    extends SingleModifiableFileLogModel {
        public VM_SingleFileLogModel(String id, Path file) {
            super(id, file);
            InputStream resourceAsStream = C4_CustomRNLogParserFactory.class.getResourceAsStream("/graphJsons/vm.json");
            if (resourceAsStream == null) {
                throw new RuntimeException("graphJsons/vm.json not found in GCLogAnalyzer2.jar");
            }
            C4_CustomLineParsersSupport.createAndRegisterParsersFromString(id, CommonUtils.inputStreamToString(resourceAsStream));
        }

        @Override
        protected Path modifyFile(Path file) {
            Path transformedVMFile;
            Path path = transformedVMFile = Files.isWritable(file.getParent()) ? Paths.get(file.toAbsolutePath().toString() + ".xlog", new String[0]) : Paths.get(System.getProperty("java.io.tmpdir"), file.getFileName() + ".xlog");
            if (Files.exists(transformedVMFile, new LinkOption[0])) {
                UserInteractionHandler.Response response = C4_CustomVMLogParserFactory.this.ui.confirm("Pre-processed VM log file already exists", "File " + transformedVMFile.getFileName() + " already exists. Do you want to open it ?");
                switch (response) {
                    case YES: {
                        return transformedVMFile;
                    }
                    case CANCEL: {
                        throw new CancellationException();
                    }
                }
            }
            ZingConsoleLog zingConsoleLog = GulpZing.gulpConsole(file.toFile());
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter((Writer)new FileWriter(transformedVMFile.toFile()), true);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Writing to file '%s' failed", transformedVMFile.getFileName()));
            }
            LogTransformer transformer = new LogTransformer();
            transformer.process(zingConsoleLog, (vmTime, line) -> String.format("%.3f: [%s]", (double)vmTime.toMilliseconds() / 1000.0, line), printWriter);
            printWriter.close();
            return transformedVMFile;
        }
    }
}

